/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class MD4Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 16;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X;
    private int xOff;

    public MD4Digest() {
        MD4Digest mD4Digest = this;
        mD4Digest.X = new int[16];
        mD4Digest.reset();
    }

    public MD4Digest(MD4Digest mD4Digest) {
        super(mD4Digest);
        this.X = new int[16];
        this.copyIn(mD4Digest);
    }

    private void copyIn(MD4Digest mD4Digest) {
        MD4Digest mD4Digest2 = object;
        MD4Digest mD4Digest3 = mD4Digest;
        super.copyIn(mD4Digest);
        ((MD4Digest)object).H1 = mD4Digest.H1;
        ((MD4Digest)object).H2 = mD4Digest.H2;
        ((MD4Digest)object).H3 = mD4Digest.H3;
        ((MD4Digest)object).H4 = mD4Digest.H4;
        Object object = ((MD4Digest)object).X;
        int n = mD4Digest3.X.length;
        System.arraycopy(mD4Digest3.X, 0, object, 0, n);
        mD4Digest2.xOff = mD4Digest3.xOff;
    }

    private void unpackWord(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        int n3 = n2 + 1;
        byArray[n3] = (byte)(n >>> 8);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >>> 16);
        n3 = n2 + 3;
        byArray[n3] = (byte)(n >>> 24);
    }

    private int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int G(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    @Override
    public String getAlgorithmName() {
        return "MD4";
    }

    @Override
    public int getDigestSize() {
        return 16;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2;
        MD4Digest mD4Digest = this;
        int[] nArray = mD4Digest.X;
        int n3 = mD4Digest.xOff;
        this.xOff = n2 = n3 + 1;
        nArray[n3] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        if (n2 == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        if (((MD4Digest)object).xOff > 14) {
            ((MD4Digest)object).processBlock();
        }
        Object object = ((MD4Digest)object).X;
        object[14] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        ((MD4Digest)object).X[15] = (int)(l >>> 32);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        MD4Digest mD4Digest = this;
        mD4Digest.finish();
        mD4Digest.unpackWord(mD4Digest.H1, byArray, n);
        mD4Digest.unpackWord(mD4Digest.H2, byArray, n + 4);
        mD4Digest.unpackWord(mD4Digest.H3, byArray, n + 8);
        mD4Digest.unpackWord(mD4Digest.H4, byArray, n + 12);
        mD4Digest.reset();
        return 16;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.xOff = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void processBlock() {
        MD4Digest mD4Digest = this;
        int n = mD4Digest.H1;
        int n2 = mD4Digest.H2;
        int n3 = n2;
        MD4Digest mD4Digest2 = this;
        int n4 = mD4Digest2.H3;
        int n5 = n4;
        MD4Digest mD4Digest3 = this;
        int n6 = mD4Digest3.H4;
        MD4Digest mD4Digest4 = this;
        n = mD4Digest4.rotateLeft(n + this.F(n3, n5, n6) + this.X[0], 3);
        n5 = mD4Digest3.rotateLeft(n6 + mD4Digest4.F(n, n3, n5) + this.X[1], 7);
        n3 = mD4Digest2.rotateLeft(n4 + mD4Digest3.F(n5, n, n3) + this.X[2], 11);
        n6 = mD4Digest.rotateLeft(n2 + mD4Digest2.F(n3, n5, n) + this.X[3], 19);
        MD4Digest mD4Digest5 = this;
        int n7 = n3;
        MD4Digest mD4Digest6 = this;
        MD4Digest mD4Digest7 = this;
        n = mD4Digest7.rotateLeft(n + this.F(n6, n3, n5) + this.X[4], 3);
        n3 = mD4Digest6.rotateLeft(n5 + mD4Digest7.F(n, n6, n3) + this.X[5], 7);
        n5 = mD4Digest5.rotateLeft(n7 + mD4Digest6.F(n3, n, n6) + this.X[6], 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest5.F(n5, n3, n) + this.X[7], 19);
        MD4Digest mD4Digest8 = this;
        MD4Digest mD4Digest9 = this;
        MD4Digest mD4Digest10 = this;
        n = mD4Digest10.rotateLeft(n + this.F(n6, n5, n3) + this.X[8], 3);
        n3 = mD4Digest9.rotateLeft(n3 + mD4Digest10.F(n, n6, n5) + this.X[9], 7);
        n5 = mD4Digest8.rotateLeft(n5 + mD4Digest9.F(n3, n, n6) + this.X[10], 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest8.F(n5, n3, n) + this.X[11], 19);
        MD4Digest mD4Digest11 = this;
        MD4Digest mD4Digest12 = this;
        MD4Digest mD4Digest13 = this;
        n = mD4Digest13.rotateLeft(n + this.F(n6, n5, n3) + this.X[12], 3);
        n3 = mD4Digest12.rotateLeft(n3 + mD4Digest13.F(n, n6, n5) + this.X[13], 7);
        n5 = mD4Digest11.rotateLeft(n5 + mD4Digest12.F(n3, n, n6) + this.X[14], 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest11.F(n5, n3, n) + this.X[15], 19);
        MD4Digest mD4Digest14 = this;
        MD4Digest mD4Digest15 = this;
        MD4Digest mD4Digest16 = this;
        n = mD4Digest16.rotateLeft(n + this.G(n6, n5, n3) + this.X[0] + 1518500249, 3);
        n3 = mD4Digest15.rotateLeft(n3 + mD4Digest16.G(n, n6, n5) + this.X[4] + 1518500249, 5);
        n5 = mD4Digest14.rotateLeft(n5 + mD4Digest15.G(n3, n, n6) + this.X[8] + 1518500249, 9);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest14.G(n5, n3, n) + this.X[12] + 1518500249, 13);
        MD4Digest mD4Digest17 = this;
        MD4Digest mD4Digest18 = this;
        MD4Digest mD4Digest19 = this;
        n = mD4Digest19.rotateLeft(n + this.G(n6, n5, n3) + this.X[1] + 1518500249, 3);
        n3 = mD4Digest18.rotateLeft(n3 + mD4Digest19.G(n, n6, n5) + this.X[5] + 1518500249, 5);
        n5 = mD4Digest17.rotateLeft(n5 + mD4Digest18.G(n3, n, n6) + this.X[9] + 1518500249, 9);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest17.G(n5, n3, n) + this.X[13] + 1518500249, 13);
        MD4Digest mD4Digest20 = this;
        MD4Digest mD4Digest21 = this;
        MD4Digest mD4Digest22 = this;
        n = mD4Digest22.rotateLeft(n + this.G(n6, n5, n3) + this.X[2] + 1518500249, 3);
        n3 = mD4Digest21.rotateLeft(n3 + mD4Digest22.G(n, n6, n5) + this.X[6] + 1518500249, 5);
        n5 = mD4Digest20.rotateLeft(n5 + mD4Digest21.G(n3, n, n6) + this.X[10] + 1518500249, 9);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest20.G(n5, n3, n) + this.X[14] + 1518500249, 13);
        MD4Digest mD4Digest23 = this;
        MD4Digest mD4Digest24 = this;
        MD4Digest mD4Digest25 = this;
        n = mD4Digest25.rotateLeft(n + this.G(n6, n5, n3) + this.X[3] + 1518500249, 3);
        n3 = mD4Digest24.rotateLeft(n3 + mD4Digest25.G(n, n6, n5) + this.X[7] + 1518500249, 5);
        n5 = mD4Digest23.rotateLeft(n5 + mD4Digest24.G(n3, n, n6) + this.X[11] + 1518500249, 9);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest23.G(n5, n3, n) + this.X[15] + 1518500249, 13);
        MD4Digest mD4Digest26 = this;
        MD4Digest mD4Digest27 = this;
        MD4Digest mD4Digest28 = this;
        n = mD4Digest28.rotateLeft(n + this.H(n6, n5, n3) + this.X[0] + 1859775393, 3);
        n3 = mD4Digest27.rotateLeft(n3 + mD4Digest28.H(n, n6, n5) + this.X[8] + 1859775393, 9);
        n5 = mD4Digest26.rotateLeft(n5 + mD4Digest27.H(n3, n, n6) + this.X[4] + 1859775393, 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest26.H(n5, n3, n) + this.X[12] + 1859775393, 15);
        MD4Digest mD4Digest29 = this;
        MD4Digest mD4Digest30 = this;
        MD4Digest mD4Digest31 = this;
        n = mD4Digest31.rotateLeft(n + this.H(n6, n5, n3) + this.X[2] + 1859775393, 3);
        n3 = mD4Digest30.rotateLeft(n3 + mD4Digest31.H(n, n6, n5) + this.X[10] + 1859775393, 9);
        n5 = mD4Digest29.rotateLeft(n5 + mD4Digest30.H(n3, n, n6) + this.X[6] + 1859775393, 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest29.H(n5, n3, n) + this.X[14] + 1859775393, 15);
        MD4Digest mD4Digest32 = this;
        MD4Digest mD4Digest33 = this;
        MD4Digest mD4Digest34 = this;
        n = mD4Digest34.rotateLeft(n + this.H(n6, n5, n3) + this.X[1] + 1859775393, 3);
        n3 = mD4Digest33.rotateLeft(n3 + mD4Digest34.H(n, n6, n5) + this.X[9] + 1859775393, 9);
        n5 = mD4Digest32.rotateLeft(n5 + mD4Digest33.H(n3, n, n6) + this.X[5] + 1859775393, 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest32.H(n5, n3, n) + this.X[13] + 1859775393, 15);
        MD4Digest mD4Digest35 = this;
        MD4Digest mD4Digest36 = this;
        MD4Digest mD4Digest37 = this;
        n = mD4Digest37.rotateLeft(n + this.H(n6, n5, n3) + this.X[3] + 1859775393, 3);
        n3 = mD4Digest36.rotateLeft(n3 + mD4Digest37.H(n, n6, n5) + this.X[11] + 1859775393, 9);
        n5 = mD4Digest35.rotateLeft(n5 + mD4Digest36.H(n3, n, n6) + this.X[7] + 1859775393, 11);
        n6 = mD4Digest.rotateLeft(n6 + mD4Digest35.H(n5, n3, n) + this.X[15] + 1859775393, 15);
        mD4Digest.H1 += n;
        mD4Digest.H2 += n6;
        mD4Digest.H3 += n5;
        mD4Digest.H4 += n3;
        mD4Digest.xOff = 0;
        n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public Memoable copy() {
        return new MD4Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((MD4Digest)memoable);
    }
}

