/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GeneralDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA1Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 20;
    private static final int Y1 = 1518500249;
    private static final int Y2 = 1859775393;
    private static final int Y3 = -1894007588;
    private static final int Y4 = -899497514;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int[] X;
    private int xOff;

    public SHA1Digest() {
        SHA1Digest sHA1Digest = this;
        sHA1Digest.X = new int[80];
        sHA1Digest.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.X = new int[80];
        this.copyIn(sHA1Digest);
    }

    public SHA1Digest(byte[] byArray) {
        super(byArray);
        this.X = new int[80];
        this.H1 = Pack.bigEndianToInt(byArray, 16);
        this.H2 = Pack.bigEndianToInt(byArray, 20);
        this.H3 = Pack.bigEndianToInt(byArray, 24);
        this.H4 = Pack.bigEndianToInt(byArray, 28);
        this.H5 = Pack.bigEndianToInt(byArray, 32);
        this.xOff = Pack.bigEndianToInt(byArray, 36);
        for (int k = 0; k != this.xOff; ++k) {
            this.X[k] = Pack.bigEndianToInt(byArray, k * 4 + 40);
        }
    }

    private void copyIn(SHA1Digest sHA1Digest) {
        SHA1Digest sHA1Digest2 = object;
        SHA1Digest sHA1Digest3 = sHA1Digest;
        ((SHA1Digest)object).H1 = sHA1Digest.H1;
        ((SHA1Digest)object).H2 = sHA1Digest.H2;
        ((SHA1Digest)object).H3 = sHA1Digest.H3;
        ((SHA1Digest)object).H4 = sHA1Digest.H4;
        ((SHA1Digest)object).H5 = sHA1Digest.H5;
        Object object = ((SHA1Digest)object).X;
        int n = sHA1Digest3.X.length;
        System.arraycopy(sHA1Digest3.X, 0, object, 0, n);
        sHA1Digest2.xOff = sHA1Digest3.xOff;
    }

    private int f(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int h(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int g(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-1";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    public void processWord(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n = n + 1;
        int n3 = n2 | (byArray[n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n = this.xOff;
        this.X[n] = n3;
        this.xOff = n + 1;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    public void processLength(long l) {
        if (((SHA1Digest)object).xOff > 14) {
            ((SHA1Digest)object).processBlock();
        }
        Object object = ((SHA1Digest)object).X;
        object[14] = (int)(l >>> 32);
        ((SHA1Digest)object).X[15] = (int)l;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA1Digest sHA1Digest = this;
        sHA1Digest.finish();
        Pack.intToBigEndian(sHA1Digest.H1, byArray, n);
        Pack.intToBigEndian(sHA1Digest.H2, byArray, n + 4);
        Pack.intToBigEndian(sHA1Digest.H3, byArray, n + 8);
        Pack.intToBigEndian(sHA1Digest.H4, byArray, n + 12);
        Pack.intToBigEndian(sHA1Digest.H5, byArray, n + 16);
        sHA1Digest.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        int n = 0;
        while (true) {
            int[] nArray = this.X;
            if (n == this.X.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void processBlock() {
        int n;
        int n2;
        int n3;
        for (n3 = 16; n3 < 80; ++n3) {
            int[] nArray = this.X;
            n2 = nArray[n3 - 3] ^ nArray[n3 - 8] ^ nArray[n3 - 14] ^ nArray[n3 - 16];
            this.X[n3] = n2 << 1 | n2 >>> 31;
        }
        SHA1Digest sHA1Digest = this;
        n3 = sHA1Digest.H1;
        n2 = sHA1Digest.H2;
        int n4 = sHA1Digest.H3;
        int n5 = sHA1Digest.H4;
        int n6 = sHA1Digest.H5;
        int n7 = 0;
        for (n = 0; n < 4; ++n) {
            n6 = a.a((n3 << 5 | n3 >>> 27) + this.f(n2, n4, n5), this.X[n7++], 1518500249, n6);
            n2 = n2 << 30 | n2 >>> 2;
            n5 = a.a((n6 << 5 | n6 >>> 27) + this.f(n3, n2, n4), this.X[n7++], 1518500249, n5);
            n3 = n3 << 30 | n3 >>> 2;
            n4 = a.a((n5 << 5 | n5 >>> 27) + this.f(n6, n3, n2), this.X[n7++], 1518500249, n4);
            n6 = n6 << 30 | n6 >>> 2;
            n2 = a.a((n4 << 5 | n4 >>> 27) + this.f(n5, n6, n3), this.X[n7++], 1518500249, n2);
            n5 = n5 << 30 | n5 >>> 2;
            n3 = a.a((n2 << 5 | n2 >>> 27) + this.f(n4, n5, n6), this.X[n7++], 1518500249, n3);
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n < 4; ++n) {
            n6 = a.a((n3 << 5 | n3 >>> 27) + this.h(n2, n4, n5), this.X[n7++], 1859775393, n6);
            n2 = n2 << 30 | n2 >>> 2;
            n5 = a.a((n6 << 5 | n6 >>> 27) + this.h(n3, n2, n4), this.X[n7++], 1859775393, n5);
            n3 = n3 << 30 | n3 >>> 2;
            n4 = a.a((n5 << 5 | n5 >>> 27) + this.h(n6, n3, n2), this.X[n7++], 1859775393, n4);
            n6 = n6 << 30 | n6 >>> 2;
            n2 = a.a((n4 << 5 | n4 >>> 27) + this.h(n5, n6, n3), this.X[n7++], 1859775393, n2);
            n5 = n5 << 30 | n5 >>> 2;
            n3 = a.a((n2 << 5 | n2 >>> 27) + this.h(n4, n5, n6), this.X[n7++], 1859775393, n3);
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n < 4; ++n) {
            n6 = a.a((n3 << 5 | n3 >>> 27) + this.g(n2, n4, n5), this.X[n7++], -1894007588, n6);
            n2 = n2 << 30 | n2 >>> 2;
            n5 = a.a((n6 << 5 | n6 >>> 27) + this.g(n3, n2, n4), this.X[n7++], -1894007588, n5);
            n3 = n3 << 30 | n3 >>> 2;
            n4 = a.a((n5 << 5 | n5 >>> 27) + this.g(n6, n3, n2), this.X[n7++], -1894007588, n4);
            n6 = n6 << 30 | n6 >>> 2;
            n2 = a.a((n4 << 5 | n4 >>> 27) + this.g(n5, n6, n3), this.X[n7++], -1894007588, n2);
            n5 = n5 << 30 | n5 >>> 2;
            n3 = a.a((n2 << 5 | n2 >>> 27) + this.g(n4, n5, n6), this.X[n7++], -1894007588, n3);
            n4 = n4 << 30 | n4 >>> 2;
        }
        for (n = 0; n <= 3; ++n) {
            n6 = a.a((n3 << 5 | n3 >>> 27) + this.h(n2, n4, n5), this.X[n7++], -899497514, n6);
            n2 = n2 << 30 | n2 >>> 2;
            n5 = a.a((n6 << 5 | n6 >>> 27) + this.h(n3, n2, n4), this.X[n7++], -899497514, n5);
            n3 = n3 << 30 | n3 >>> 2;
            n4 = a.a((n5 << 5 | n5 >>> 27) + this.h(n6, n3, n2), this.X[n7++], -899497514, n4);
            n6 = n6 << 30 | n6 >>> 2;
            n2 = a.a((n4 << 5 | n4 >>> 27) + this.h(n5, n6, n3), this.X[n7++], -899497514, n2);
            n5 = n5 << 30 | n5 >>> 2;
            n3 = a.a((n2 << 5 | n2 >>> 27) + this.h(n4, n5, n6), this.X[n7++], -899497514, n3);
            n4 = n4 << 30 | n4 >>> 2;
        }
        SHA1Digest sHA1Digest2 = this;
        sHA1Digest2.H1 += n3;
        sHA1Digest2.H2 += n2;
        sHA1Digest2.H3 += n4;
        sHA1Digest2.H4 += n5;
        sHA1Digest2.H5 += n6;
        sHA1Digest2.xOff = 0;
        for (n3 = 0; n3 < 16; ++n3) {
            this.X[n3] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA1Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA1Digest sHA1Digest = sHA1Digest2;
        SHA1Digest sHA1Digest2 = (SHA1Digest)memoable;
        super.copyIn(sHA1Digest2);
        sHA1Digest.copyIn(sHA1Digest2);
    }

    @Override
    public byte[] getEncodedState() {
        SHA1Digest sHA1Digest = this;
        byte[] byArray = new byte[sHA1Digest.xOff * 4 + 40];
        super.populateState(byArray);
        Pack.intToBigEndian(sHA1Digest.H1, byArray, 16);
        Pack.intToBigEndian(sHA1Digest.H2, byArray, 20);
        Pack.intToBigEndian(sHA1Digest.H3, byArray, 24);
        Pack.intToBigEndian(sHA1Digest.H4, byArray, 28);
        Pack.intToBigEndian(sHA1Digest.H5, byArray, 32);
        Pack.intToBigEndian(sHA1Digest.xOff, byArray, 36);
        for (int k = 0; k != this.xOff; ++k) {
            Pack.intToBigEndian(this.X[k], byArray, k * 4 + 40);
        }
        return byArray;
    }
}

