/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            int n = byArray.length;
            digest.update(byArray, 0, n);
        }
        digest.doFinal(this.defHash, 0);
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        int n4;
        OAEPEncoding oAEPEncoding = this;
        byte[] byArray2 = new byte[n3];
        int n5 = oAEPEncoding.mgf1Hash.getDigestSize();
        byte[] byArray3 = new byte[n5];
        int n6 = 4;
        byte[] byArray4 = new byte[4];
        oAEPEncoding.mgf1Hash.reset();
        for (n4 = 0; n4 < n3 / n5; ++n4) {
            OAEPEncoding oAEPEncoding2 = this;
            oAEPEncoding2.ItoOSP(n4, byArray4);
            oAEPEncoding2.mgf1Hash.update(byArray, n, n2);
            oAEPEncoding2.mgf1Hash.update(byArray4, 0, n6);
            oAEPEncoding2.mgf1Hash.doFinal(byArray3, 0);
            int n7 = n4 * n5;
            System.arraycopy(byArray3, 0, byArray2, n7, n5);
        }
        if ((n5 = n4 * n5) < n3) {
            OAEPEncoding oAEPEncoding3 = this;
            oAEPEncoding3.ItoOSP(n4, byArray4);
            oAEPEncoding3.mgf1Hash.update(byArray, n, n2);
            oAEPEncoding3.mgf1Hash.update(byArray4, 0, n6);
            oAEPEncoding3.mgf1Hash.doFinal(byArray3, 0);
            int n8 = n3 - n5;
            System.arraycopy(byArray3, 0, byArray2, n5, n8);
        }
        return byArray2;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.random = cipherParameters instanceof ParametersWithRandom ? ((ParametersWithRandom)cipherParameters).getRandom() : CryptoServicesRegistrar.getSecureRandom();
        this.engine.init(bl, cipherParameters);
        this.forEncryption = bl;
    }

    @Override
    public int getInputBlockSize() {
        OAEPEncoding oAEPEncoding = this;
        int n = oAEPEncoding.engine.getInputBlockSize();
        if (oAEPEncoding.forEncryption) {
            return n - 1 - this.defHash.length * 2;
        }
        return n;
    }

    @Override
    public int getOutputBlockSize() {
        OAEPEncoding oAEPEncoding = this;
        int n = oAEPEncoding.engine.getOutputBlockSize();
        if (oAEPEncoding.forEncryption) {
            return n;
        }
        return n - 1 - this.defHash.length * 2;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n, int n2) {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }

    public byte[] encodeBlock(byte[] byArray, int n, int n2) {
        if (n2 <= this.getInputBlockSize()) {
            OAEPEncoding oAEPEncoding = this;
            int n3 = oAEPEncoding.getInputBlockSize() + 1;
            n3 = oAEPEncoding.defHash.length * 2 + n3;
            OAEPEncoding oAEPEncoding2 = this;
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = byArray2;
            int n4 = n3 - n2;
            System.arraycopy(byArray, n, byArray3, n4, n2);
            byArray2[n4 - 1] = 1;
            int n5 = oAEPEncoding2.defHash.length;
            n = oAEPEncoding2.defHash.length;
            System.arraycopy(oAEPEncoding2.defHash, 0, byArray3, n5, n);
            n5 = oAEPEncoding2.defHash.length;
            byte[] byArray4 = new byte[n5];
            oAEPEncoding2.random.nextBytes(byArray4);
            n2 = n3 - oAEPEncoding2.defHash.length;
            byte[] byArray5 = oAEPEncoding.maskGeneratorFunction1(byArray4, 0, n5, n2);
            for (n2 = (v169379).defHash.length; n2 != n3; ++n2) {
                byArray3[n2] = (byte)(byArray3[n2] ^ byArray5[n2 - this.defHash.length]);
            }
            int n6 = this.defHash.length;
            System.arraycopy(byArray4, 0, byArray3, 0, n6);
            n6 = this.defHash.length;
            int n7 = n3 - this.defHash.length;
            n2 = this.defHash.length;
            byte[] byArray6 = this.maskGeneratorFunction1(byArray3, n6, n7, n2);
            for (n7 = 0; n7 != this.defHash.length; ++n7) {
                byArray3[n7] = (byte)(byArray3[n7] ^ byArray6[n7]);
            }
            return this.engine.processBlock(byArray3, 0, n3);
        }
        throw new DataLengthException("input data too long");
    }

    public byte[] decodeBlock(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2;
        int n4;
        OAEPEncoding oAEPEncoding = this;
        byArray = oAEPEncoding.engine.processBlock(byArray, n, n2);
        n = oAEPEncoding.engine.getOutputBlockSize();
        byte[] byArray3 = new byte[n];
        int n5 = n < this.defHash.length * 2 + 1 ? 1 : 0;
        if (byArray.length <= n) {
            int n6 = n - byArray.length;
            n4 = byArray.length;
            System.arraycopy(byArray, 0, byArray3, n6, n4);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, n);
            n5 = 1;
        }
        int n7 = this.defHash.length;
        n4 = n - this.defHash.length;
        int n8 = this.defHash.length;
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, n7, n4, n8);
        n4 = 0;
        while (true) {
            byArray2 = this.defHash;
            if (n4 == this.defHash.length) break;
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray4[n4]);
            ++n4;
        }
        int n9 = byArray2.length;
        n4 = n - byArray2.length;
        byte[] byArray5 = this.maskGeneratorFunction1(byArray3, 0, n9, n4);
        for (n4 = (v169594).defHash.length; n4 != n; ++n4) {
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray5[n4 - this.defHash.length]);
        }
        int n10 = 0;
        n4 = 0;
        while (true) {
            byArray2 = this.defHash;
            if (n4 == this.defHash.length) break;
            if (byArray2[n4] != byArray3[byArray2.length + n4]) {
                n10 = 1;
            }
            ++n4;
        }
        n4 = n;
        for (n3 = byArray2.length * 2; n3 != n; ++n3) {
            boolean bl;
            boolean bl2 = byArray3[n3] != 0;
            if (!(bl2 & (bl = n4 == n))) continue;
            n4 = n3;
        }
        n3 = n4 > n - 1 ? 1 : 0;
        int n11 = byArray3[n4] != 1 ? 1 : 0;
        int n12 = n10;
        n10 = n4 + 1;
        if ((n12 | n5 | (n3 |= n11)) == 0) {
            n3 = n - n10;
            byte[] byArray6 = new byte[n3];
            System.arraycopy(byArray3, n10, byArray6, 0, n3);
            return byArray6;
        }
        Arrays.fill(byArray3, (byte)0);
        throw new InvalidCipherTextException("data wrong");
    }
}

