/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.fis.ekyc.nfc.build_in.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.fis.ekyc.nfc.build_in.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private int pLen = -1;
    private byte[] fallback = null;
    private byte[] blockBuffer;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.pLen = n;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
        this.fallback = byArray;
        this.pLen = byArray.length;
    }

    private boolean useStrict() {
        if (Properties.isOverrideSetTo(NOT_STRICT_LENGTH_ENABLED_PROPERTY, true)) {
            return false;
        }
        return Properties.isOverrideSetTo(STRICT_LENGTH_ENABLED_PROPERTY, false) ^ true;
    }

    private byte[] encodeBlock(byte[] byArray, int n, int n2) {
        if (n2 <= this.getInputBlockSize()) {
            PKCS1Encoding pKCS1Encoding = this;
            int n3 = pKCS1Encoding.engine.getInputBlockSize();
            byte[] byArray2 = new byte[n3];
            if (pKCS1Encoding.forPrivateKey) {
                byArray2[0] = 1;
                for (int k = 1; k != n3 - n2 - 1; ++k) {
                    byArray2[k] = -1;
                }
            } else {
                this.random.nextBytes(byArray2);
                byArray2[0] = 2;
                for (int k = 1; k != n3 - n2 - 1; ++k) {
                    while (byArray2[k] == 0) {
                        byArray2[k] = (byte)this.random.nextInt();
                    }
                }
            }
            int n4 = n3 - n2;
            byArray2[n4 - 1] = 0;
            System.arraycopy(byArray, n, byArray2, n4, n2);
            return this.engine.processBlock(byArray2, 0, n3);
        }
        throw new IllegalArgumentException("input data too large");
    }

    private static int checkPkcs1Encoding(byte[] byArray, int n) {
        int n2 = byArray[0] ^ 2 | 0;
        int n3 = byArray.length - ++n;
        for (int k = 1; k < n3; ++k) {
            byte by = byArray[k];
            int n4 = by | by >> 1;
            int n5 = n4 | n4 >> 2;
            n2 |= ((n5 | n5 >> 4) & 1) - 1;
        }
        int n6 = n2 | byArray[byArray.length - n];
        int n7 = n6 | n6 >> 1;
        int n8 = n7 | n7 >> 2;
        return ~(((n8 | n8 >> 4) & 1) - 1);
    }

    private byte[] decodeBlockOrRandom(byte[] byArray, int n, int n2) {
        if (this.forPrivateKey) {
            int n3;
            int n4;
            PKCS1Encoding pKCS1Encoding = this;
            byArray = pKCS1Encoding.engine.processBlock(byArray, n, n2);
            byte[] byArray2 = pKCS1Encoding.fallback;
            if (pKCS1Encoding.fallback == null) {
                PKCS1Encoding pKCS1Encoding2 = this;
                byArray2 = new byte[pKCS1Encoding2.pLen];
                pKCS1Encoding2.random.nextBytes(byArray2);
            }
            if (((n2 = (int)(this.useStrictLength ? 1 : 0)) & (n4 = byArray.length != this.engine.getOutputBlockSize() ? 1 : 0)) != 0) {
                byArray = this.blockBuffer;
            }
            n2 = PKCS1Encoding.checkPkcs1Encoding(byArray, this.pLen);
            byte[] byArray3 = new byte[this.pLen];
            for (int k = 0; k < (n3 = this.pLen); ++k) {
                byArray3[k] = (byte)(byArray[byArray.length - n3 + k] & ~n2 | byArray2[k] & n2);
            }
            Arrays.fill(byArray, (byte)0);
            return byArray3;
        }
        throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte[] decodeBlock(byte[] byArray, int n, int n2) {
        int n3;
        if (this.pLen != -1) {
            return this.decodeBlockOrRandom(byArray, n, n2);
        }
        PKCS1Encoding pKCS1Encoding = this;
        byArray = pKCS1Encoding.engine.processBlock(byArray, n, n2);
        n = pKCS1Encoding.useStrictLength ? 1 : 0;
        n2 = byArray.length != this.engine.getOutputBlockSize() ? 1 : 0;
        n &= n2;
        if (byArray.length < this.getOutputBlockSize()) {
            byArray = this.blockBuffer;
        }
        n2 = byArray[0];
        int n4 = (this.forPrivateKey ? n2 != 2 : n2 != 1) ? 1 : 0;
        if ((n4 | (n2 = (n3 = this.findStart((byte)n2, byArray) + 1) < 10 ? 1 : 0)) != 0) {
            Arrays.fill(byArray, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (n == 0) {
            n = byArray.length - n3;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, n3, byArray2, 0, n);
            return byArray2;
        }
        Arrays.fill(byArray, (byte)0);
        throw new InvalidCipherTextException("block incorrect size");
    }

    private int findStart(byte by, byte[] byArray) {
        int n = -1;
        int n2 = 0;
        for (int k = 1; k != byArray.length; ++k) {
            byte by2;
            byte by3 = byArray[k];
            byte by4 = by3 == 0 ? (byte)1 : 0;
            if (by4 & (by2 = n < 0 ? (byte)1 : 0)) {
                n = k;
            }
            by4 = by == 1 ? (byte)1 : 0;
            by2 = n < 0 ? (byte)1 : 0;
            byte by5 = by3;
            by3 = by4 & by2;
            by4 = by5 != -1 ? (byte)1 : 0;
            n2 |= by3 & by4;
        }
        if (n2 != 0) {
            return -1;
        }
        return n;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            this.random = ((ParametersWithRandom)cipherParameters2).getRandom();
            cipherParameters2 = (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters2).getParameters();
        } else {
            cipherParameters2 = (AsymmetricKeyParameter)cipherParameters;
            if (!((AsymmetricKeyParameter)cipherParameters2).isPrivate() && bl) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        PKCS1Encoding pKCS1Encoding = this;
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = ((AsymmetricKeyParameter)cipherParameters2).isPrivate();
        pKCS1Encoding.forEncryption = bl;
        pKCS1Encoding.blockBuffer = new byte[pKCS1Encoding.engine.getOutputBlockSize()];
        if (pKCS1Encoding.pLen > 0 && this.fallback == null && this.random == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    @Override
    public int getInputBlockSize() {
        PKCS1Encoding pKCS1Encoding = this;
        int n = pKCS1Encoding.engine.getInputBlockSize();
        if (pKCS1Encoding.forEncryption) {
            return n - 10;
        }
        return n;
    }

    @Override
    public int getOutputBlockSize() {
        PKCS1Encoding pKCS1Encoding = this;
        int n = pKCS1Encoding.engine.getOutputBlockSize();
        if (pKCS1Encoding.forEncryption) {
            return n;
        }
        return n - 10;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n, int n2) {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }
}

