/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    private void setKey(byte[] byArray) {
        this.workingKey = byArray;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        int n = 0;
        while (n < 256) {
            int n2 = n++;
            this.engineState[n2] = (byte)n2;
        }
        n = 0;
        int n3 = 0;
        for (int k = 0; k < 256; ++k) {
            int n4 = n;
            n = byArray[n] & 0xFF;
            byte[] byArray2 = this.engineState;
            byte[] byArray3 = byArray2;
            int n5 = n;
            n = byArray3[k];
            n3 = n5 + n + n3 & 0xFF;
            byArray2[k] = byArray3[n3];
            this.engineState[n3] = n;
            n = (n4 + 1) % byArray.length;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            RC4Engine rC4Engine = object;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            Object object = byArray;
            rC4Engine.workingKey = byArray;
            rC4Engine.setKey((byte[])object);
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to RC4 init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "RC4";
    }

    @Override
    public byte returnByte(byte by) {
        int n;
        byte by2 = by;
        RC4Engine rC4Engine = this;
        int n2 = rC4Engine.x + 1 & 0xFF;
        by = (byte)n2;
        rC4Engine.x = n2;
        byte[] byArray = rC4Engine.engineState;
        byte by3 = by;
        byte by4 = by;
        by = byArray[by];
        this.y = n = by + this.y & 0xFF;
        byArray[by4] = byArray[n];
        byArray[n] = by;
        return (byte)(by2 ^ rC4Engine.engineState[byArray[by3] + by & 0xFF]);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 <= byArray.length) {
            if (n3 + n2 <= byArray2.length) {
                for (int k = 0; k < n2; ++k) {
                    int n4;
                    int n5;
                    RC4Engine rC4Engine = this;
                    rC4Engine.x = n5 = rC4Engine.x + 1 & 0xFF;
                    byte[] byArray3 = rC4Engine.engineState;
                    byte[] byArray4 = byArray3;
                    byte by = byArray4[n5];
                    this.y = n4 = by + this.y & 0xFF;
                    byArray3[n5] = byArray4[n4];
                    rC4Engine.engineState[n4] = by;
                    n4 = k + n3;
                    byArray2[n4] = (byte)(byArray[k + n] ^ byArray4[byArray4[n5] + by & 0xFF]);
                }
                return n2;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        RC4Engine rC4Engine = this;
        rC4Engine.setKey(rC4Engine.workingKey);
    }
}

