/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher blockCipher) {
        CBCBlockCipher cBCBlockCipher;
        CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
        cBCBlockCipher = new CBCBlockCipher(blockCipher);
        v1.engine = cBCBlockCipher2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block7: {
            block6: {
                block4: {
                    block5: {
                        this.forWrapping = bl;
                        if (!(cipherParameters instanceof ParametersWithRandom)) break block4;
                        ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                        this.rand = parametersWithRandom.getRandom();
                        if (!(parametersWithRandom.getParameters() instanceof ParametersWithIV)) break block5;
                        this.param = (ParametersWithIV)parametersWithRandom.getParameters();
                        break block6;
                    }
                    throw new IllegalArgumentException("RFC3211Wrap requires an IV");
                }
                if (bl) {
                    this.rand = CryptoServicesRegistrar.getSecureRandom();
                }
                if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                this.param = (ParametersWithIV)cipherParameters;
            }
            return;
        }
        throw new IllegalArgumentException("RFC3211Wrap requires an IV");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        if (n2 <= 255 && n2 >= 0) {
            RFC3211WrapEngine rFC3211WrapEngine = this;
            rFC3211WrapEngine.engine.init(true, this.param);
            int n3 = rFC3211WrapEngine.engine.getBlockSize();
            int n4 = n2 + 4;
            int n5 = n3 * 2;
            if (n4 >= n5) {
                n5 = n4 % n3 == 0 ? n4 : (n4 / n3 + 1) * n3;
            }
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = byArray2;
            byArray2[0] = (byte)n2;
            System.arraycopy(byArray, n, byArray2, 4, n2);
            int n6 = byArray3.length - n4;
            byte[] byArray4 = new byte[n6];
            this.rand.nextBytes(byArray4);
            System.arraycopy(byArray4, 0, byArray2, n4, n6);
            byArray3[1] = ~byArray3[4];
            byArray3[2] = ~byArray3[5];
            byArray2[3] = ~byArray3[6];
            for (n6 = 0; n6 < byArray2.length; n6 += n3) {
                this.engine.processBlock(byArray2, n6, byArray2, n6);
            }
            n6 = 0;
            while (true) {
                if (n6 >= byArray2.length) {
                    return byArray2;
                }
                this.engine.processBlock(byArray2, n6, byArray2, n6);
                n6 += n3;
            }
        }
        throw new IllegalArgumentException("input must be from 0 to 255 bytes");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            int n3 = this.engine.getBlockSize();
            if (n2 >= n3 * 2) {
                int n4;
                ParametersWithIV parametersWithIV;
                ParametersWithIV parametersWithIV2;
                byte[] byArray2 = byArray;
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray3, n, byArray, 0, n2);
                System.arraycopy(byArray2, n, byArray4, 0, n3);
                ParametersWithIV parametersWithIV3 = parametersWithIV2;
                parametersWithIV2 = new ParametersWithIV(this.param.getParameters(), byArray4);
                this.engine.init(false, parametersWithIV3);
                for (int k = n3; k < n2; k += n3) {
                    this.engine.processBlock(byArray, k, byArray, k);
                }
                RFC3211WrapEngine rFC3211WrapEngine = this;
                System.arraycopy(byArray, n2 - n3, byArray4, 0, n3);
                ParametersWithIV parametersWithIV4 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(this.param.getParameters(), byArray4);
                rFC3211WrapEngine.engine.init(false, parametersWithIV4);
                rFC3211WrapEngine.engine.processBlock(byArray, 0, byArray, 0);
                rFC3211WrapEngine.engine.init(false, this.param);
                for (n4 = 0; n4 < n2; n4 += n3) {
                    this.engine.processBlock(byArray, n4, byArray, n4);
                }
                byte by = byArray[0];
                n4 = n2 - 4;
                n2 = (by & 0xFF) > n4 ? 1 : 0;
                byte[] byArray5 = n2 != 0 ? new byte[n4] : new byte[by & 0xFF];
                n4 = byArray5.length;
                System.arraycopy(byArray, 4, byArray5, 0, n4);
                n4 = 0;
                n3 = 0;
                while (n3 != 3) {
                    int n5 = n4;
                    n4 = n3 + 1;
                    n3 = n5 | (byte)(~byArray[n4]) ^ byArray[n3 + 4];
                    int n6 = n4;
                    n4 = n3;
                    n3 = n6;
                }
                Arrays.clear(byArray);
                if (((n4 != 0 ? 1 : 0) | n2) == 0) {
                    return byArray5;
                }
                throw new InvalidCipherTextException("wrapped key corrupted");
            }
            throw new InvalidCipherTextException("input too short");
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

