/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSACoreEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core;
    private RSAKeyParameters key;
    private SecureRandom random;

    public RSABlindedEngine() {
        RSACoreEngine rSACoreEngine;
        RSACoreEngine rSACoreEngine2 = rSACoreEngine;
        rSACoreEngine = new RSACoreEngine();
        v1.core = rSACoreEngine2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.core.init(bl, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.key = cipherParameters;
            if (cipherParameters instanceof RSAPrivateCrtKeyParameters) {
                this.random = parametersWithRandom.getRandom();
                return;
            }
        } else {
            RSAKeyParameters rSAKeyParameters;
            this.key = rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            if (rSAKeyParameters instanceof RSAPrivateCrtKeyParameters) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                return;
            }
        }
        this.random = null;
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] object, int n, int n2) {
        if (this.key != null) {
            BigInteger bigInteger;
            RSABlindedEngine rSABlindedEngine = this;
            object = rSABlindedEngine.core.convertInput((byte[])object, n, n2);
            Object object2 = rSABlindedEngine.key;
            if (object2 instanceof RSAPrivateCrtKeyParameters && (bigInteger = ((RSAPrivateCrtKeyParameters)(object2 = (RSAPrivateCrtKeyParameters)object2)).getPublicExponent()) != null) {
                byte[] byArray = object;
                object2 = ((RSAKeyParameters)object2).getModulus();
                BigInteger bigInteger2 = ONE;
                BigInteger bigInteger3 = bigInteger2;
                bigInteger3 = ((BigInteger)object2).subtract(bigInteger3);
                bigInteger3 = BigIntegers.createRandomInRange(bigInteger2, bigInteger3, this.random);
                object = bigInteger3.modPow(bigInteger, (BigInteger)object2).multiply((BigInteger)object).mod((BigInteger)object2);
                BigInteger bigInteger4 = this.core.processBlock((BigInteger)object).multiply(BigIntegers.modOddInverse((BigInteger)object2, bigInteger3)).mod((BigInteger)object2);
                object = bigInteger4;
                if (!byArray.equals(bigInteger4.modPow(bigInteger, (BigInteger)object2))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                object = this.core.processBlock((BigInteger)object);
            }
            return this.core.convertOutput((BigInteger)object);
        }
        throw new IllegalStateException("RSA engine not initialised");
    }
}

