/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class Shacal2Engine
implements BlockCipher {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int BLOCK_SIZE = 32;
    private static final int ROUNDS = 64;
    private boolean forEncryption = false;
    private int[] workingKey = null;

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[8];
        this.byteBlockToInts(byArray, nArray, n, 0);
        for (int k = 0; k < 64; ++k) {
            n = nArray[4];
            int n3 = nArray[5];
            int n4 = nArray[6];
            int n5 = ((n >>> 6 | n << -6) ^ (n >>> 11 | n << -11) ^ (n >>> 25 | n << -25)) + (n & n3 ^ ~n & n4) + nArray[7] + K[k] + this.workingKey[k];
            int[] nArray2 = nArray;
            int[] nArray3 = nArray;
            nArray2[7] = n4;
            nArray3[6] = n3;
            nArray2[5] = n;
            nArray2[4] = nArray3[3] + n5;
            nArray2[3] = n = nArray3[2];
            nArray2[2] = n3 = nArray3[1];
            nArray[1] = n4 = nArray3[0];
            nArray[0] = n5 + ((n4 >>> 2 | n4 << -2) ^ (n4 >>> 13 | n4 << -13) ^ (n4 >>> 22 | n4 << -22)) + (n4 & n3 ^ n4 & n ^ n3 & n);
        }
        this.ints2bytes(nArray, byArray2, n2);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[8];
        this.byteBlockToInts(byArray, nArray, n, 0);
        for (int k = 63; k > -1; --k) {
            n = nArray[1];
            int n3 = nArray[2];
            int n4 = nArray[3];
            int n5 = nArray[0] - ((n >>> 2 | n << -2) ^ (n >>> 13 | n << -13) ^ (n >>> 22 | n << -22)) - (n & n3 ^ n & n4 ^ n3 & n4);
            int[] nArray2 = nArray;
            nArray2[0] = n;
            nArray2[1] = n3;
            nArray2[2] = n4;
            nArray2[3] = nArray2[4] - n5;
            nArray2[4] = n = nArray2[5];
            nArray2[5] = n3 = nArray2[6];
            nArray[6] = n4 = nArray2[7];
            nArray[7] = n5 - K[k] - this.workingKey[k] - ((n >>> 6 | n << -6) ^ (n >>> 11 | n << -11) ^ (n >>> 25 | n << -25)) - (n & n3 ^ ~n & n4);
        }
        this.ints2bytes(nArray, byArray2, n2);
    }

    private void byteBlockToInts(byte[] byArray, int[] nArray, int n, int n2) {
        while (n2 < 8) {
            int n3 = n;
            int n4 = n3 + 1;
            int n5 = n4++;
            int n6 = n4++;
            int n7 = n4;
            n = n7 + 1;
            nArray[n2] = (byArray[n3] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n6] & 0xFF) << 8 | byArray[n7] & 0xFF;
            ++n2;
        }
    }

    private void bytes2ints(byte[] byArray, int[] nArray, int n, int n2) {
        while (n2 < byArray.length / 4) {
            int n3 = n;
            int n4 = n3 + 1;
            int n5 = n4++;
            int n6 = n4++;
            int n7 = n4;
            n = n7 + 1;
            nArray[n2] = (byArray[n3] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n6] & 0xFF) << 8 | byArray[n7] & 0xFF;
            ++n2;
        }
    }

    private void ints2bytes(int[] nArray, byte[] byArray, int n) {
        for (int k = 0; k < nArray.length; ++k) {
            int n2 = n + 1;
            int n3 = nArray[k];
            byArray[n] = (byte)(n3 >>> 24);
            n = n2 + 1;
            byArray[n2] = (byte)(n3 >>> 16);
            n2 = n + 1;
            byArray[n] = (byte)(n3 >>> 8);
            n = n2 + 1;
            byArray[n2] = (byte)n3;
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public String getAlgorithmName() {
        return "Shacal2";
    }

    @Override
    public int getBlockSize() {
        return 32;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            Shacal2Engine shacal2Engine = this;
            shacal2Engine.forEncryption = bl;
            shacal2Engine.workingKey = new int[64];
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException("only simple KeyParameter expected.");
    }

    public void setKey(byte[] byArray) {
        if (byArray.length != 0 && byArray.length <= 64 && byArray.length >= 16 && byArray.length % 8 == 0) {
            Shacal2Engine shacal2Engine = this;
            shacal2Engine.bytes2ints(byArray, shacal2Engine.workingKey, 0, 0);
            for (int k = 16; k < 64; ++k) {
                int[] nArray = this.workingKey;
                int n = nArray[k - 2];
                int n2 = ((n >>> 17 | n << -17) ^ (n >>> 19 | n << -19) ^ n >>> 10) + nArray[k - 7];
                n = nArray[k - 15];
                this.workingKey[k] = n2 + ((n >>> 7 | n << -7) ^ (n >>> 18 | n << -18) ^ n >>> 3) + nArray[k - 16];
            }
            return;
        }
        throw new IllegalArgumentException("Shacal2-key must be 16 - 64 bytes and multiple of 8");
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingKey != null) {
            if (n + 32 <= byArray.length) {
                if (n2 + 32 <= byArray2.length) {
                    if (this.forEncryption) {
                        this.encryptBlock(byArray, n, byArray2, n2);
                    } else {
                        this.decryptBlock(byArray, n, byArray2, n2);
                    }
                    return 32;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Shacal2 not initialised");
    }
}

