/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class TEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private static final int d_sum = -957401312;
    private int _a;
    private int _b;
    private int _c;
    private int _d;
    private boolean _initialised = false;
    private boolean _forEncryption;

    private void setKey(byte[] byArray) {
        if (byArray.length == 16) {
            this._a = this.bytesToInt(byArray, 0);
            this._b = this.bytesToInt(byArray, 4);
            this._c = this.bytesToInt(byArray, 8);
            this._d = this.bytesToInt(byArray, 12);
            return;
        }
        throw new IllegalArgumentException("Key size must be 128 bits.");
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        TEAEngine tEAEngine = this;
        int n3 = tEAEngine.bytesToInt(byArray, n);
        int n4 = tEAEngine.bytesToInt(byArray, n + 4);
        n = 0;
        for (int k = 0; k != 32; ++k) {
            n4 += ((n3 += (n4 << 4) + this._a ^ n4 + (n -= 1640531527) ^ (n4 >>> 5) + this._b) << 4) + this._c ^ n3 + n ^ (n3 >>> 5) + this._d;
        }
        TEAEngine tEAEngine2 = this;
        tEAEngine2.unpackInt(n3, byArray2, n2);
        int n5 = n2 + 4;
        tEAEngine2.unpackInt(n4, byArray2, n5);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        TEAEngine tEAEngine = this;
        int n3 = tEAEngine.bytesToInt(byArray, n);
        int n4 = tEAEngine.bytesToInt(byArray, n + 4);
        n = -957401312;
        for (int k = 0; k != 32; ++k) {
            n3 -= ((n4 -= (n3 << 4) + this._c ^ n3 + n ^ (n3 >>> 5) + this._d) << 4) + this._a ^ n4 + n ^ (n4 >>> 5) + this._b;
            n += 1640531527;
        }
        TEAEngine tEAEngine2 = this;
        tEAEngine2.unpackInt(n3, byArray2, n2);
        int n5 = n2 + 4;
        tEAEngine2.unpackInt(n4, byArray2, n5);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n) {
        int n2 = n;
        int n3 = n2 + 1;
        return byArray[n2] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3] & 0xFF;
    }

    private void unpackInt(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n2 + 1;
        byArray[n2] = (byte)(n >>> 24);
        n = n6 + 1;
        byArray[n6] = (byte)(n5 >>> 16);
        n6 = n + 1;
        byArray[n] = (byte)(n4 >>> 8);
        byArray[n6] = (byte)n3;
    }

    @Override
    public String getAlgorithmName() {
        return "TEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            TEAEngine tEAEngine = this;
            tEAEngine._forEncryption = bl;
            tEAEngine._initialised = true;
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameter passed to TEA init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this._initialised) {
            if (n + 8 <= byArray.length) {
                if (n2 + 8 <= byArray2.length) {
                    return this._forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

