/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.HKDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class HKDFBytesGenerator
implements DerivationFunction {
    private HMac hMacHash;
    private int hashLen;
    private byte[] info;
    private byte[] currentT;
    private int generatedBytes;

    public HKDFBytesGenerator(Digest digest) {
        this.hMacHash = new HMac(digest);
        this.hashLen = digest.getDigestSize();
    }

    private KeyParameter extract(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            ((HKDFBytesGenerator)object).hMacHash.init(new KeyParameter(new byte[((HKDFBytesGenerator)object).hashLen]));
        } else {
            ((HKDFBytesGenerator)object).hMacHash.init(new KeyParameter(byArray));
        }
        HKDFBytesGenerator hKDFBytesGenerator = object;
        hKDFBytesGenerator.hMacHash.update(byArray2, 0, byArray2.length);
        Object object = new byte[hKDFBytesGenerator.hashLen];
        hKDFBytesGenerator.hMacHash.doFinal((byte[])object, 0);
        return new KeyParameter((byte[])object);
    }

    private void expandNext() {
        int n = this.generatedBytes;
        int n2 = this.hashLen;
        int n3 = n / n2 + 1;
        if (n3 < 256) {
            if (n != 0) {
                this.hMacHash.update(this.currentT, 0, n2);
            }
            HKDFBytesGenerator hKDFBytesGenerator = this;
            hKDFBytesGenerator.hMacHash.update(this.info, 0, this.info.length);
            hKDFBytesGenerator.hMacHash.update((byte)n3);
            hKDFBytesGenerator.hMacHash.doFinal(this.currentT, 0);
            return;
        }
        throw new DataLengthException("HKDF cannot generate more than 255 blocks of HashLen size");
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof HKDFParameters) {
            if (((HKDFParameters)(derivationParameters = (HKDFParameters)derivationParameters)).skipExtract()) {
                this.hMacHash.init(new KeyParameter(((HKDFParameters)derivationParameters).getIKM()));
            } else {
                DerivationParameters derivationParameters2 = derivationParameters;
                byte[] byArray = ((HKDFParameters)derivationParameters2).getSalt();
                this.hMacHash.init(this.extract(byArray, ((HKDFParameters)derivationParameters2).getIKM()));
            }
            this.info = ((HKDFParameters)derivationParameters).getInfo();
            this.generatedBytes = 0;
            this.currentT = new byte[this.hashLen];
            return;
        }
        throw new IllegalArgumentException("HKDF parameters required for HKDFBytesGenerator");
    }

    public Digest getDigest() {
        return this.hMacHash.getUnderlyingDigest();
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        int n3 = this.generatedBytes;
        int n4 = this.hashLen;
        if (n3 + n2 <= n4 * 255) {
            if (n3 % n4 == 0) {
                this.expandNext();
            }
            int n5 = n;
            HKDFBytesGenerator hKDFBytesGenerator = this;
            n3 = hKDFBytesGenerator.generatedBytes;
            n4 = hKDFBytesGenerator.hashLen;
            int n6 = n3;
            n3 %= n4;
            n4 = Math.min(n4 - n6 % n4, n2);
            System.arraycopy(hKDFBytesGenerator.currentT, n3, byArray, n, n4);
            hKDFBytesGenerator.generatedBytes += n4;
            n = n2 - n4;
            n3 = n5 + n4;
            while (n > 0) {
                int n7 = n3;
                int n8 = n;
                HKDFBytesGenerator hKDFBytesGenerator2 = this;
                hKDFBytesGenerator2.expandNext();
                n = Math.min(hKDFBytesGenerator2.hashLen, n);
                System.arraycopy(hKDFBytesGenerator2.currentT, 0, byArray, n3, n);
                hKDFBytesGenerator2.generatedBytes += n;
                n3 = n8 - n;
                n = n7 + n;
                int n9 = n3;
                n3 = n;
                n = n9;
            }
            return n2;
        }
        throw new DataLengthException("HKDF may only be used for 255 * HashLen bytes of output");
    }
}

