/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MacDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFCounterParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFCounterBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputDataCtrPrefix;
    private byte[] fixedInputData_afterCtr;
    private int maxSizeExcl;
    private byte[] ios;
    private int generatedBytes;
    private byte[] k;

    public KDFCounterBytesGenerator(Mac mac) {
        int n;
        KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
        this.prf = mac;
        kDFCounterBytesGenerator.h = n = mac.getMacSize();
        kDFCounterBytesGenerator.k = new byte[n];
    }

    private void generateNext() {
        KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
        int n = kDFCounterBytesGenerator.generatedBytes / this.h + 1;
        byte[] byArray = kDFCounterBytesGenerator.ios;
        switch (kDFCounterBytesGenerator.ios.length) {
            default: {
                throw new IllegalStateException("Unsupported size of counter i");
            }
            case 4: {
                byArray[0] = (byte)(n >>> 24);
            }
            case 3: {
                int n2 = byArray.length - 3;
                byArray[n2] = (byte)(n >>> 16);
            }
            case 2: {
                int n2 = byArray.length - 2;
                byArray[n2] = (byte)(n >>> 8);
            }
            case 1: 
        }
        KDFCounterBytesGenerator kDFCounterBytesGenerator2 = this;
        int n3 = n;
        n = byArray.length - 1;
        byArray[n] = (byte)n3;
        kDFCounterBytesGenerator2.prf.update(this.fixedInputDataCtrPrefix, 0, this.fixedInputDataCtrPrefix.length);
        kDFCounterBytesGenerator2.prf.update(this.ios, 0, this.ios.length);
        kDFCounterBytesGenerator2.prf.update(this.fixedInputData_afterCtr, 0, this.fixedInputData_afterCtr.length);
        kDFCounterBytesGenerator2.prf.doFinal(this.k, 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFCounterParameters) {
            derivationParameters = (KDFCounterParameters)derivationParameters;
            this.prf.init(new KeyParameter(((KDFCounterParameters)derivationParameters).getKI()));
            this.fixedInputDataCtrPrefix = ((KDFCounterParameters)derivationParameters).getFixedInputDataCounterPrefix();
            this.fixedInputData_afterCtr = ((KDFCounterParameters)derivationParameters).getFixedInputDataCounterSuffix();
            int n = ((KDFCounterParameters)derivationParameters).getR();
            this.ios = new byte[n / 8];
            BigInteger bigInteger = TWO.pow(n).multiply(BigInteger.valueOf(this.h));
            int n2 = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
            KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
            kDFCounterBytesGenerator.maxSizeExcl = n2;
            kDFCounterBytesGenerator.generatedBytes = 0;
            return;
        }
        throw new IllegalArgumentException("Wrong type of arguments given");
    }

    @Override
    public Mac getMac() {
        return this.prf;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        int n3 = this.generatedBytes;
        int n4 = n3 + n2;
        if (n4 >= 0 && n4 < this.maxSizeExcl) {
            if (n3 % this.h == 0) {
                this.generateNext();
            }
            int n5 = n;
            KDFCounterBytesGenerator kDFCounterBytesGenerator = this;
            n3 = kDFCounterBytesGenerator.generatedBytes;
            n4 = kDFCounterBytesGenerator.h;
            int n6 = n3;
            n3 %= n4;
            n4 = Math.min(n4 - n6 % n4, n2);
            System.arraycopy(kDFCounterBytesGenerator.k, n3, byArray, n, n4);
            kDFCounterBytesGenerator.generatedBytes += n4;
            n = n2 - n4;
            n3 = n5 + n4;
            while (n > 0) {
                int n7 = n3;
                int n8 = n;
                KDFCounterBytesGenerator kDFCounterBytesGenerator2 = this;
                kDFCounterBytesGenerator2.generateNext();
                n = Math.min(kDFCounterBytesGenerator2.h, n);
                System.arraycopy(kDFCounterBytesGenerator2.k, 0, byArray, n3, n);
                kDFCounterBytesGenerator2.generatedBytes += n;
                n3 = n8 - n;
                n = n7 + n;
                int n9 = n3;
                n3 = n;
                n = n9;
            }
            return n2;
        }
        throw new DataLengthException(b.a(b.b.a("Current KDFCTR may only be used for "), this.maxSizeExcl, " bytes"));
    }
}

