/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] seed;
    private int hLen;

    public MGF1BytesGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof MGFParameters) {
            this.seed = ((MGFParameters)derivationParameters).getSeed();
            return;
        }
        throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        if (byArray.length - n2 >= n) {
            MGF1BytesGenerator mGF1BytesGenerator = this;
            byte[] byArray2 = new byte[mGF1BytesGenerator.hLen];
            int n3 = 4;
            byte[] byArray3 = new byte[4];
            int n4 = 0;
            mGF1BytesGenerator.digest.reset();
            if (n2 > mGF1BytesGenerator.hLen) {
                do {
                    MGF1BytesGenerator mGF1BytesGenerator2 = this;
                    mGF1BytesGenerator2.ItoOSP(n4, byArray3);
                    mGF1BytesGenerator2.digest.update(this.seed, 0, this.seed.length);
                    mGF1BytesGenerator2.digest.update(byArray3, 0, n3);
                    mGF1BytesGenerator2.digest.doFinal(byArray2, 0);
                    int n5 = mGF1BytesGenerator2.hLen;
                    int n6 = n4 * n5 + n;
                    System.arraycopy(byArray2, 0, byArray, n6, n5);
                } while (++n4 < n2 / this.hLen);
            }
            if (n4 * this.hLen < n2) {
                int n7 = n4;
                MGF1BytesGenerator mGF1BytesGenerator3 = this;
                mGF1BytesGenerator3.ItoOSP(n4, byArray3);
                mGF1BytesGenerator3.digest.update(this.seed, 0, this.seed.length);
                mGF1BytesGenerator3.digest.update(byArray3, 0, n3);
                mGF1BytesGenerator3.digest.doFinal(byArray2, 0);
                int n8 = mGF1BytesGenerator3.hLen;
                n = n7 * n8 + n;
                n8 = n2 - n7 * n8;
                System.arraycopy(byArray2, 0, byArray, n, n8);
            }
            return n2;
        }
        throw new OutputLengthException("output buffer too small");
    }
}

