/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.CipherIOException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.InvalidCipherTextIOException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStream(OutputStream outputStream, StreamCipher streamCipher) {
        super(outputStream);
        this.streamCipher = streamCipher;
    }

    public CipherOutputStream(OutputStream outputStream, AEADBlockCipher aEADBlockCipher) {
        super(outputStream);
        this.aeadBlockCipher = aEADBlockCipher;
    }

    private void ensureCapacity(int n, boolean bl) {
        Object object;
        if (bl) {
            object = this.bufferedBlockCipher;
            if (object != null) {
                n = ((BufferedBlockCipher)object).getOutputSize(n);
            } else {
                object = this.aeadBlockCipher;
                if (object != null) {
                    n = object.getOutputSize(n);
                }
            }
        } else {
            object = this.bufferedBlockCipher;
            if (object != null) {
                n = ((BufferedBlockCipher)object).getUpdateOutputSize(n);
            } else {
                object = this.aeadBlockCipher;
                if (object != null) {
                    n = object.getUpdateOutputSize(n);
                }
            }
        }
        object = this.buf;
        if (this.buf == null || ((Object)object).length < n) {
            this.buf = new byte[n];
        }
    }

    @Override
    public void write(int n) {
        CipherOutputStream cipherOutputStream = this;
        byte[] byArray = cipherOutputStream.oneByte;
        cipherOutputStream.oneByte[0] = n = (int)((byte)n);
        StreamCipher streamCipher = cipherOutputStream.streamCipher;
        if (streamCipher != null) {
            this.out.write(streamCipher.returnByte((byte)n));
        } else {
            this.write(byArray, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray) {
        int n = byArray.length;
        this.write(byArray, 0, n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        CipherOutputStream cipherOutputStream = this;
        cipherOutputStream.ensureCapacity(n2, false);
        Object object = cipherOutputStream.bufferedBlockCipher;
        if (object != null) {
            int n3 = ((BufferedBlockCipher)object).processBytes(byArray, n, n2, (byte[])(object = (Object)this.buf), 0);
            if (n3 != 0) {
                this.out.write(this.buf, 0, n3);
            }
        } else {
            object = this.aeadBlockCipher;
            if (object != null) {
                int n4 = object.processBytes(byArray, n, n2, (byte[])(object = (Object)this.buf), 0);
                if (n4 != 0) {
                    this.out.write(this.buf, 0, n4);
                }
            } else {
                CipherOutputStream cipherOutputStream2 = this;
                byte[] byArray2 = byArray;
                byArray = this.buf;
                cipherOutputStream2.streamCipher.processBytes(byArray2, n, n2, byArray, 0);
                cipherOutputStream2.out.write(this.buf, 0, n2);
            }
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void close() {
        block12: {
            block11: {
                v0 = this;
                v0.ensureCapacity(0, true);
                var1_2 /* !! */  = null;
                var2_5 = v0.bufferedBlockCipher;
                if (var2_5 == null) ** GOTO lbl13
                var2_6 = var2_5.doFinal(this.buf, 0);
                if (var2_6 == 0) break block11;
                this.out.write(this.buf, 0, var2_6);
                break block11;
lbl13:
                // 1 sources

                var2_5 = this.aeadBlockCipher;
                if (var2_5 == null) ** GOTO lbl21
                var2_7 = var2_5.doFinal(this.buf, 0);
                if (var2_7 == 0) break block11;
                this.out.write(this.buf, 0, var2_7);
                break block11;
lbl21:
                // 1 sources

                var2_5 = this.streamCipher;
                if (var2_5 == null) break block11;
                try {
                    var2_5.reset();
                }
                catch (Exception var1_3) {
                    var2_8 = v1;
                    v1 = new CipherIOException("Error closing stream: ", var1_3);
                    var1_2 /* !! */  = var2_8;
                }
                catch (InvalidCipherTextException var1_4) {
                    var2_9 = v2;
                    v2 = new InvalidCipherTextIOException("Error finalising cipher data", var1_4);
                    var1_2 /* !! */  = var2_9;
                }
            }
            try {
                v3 = this;
                v3.flush();
                v3.out.close();
            }
            catch (IOException var0_1) {
                if (var1_2 /* !! */  != null) break block12;
                var1_2 /* !! */  = var0_1;
            }
        }
        if (var1_2 /* !! */  == null) {
            return;
        }
        throw var1_2 /* !! */ ;
    }
}

