/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

class MacCFBBlockCipher {
    private byte[] IV;
    private byte[] cfbV;
    private byte[] cfbOutV;
    private int blockSize;
    private BlockCipher cipher;

    public MacCFBBlockCipher(BlockCipher blockCipher, int n) {
        this.cipher = blockCipher;
        this.blockSize = n / 8;
        this.IV = new byte[blockCipher.getBlockSize()];
        this.cfbV = new byte[blockCipher.getBlockSize()];
        this.cfbOutV = new byte[blockCipher.getBlockSize()];
    }

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)cipherParameters;
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                int n = byArray2.length - byArray.length;
                int n2 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, n, n2);
            } else {
                int n = byArray2.length;
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            MacCFBBlockCipher macCFBBlockCipher = this;
            macCFBBlockCipher.reset();
            macCFBBlockCipher.cipher.init(true, ((ParametersWithIV)cipherParameters).getParameters());
        } else {
            MacCFBBlockCipher macCFBBlockCipher = this;
            macCFBBlockCipher.reset();
            macCFBBlockCipher.cipher.init(true, cipherParameters);
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CFB" + this.blockSize * 8;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blockSize;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                int n4;
                MacCFBBlockCipher macCFBBlockCipher = this;
                byte[] byArray3 = macCFBBlockCipher.cfbV;
                byte[] byArray4 = macCFBBlockCipher.cfbOutV;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int k = 0; k < (n4 = this.blockSize); ++k) {
                    byArray2[n2 + k] = (byte)(this.cfbOutV[k] ^ byArray[n + k]);
                }
                MacCFBBlockCipher macCFBBlockCipher2 = this;
                byArray = macCFBBlockCipher2.cfbV;
                n = byArray.length - n4;
                System.arraycopy(macCFBBlockCipher2.cfbV, n4, byArray, 0, n);
                byArray = macCFBBlockCipher2.cfbV;
                int n5 = this.blockSize;
                System.arraycopy(byArray2, n2, byArray, macCFBBlockCipher2.cfbV.length - n5, n5);
                return this.blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public void reset() {
        MacCFBBlockCipher macCFBBlockCipher = object;
        Object object = ((MacCFBBlockCipher)object).cfbV;
        int n = macCFBBlockCipher.IV.length;
        System.arraycopy(macCFBBlockCipher.IV, 0, object, 0, n);
        macCFBBlockCipher.cipher.reset();
    }

    public void getMacBlock(byte[] byArray) {
        this.cipher.processBlock(this.cfbV, 0, byArray, 0);
    }
}

