/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Poly1305
implements Mac {
    private static final int BLOCK_SIZE = 16;
    private final BlockCipher cipher;
    private final byte[] singleByte = new byte[1];
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private final byte[] currentBlock = new byte[16];
    private int currentBlockOffset = 0;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;

    public Poly1305() {
        this.cipher = null;
    }

    public Poly1305(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() == 16) {
            this.cipher = blockCipher;
            return;
        }
        throw new IllegalArgumentException("Poly1305 requires a 128 bit block cipher.");
    }

    private void setKey(byte[] object, byte[] byArray) {
        if (((byte[])object).length == 32) {
            int n;
            if (this.cipher != null && (byArray == null || byArray.length != 16)) {
                throw new IllegalArgumentException("Poly1305 requires a 128 bit IV.");
            }
            int n2 = Pack.littleEndianToInt(object, 0);
            int n3 = Pack.littleEndianToInt(object, 4);
            int n4 = Pack.littleEndianToInt(object, 8);
            int n5 = Pack.littleEndianToInt(object, 12);
            this.r0 = n2 & 0x3FFFFFF;
            this.r1 = n2 = (n2 >>> 26 | n3 << 6) & 0x3FFFF03;
            this.r2 = n3 = (n3 >>> 20 | n4 << 12) & 0x3FFC0FF;
            this.r3 = n4 = (n4 >>> 14 | n5 << 18) & 0x3F03FFF;
            this.r4 = n5 = n5 >>> 8 & 0xFFFFF;
            this.s1 = n2 * 5;
            this.s2 = n3 * 5;
            this.s3 = n4 * 5;
            this.s4 = n5 * 5;
            Object object2 = this.cipher;
            if (object2 == null) {
                n = 16;
            } else {
                KeyParameter keyParameter;
                BlockCipher blockCipher = object2;
                object2 = new byte[16];
                n3 = 0;
                KeyParameter keyParameter2 = keyParameter;
                keyParameter = new KeyParameter((byte[])object, 16, 16);
                blockCipher.init(true, keyParameter2);
                this.cipher.processBlock(byArray, 0, (byte[])object2, 0);
                n = n3;
                object = object2;
            }
            this.k0 = Pack.littleEndianToInt(object, n + 0);
            this.k1 = Pack.littleEndianToInt(object, n + 4);
            this.k2 = Pack.littleEndianToInt(object, n + 8);
            this.k3 = Pack.littleEndianToInt(object, n + 12);
            return;
        }
        throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
    }

    private void processBlock() {
        int n;
        int n2;
        int n3 = this.currentBlockOffset;
        if (n3 < 16) {
            this.currentBlock[n3] = 1;
            ++n3;
            while (n3 < 16) {
                this.currentBlock[n3] = 0;
                ++n3;
            }
        }
        Poly1305 poly1305 = this;
        long l = (long)Pack.littleEndianToInt(poly1305.currentBlock, 0) & 0xFFFFFFFFL;
        long l2 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 4) & 0xFFFFFFFFL;
        long l3 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 8) & 0xFFFFFFFFL;
        long l4 = (long)Pack.littleEndianToInt(poly1305.currentBlock, 12) & 0xFFFFFFFFL;
        poly1305.h0 = n2 = (int)((long)poly1305.h0 + (l & 0x3FFFFFFL));
        poly1305.h1 = (int)((long)poly1305.h1 + ((l2 << 32 | l) >>> 26 & 0x3FFFFFFL));
        poly1305.h2 = (int)((long)poly1305.h2 + ((l3 << 32 | l2) >>> 20 & 0x3FFFFFFL));
        poly1305.h3 = (int)((long)poly1305.h3 + ((l4 << 32 | l3) >>> 14 & 0x3FFFFFFL));
        poly1305.h4 = n = (int)((long)poly1305.h4 + (l4 >>> 8));
        if (poly1305.currentBlockOffset == 16) {
            this.h4 = n + 0x1000000;
        }
        Poly1305 poly13052 = this;
        long l5 = Poly1305.mul32x32_64(n2, this.r0) + Poly1305.mul32x32_64(this.h1, this.s4) + Poly1305.mul32x32_64(this.h2, this.s3) + Poly1305.mul32x32_64(this.h3, this.s2) + Poly1305.mul32x32_64(this.h4, this.s1);
        l2 = Poly1305.mul32x32_64(poly13052.h0, this.r1) + Poly1305.mul32x32_64(this.h1, this.r0) + Poly1305.mul32x32_64(this.h2, this.s4) + Poly1305.mul32x32_64(this.h3, this.s3) + Poly1305.mul32x32_64(this.h4, this.s2);
        l3 = Poly1305.mul32x32_64(poly13052.h0, this.r2) + Poly1305.mul32x32_64(this.h1, this.r1) + Poly1305.mul32x32_64(this.h2, this.r0) + Poly1305.mul32x32_64(this.h3, this.s4) + Poly1305.mul32x32_64(this.h4, this.s3);
        l4 = Poly1305.mul32x32_64(poly13052.h0, this.r3) + Poly1305.mul32x32_64(this.h1, this.r2) + Poly1305.mul32x32_64(this.h2, this.r1) + Poly1305.mul32x32_64(this.h3, this.r0) + Poly1305.mul32x32_64(this.h4, this.s4);
        long l6 = l5;
        int n4 = (int)l6 & 0x3FFFFFF;
        long l7 = l2 + (l6 >>> 26);
        int n5 = (int)l7 & 0x3FFFFFF;
        l2 = l3 + (l7 >>> 26);
        this.h2 = (int)l2 & 0x3FFFFFF;
        l2 = l4 + (l2 >>> 26);
        this.h3 = (int)l2 & 0x3FFFFFF;
        l2 = Poly1305.mul32x32_64(poly13052.h0, this.r4) + Poly1305.mul32x32_64(this.h1, this.r3) + Poly1305.mul32x32_64(this.h2, this.r2) + Poly1305.mul32x32_64(this.h3, this.r1) + Poly1305.mul32x32_64(this.h4, this.r0) + (l2 >>> 26);
        this.h4 = (int)l2 & 0x3FFFFFF;
        n4 = (int)(l2 >>> 26) * 5 + n4;
        this.h1 = n5 + (n4 >>> 26);
        poly13052.h0 = n4 & 0x3FFFFFF;
    }

    private static final long mul32x32_64(int n, int n2) {
        return ((long)n & 0xFFFFFFFFL) * (long)n2;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        byte[] byArray = null;
        if (this.cipher != null) {
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray = parametersWithIV.getIV();
                cipherParameters = parametersWithIV.getParameters();
            } else {
                throw new IllegalArgumentException("Poly1305 requires an IV when used with a block cipher.");
            }
        }
        if (cipherParameters instanceof KeyParameter) {
            Poly1305 poly1305 = this;
            poly1305.setKey(((KeyParameter)cipherParameters).getKey(), byArray);
            poly1305.reset();
            return;
        }
        throw new IllegalArgumentException("Poly1305 requires a key.");
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher == null ? "Poly1305" : b.a("Poly1305-").append(this.cipher.getAlgorithmName()).toString();
    }

    @Override
    public int getMacSize() {
        return 16;
    }

    @Override
    public void update(byte by) {
        Poly1305 poly1305 = object;
        Object object = poly1305.singleByte;
        poly1305.singleByte[0] = by;
        poly1305.update((byte[])object, 0, 1);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > n3) {
            if (this.currentBlockOffset == 16) {
                this.processBlock();
                this.currentBlockOffset = 0;
            }
            int n4 = n3;
            Poly1305 poly1305 = this;
            int n5 = n3;
            n3 = Math.min(n2 - n3, 16 - this.currentBlockOffset);
            int n6 = n5 + n;
            byte[] byArray2 = poly1305.currentBlock;
            int n7 = poly1305.currentBlockOffset;
            System.arraycopy(byArray, n6, byArray2, n7, n3);
            n6 = n4 + n3;
            this.currentBlockOffset += n3;
            n3 = n6;
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        if (n + 16 <= byArray.length) {
            if (this.currentBlockOffset > 0) {
                this.processBlock();
            }
            Poly1305 poly1305 = this;
            int n2 = this.h0;
            int n3 = poly1305.h1 + (n2 >>> 26);
            n2 &= 0x3FFFFFF;
            int n4 = this.h2 + (n3 >>> 26);
            int n5 = n3 & 0x3FFFFFF;
            int n6 = poly1305.h3 + (n4 >>> 26);
            int n7 = this.h4 + (n6 >>> 26);
            int n8 = n6 & 0x3FFFFFF;
            int n9 = n8;
            int n10 = n4 &= 0x3FFFFFF;
            int n11 = n5;
            n2 = (n7 >>> 26) * 5 + n2;
            n5 = n7 & 0x3FFFFFF;
            int n12 = n11 + (n2 >>> 26);
            n7 = n12;
            int n13 = n2 & 0x3FFFFFF;
            n2 = n13;
            int n14 = n9;
            int n15 = n4;
            int n16 = n2 + 5;
            n2 = n16 >>> 26;
            n4 = n16 & 0x3FFFFFF;
            int n17 = n7 + n2;
            n2 = n17 >>> 26;
            n7 = n17 & 0x3FFFFFF;
            int n18 = n15 + n2;
            n2 = n18 >>> 26;
            n9 = n18 & 0x3FFFFFF;
            int n19 = n14 + n2;
            n2 = n19 >>> 26;
            int n20 = n19 & 0x3FFFFFF;
            n2 = n5 + n2 - 0x4000000;
            int n21 = (n2 >>> 31) - 1;
            int n22 = ~n21;
            this.h0 = n4 = n13 & n22 | n4 & n21;
            this.h1 = n7 = n12 & n22 | n7 & n21;
            this.h2 = n9 = n10 & n22 | n9 & n21;
            this.h3 = n20 = n8 & n22 | n20 & n21;
            this.h4 = n2 = n5 & n22 | n2 & n21;
            long l = ((long)(n4 | n7 << 26) & 0xFFFFFFFFL) + ((long)this.k0 & 0xFFFFFFFFL);
            long l2 = ((long)(n7 >>> 6 | n9 << 20) & 0xFFFFFFFFL) + ((long)this.k1 & 0xFFFFFFFFL);
            long l3 = ((long)(n9 >>> 12 | n20 << 14) & 0xFFFFFFFFL) + ((long)this.k2 & 0xFFFFFFFFL);
            long l4 = ((long)(n20 >>> 18 | n2 << 8) & 0xFFFFFFFFL) + ((long)this.k3 & 0xFFFFFFFFL);
            long l5 = l;
            Pack.intToLittleEndian((int)l5, byArray, n);
            long l6 = l2 + (l5 >>> 32);
            Pack.intToLittleEndian((int)l6, byArray, n + 4);
            long l7 = l3 + (l6 >>> 32);
            Pack.intToLittleEndian((int)l7, byArray, n + 8);
            Pack.intToLittleEndian((int)(l4 + (l7 >>> 32)), byArray, n + 12);
            poly1305.reset();
            return 16;
        }
        throw new OutputLengthException("Output buffer is too short.");
    }

    @Override
    public void reset() {
        Poly1305 poly1305 = this;
        poly1305.currentBlockOffset = 0;
        poly1305.h4 = 0;
        poly1305.h3 = 0;
        poly1305.h2 = 0;
        poly1305.h1 = 0;
        poly1305.h0 = 0;
    }
}

