/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.SICBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher blockCipher) {
        int n;
        this.cipher = blockCipher;
        this.blockSize = n = blockCipher.getBlockSize();
        this.macBlock = new byte[n];
        if (n == 16) {
            return;
        }
        throw new IllegalArgumentException("cipher required with a block size of 16.");
    }

    private int calculateMac(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        CBCBlockCipherMac cBCBlockCipherMac;
        CBCBlockCipherMac cBCBlockCipherMac2 = cBCBlockCipherMac;
        cBCBlockCipherMac2(this.cipher, this.macSize * 8);
        cBCBlockCipherMac.init(this.keyParam);
        int n4 = 16;
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = n3 = (int)(byArray3[0] | ((cBCBlockCipherMac2.getMacSize() - 2) / 2 & 7) << 3);
        byte[] byArray4 = this.nonce;
        byArray3[0] = (byte)(n3 | 15 - byArray4.length - 1 & 7);
        n3 = byArray4.length;
        System.arraycopy(this.nonce, 0, byArray3, 1, n3);
        n3 = 1;
        int n5 = n2;
        while (n5 > 0) {
            int n6 = n5;
            int n7 = n5;
            n5 = n4 - n3;
            byArray3[n5] = (byte)(n7 & 0xFF);
            n5 = n6 >>> 8;
            ++n3;
        }
        cBCBlockCipherMac2.update(byArray3, 0, n4);
        if (this.hasAssociatedText()) {
            int n8;
            int n9;
            n4 = this.getAssociatedTextLength();
            if (n4 < 65280) {
                cBCBlockCipherMac2.update((byte)(n4 >> 8));
                cBCBlockCipherMac2.update((byte)n4);
                n9 = 2;
            } else {
                CBCBlockCipherMac cBCBlockCipherMac3 = cBCBlockCipherMac2;
                cBCBlockCipherMac3.update((byte)-1);
                cBCBlockCipherMac3.update((byte)-2);
                cBCBlockCipherMac2.update((byte)(n4 >> 24));
                cBCBlockCipherMac2.update((byte)(n4 >> 16));
                cBCBlockCipherMac2.update((byte)(n4 >> 8));
                cBCBlockCipherMac2.update((byte)n4);
                n9 = 6;
            }
            byte[] byArray5 = this.initialAssociatedText;
            if (this.initialAssociatedText != null) {
                n5 = byArray5.length;
                cBCBlockCipherMac2.update(byArray5, 0, n5);
            }
            if (this.associatedText.size() > 0) {
                cBCBlockCipherMac2.update(this.associatedText.getBuffer(), 0, this.associatedText.size());
            }
            if ((n8 = (n9 + n4) % 16) != 0) {
                while (n8 != 16) {
                    cBCBlockCipherMac2.update((byte)0);
                    ++n8;
                }
            }
        }
        cBCBlockCipherMac2.update(byArray, n, n2);
        return cBCBlockCipherMac2.doFinal(byArray2, 0);
    }

    private int getMacSize(boolean bl, int n) {
        if (bl && (n < 32 || n > 128 || (n & 0xF) != 0)) {
            throw new IllegalArgumentException("tag length in octets must be one of {4,6,8,10,12,14,16}");
        }
        return n >>> 3;
    }

    private int getAssociatedTextLength() {
        CCMBlockCipher cCMBlockCipher = this;
        int n = cCMBlockCipher.associatedText.size();
        byte[] byArray = cCMBlockCipher.initialAssociatedText;
        int n2 = cCMBlockCipher.initialAssociatedText == null ? 0 : byArray.length;
        return n + n2;
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block7: {
            Object object;
            block6: {
                block5: {
                    this.forEncryption = bl;
                    if (!(cipherParameters instanceof AEADParameters)) break block5;
                    cipherParameters = (AEADParameters)cipherParameters;
                    this.nonce = ((AEADParameters)cipherParameters).getNonce();
                    this.initialAssociatedText = ((AEADParameters)cipherParameters).getAssociatedText();
                    this.macSize = this.getMacSize(bl, ((AEADParameters)cipherParameters).getMacSize());
                    object = ((AEADParameters)cipherParameters).getKey();
                    break block6;
                }
                if (!(cipherParameters instanceof ParametersWithIV)) break block7;
                cipherParameters = (ParametersWithIV)cipherParameters;
                CCMBlockCipher cCMBlockCipher = this;
                cCMBlockCipher.nonce = ((ParametersWithIV)cipherParameters).getIV();
                cCMBlockCipher.initialAssociatedText = null;
                this.macSize = this.getMacSize(bl, 64);
                object = ((ParametersWithIV)cipherParameters).getParameters();
            }
            if (object != null) {
                this.keyParam = object;
            }
            object = this.nonce;
            if (this.nonce != null && ((Object)object).length >= 7 && ((Object)object).length <= 13) {
                this.reset();
                return;
            }
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("invalid parameters passed to CCM: ")));
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    @Override
    public void processAADByte(byte by) {
        ((OutputStream)this.associatedText).write(by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        ((OutputStream)this.associatedText).write(byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        ((OutputStream)this.data).write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length >= n + n2) {
            ((OutputStream)this.data).write(byArray, n, n2);
            return 0;
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        CCMBlockCipher cCMBlockCipher = this;
        int n2 = cCMBlockCipher.processPacket(cCMBlockCipher.data.getBuffer(), 0, this.data.size(), byArray, n);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        CCMBlockCipher cCMBlockCipher = this;
        cCMBlockCipher.cipher.reset();
        cCMBlockCipher.associatedText.reset();
        cCMBlockCipher.data.reset();
    }

    @Override
    public byte[] getMac() {
        int n = this.macSize;
        byte[] byArray = new byte[n];
        System.arraycopy(this.macBlock, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return 0;
    }

    @Override
    public int getOutputSize(int n) {
        CCMBlockCipher cCMBlockCipher = this;
        n = cCMBlockCipher.data.size() + n;
        if (cCMBlockCipher.forEncryption) {
            return n + this.macSize;
        }
        int n2 = this.macSize;
        return n < n2 ? 0 : n - n2;
    }

    public byte[] processPacket(byte[] byArray, int n, int n2) {
        block4: {
            byte[] byArray2;
            block3: {
                block2: {
                    if (!this.forEncryption) break block2;
                    byArray2 = new byte[n2 + this.macSize];
                    break block3;
                }
                int n3 = this.macSize;
                if (n2 < n3) break block4;
                byArray2 = new byte[n2 - n3];
            }
            this.processPacket(byArray, n, n2, byArray2, 0);
            return byArray2;
        }
        throw new InvalidCipherTextException("data too short");
    }

    public int processPacket(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        block7: {
            block11: {
                block12: {
                    block13: {
                        int n4;
                        block10: {
                            int n5;
                            Object object;
                            SICBlockCipher sICBlockCipher;
                            block8: {
                                block9: {
                                    int n6;
                                    int n7;
                                    SICBlockCipher sICBlockCipher2;
                                    if (((CCMBlockCipher)object).keyParam == null) break block7;
                                    byte[] byArray3 = ((CCMBlockCipher)object).nonce;
                                    int n8 = 15 - ((CCMBlockCipher)object).nonce.length;
                                    if (n8 < 4 && n2 >= 1 << n8 * 8) {
                                        throw new IllegalStateException("CCM packet too large for choice of q.");
                                    }
                                    byte[] byArray4 = new byte[((CCMBlockCipher)object).blockSize];
                                    byArray3 = byArray4;
                                    byArray4[0] = (byte)(n8 - 1 & 7);
                                    n8 = byArray3.length;
                                    System.arraycopy(byArray3, 0, byArray3, 1, n8);
                                    sICBlockCipher = sICBlockCipher2;
                                    sICBlockCipher(((CCMBlockCipher)object).cipher);
                                    sICBlockCipher2.init(((CCMBlockCipher)object).forEncryption, new ParametersWithIV(((CCMBlockCipher)object).keyParam, byArray3));
                                    if (!((CCMBlockCipher)object).forEncryption) break block8;
                                    n4 = n2 + ((CCMBlockCipher)object).macSize;
                                    if (byArray2.length < n4 + n3) break block9;
                                    CCMBlockCipher cCMBlockCipher = object;
                                    byte[] byArray5 = ((CCMBlockCipher)object).macBlock;
                                    cCMBlockCipher.calculateMac(byArray, n, n2, byArray5);
                                    byArray5 = new byte[cCMBlockCipher.blockSize];
                                    sICBlockCipher.processBlock(cCMBlockCipher.macBlock, 0, byArray5, 0);
                                    int n9 = n3;
                                    int n10 = n;
                                    while (n10 < (n7 = n + n2) - (n6 = ((CCMBlockCipher)object).blockSize)) {
                                        int n11 = n10;
                                        sICBlockCipher.processBlock(byArray, n10, byArray2, n9);
                                        n10 = ((CCMBlockCipher)object).blockSize;
                                        n9 += n10;
                                        n10 = n11 + n10;
                                    }
                                    CCMBlockCipher cCMBlockCipher2 = object;
                                    byte[] byArray6 = new byte[n6];
                                    object = byArray6;
                                    int n12 = n7 - n10;
                                    System.arraycopy(byArray, n10, object, 0, n12);
                                    sICBlockCipher.processBlock((byte[])object, 0, (byte[])object, 0);
                                    System.arraycopy(byArray6, 0, byArray2, n9, n12);
                                    int n13 = n3 + n2;
                                    n12 = cCMBlockCipher2.macSize;
                                    System.arraycopy(byArray5, 0, byArray2, n13, n12);
                                    break block10;
                                }
                                throw new OutputLengthException("Output buffer too short.");
                            }
                            n4 = ((CCMBlockCipher)object).macSize;
                            if (n2 < n4) break block11;
                            if (byArray2.length < (n2 -= n4) + n3) break block12;
                            int n14 = n + n2;
                            System.arraycopy(byArray, n14, ((CCMBlockCipher)object).macBlock, 0, n4);
                            sICBlockCipher.processBlock(((CCMBlockCipher)object).macBlock, 0, ((CCMBlockCipher)object).macBlock, 0);
                            n4 = ((CCMBlockCipher)object).macSize;
                            while (true) {
                                byte[] byArray7 = ((CCMBlockCipher)object).macBlock;
                                if (n4 == ((CCMBlockCipher)object).macBlock.length) break;
                                byArray7[n4] = 0;
                                ++n4;
                            }
                            int n15 = n3;
                            n4 = n;
                            while (n4 < n14 - (n5 = ((CCMBlockCipher)object).blockSize)) {
                                int n16 = n4;
                                sICBlockCipher.processBlock(byArray, n4, byArray2, n15);
                                n4 = ((CCMBlockCipher)object).blockSize;
                                n15 += n4;
                                n4 = n16 + n4;
                            }
                            Object object2 = object;
                            Object object3 = object;
                            byte[] byArray8 = new byte[n5];
                            object = byArray8;
                            int n17 = n2 - (n4 - n);
                            System.arraycopy(byArray, n4, object, 0, n17);
                            sICBlockCipher.processBlock((byte[])object, 0, (byte[])object, 0);
                            System.arraycopy(byArray8, 0, byArray2, n15, n17);
                            object = new byte[((CCMBlockCipher)object3).blockSize];
                            super.calculateMac(byArray2, n3, n2, (byte[])object);
                            if (!Arrays.constantTimeAreEqual(((CCMBlockCipher)object2).macBlock, (byte[])object)) break block13;
                            n4 = n2;
                        }
                        return n4;
                    }
                    throw new InvalidCipherTextException("mac check in CCM failed");
                }
                throw new OutputLengthException("Output buffer too short.");
            }
            throw new InvalidCipherTextException("data too short");
        }
        throw new IllegalStateException("CCM cipher unitialized.");
    }

    public class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

