/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.CMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.SICBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class EAXBlockCipher
implements AEADBlockCipher {
    private static final byte nTAG = 0;
    private static final byte hTAG = 1;
    private static final byte cTAG = 2;
    private SICBlockCipher cipher;
    private boolean forEncryption;
    private int blockSize;
    private Mac mac;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public EAXBlockCipher(BlockCipher blockCipher) {
        CMac cMac;
        EAXBlockCipher eAXBlockCipher = cMac2;
        eAXBlockCipher.blockSize = blockCipher.getBlockSize();
        CMac cMac2 = cMac;
        eAXBlockCipher.mac = new CMac(blockCipher);
        eAXBlockCipher.macBlock = new byte[eAXBlockCipher.blockSize];
        eAXBlockCipher.associatedTextMac = new byte[cMac2.getMacSize()];
        eAXBlockCipher.nonceMac = new byte[eAXBlockCipher.mac.getMacSize()];
        eAXBlockCipher.cipher = new SICBlockCipher(blockCipher);
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.cipherInitialized = true;
        eAXBlockCipher.mac.doFinal(this.associatedTextMac, 0);
        int n = eAXBlockCipher.blockSize;
        byte[] byArray = new byte[n];
        byte[] byArray2 = byArray;
        byArray[n - 1] = 2;
        eAXBlockCipher.mac.update(byArray2, 0, n);
    }

    private void calculateMac() {
        EAXBlockCipher eAXBlockCipher = this;
        byte[] byArray = new byte[eAXBlockCipher.blockSize];
        eAXBlockCipher.mac.doFinal(byArray, 0);
        int n = 0;
        while (true) {
            byte[] byArray2 = this.macBlock;
            if (n >= this.macBlock.length) break;
            byArray2[n] = (byte)(this.nonceMac[n] ^ this.associatedTextMac[n] ^ byArray[n]);
            ++n;
        }
    }

    private void reset(boolean bl) {
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.cipher.reset();
        eAXBlockCipher.mac.reset();
        eAXBlockCipher.bufOff = 0;
        Arrays.fill(eAXBlockCipher.bufBlock, (byte)0);
        if (bl) {
            Arrays.fill(this.macBlock, (byte)0);
        }
        EAXBlockCipher eAXBlockCipher2 = this;
        int byArray3 = eAXBlockCipher2.blockSize;
        byte[] byArray = new byte[byArray3];
        byte[] byArray2 = byArray;
        byArray[byArray3 - 1] = 1;
        eAXBlockCipher2.mac.update(byArray2, 0, byArray3);
        eAXBlockCipher2.cipherInitialized = false;
        byte[] byArray4 = eAXBlockCipher2.initialAssociatedText;
        if (eAXBlockCipher2.initialAssociatedText != null) {
            int n = byArray4.length;
            this.processAADBytes(byArray4, 0, n);
        }
    }

    private int process(byte by, byte[] byArray, int n) {
        int n2;
        EAXBlockCipher eAXBlockCipher = this;
        byte[] byArray2 = eAXBlockCipher.bufBlock;
        int n3 = eAXBlockCipher.bufOff;
        this.bufOff = n2 = n3 + 1;
        byArray2[n3] = by;
        if (n2 == byArray2.length) {
            int n4 = this.blockSize;
            by = (byte)n4;
            if (byArray.length >= n + n4) {
                if (this.forEncryption) {
                    EAXBlockCipher eAXBlockCipher2 = this;
                    by = (byte)eAXBlockCipher2.cipher.processBlock(byArray2, 0, byArray, n);
                    eAXBlockCipher2.mac.update(byArray, n, this.blockSize);
                } else {
                    EAXBlockCipher eAXBlockCipher3 = this;
                    eAXBlockCipher3.mac.update(byArray2, 0, by);
                    by = (byte)eAXBlockCipher3.cipher.processBlock(this.bufBlock, 0, byArray, n);
                }
                this.bufOff = 0;
                if (!this.forEncryption) {
                    EAXBlockCipher eAXBlockCipher4 = this;
                    EAXBlockCipher eAXBlockCipher5 = this;
                    int n5 = eAXBlockCipher5.blockSize;
                    int n6 = eAXBlockCipher5.macSize;
                    System.arraycopy(eAXBlockCipher4.bufBlock, n5, eAXBlockCipher4.bufBlock, 0, n6);
                    eAXBlockCipher4.bufOff = eAXBlockCipher4.macSize;
                }
                return by;
            }
            throw new OutputLengthException("Output buffer is too short");
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n) {
        int n2 = 0;
        for (int k = 0; k < this.macSize; ++k) {
            n2 |= this.macBlock[k] ^ byArray[n + k];
        }
        return n2 == 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "/EAX";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher.getUnderlyingCipher();
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        block4: {
            ParametersWithIV parametersWithIV;
            CipherParameters cipherParameters;
            block3: {
                block2: {
                    this.forEncryption = bl;
                    if (!(object instanceof AEADParameters)) break block2;
                    AEADParameters aEADParameters = (AEADParameters)object;
                    object = aEADParameters;
                    CipherParameters cipherParameters2 = object;
                    CipherParameters cipherParameters3 = object;
                    object = ((AEADParameters)cipherParameters3).getNonce();
                    this.initialAssociatedText = ((AEADParameters)cipherParameters3).getAssociatedText();
                    this.macSize = ((AEADParameters)cipherParameters2).getMacSize() / 8;
                    cipherParameters = aEADParameters.getKey();
                    break block3;
                }
                if (!(object instanceof ParametersWithIV)) break block4;
                ParametersWithIV parametersWithIV2 = (ParametersWithIV)object;
                object = parametersWithIV2;
                object = ((ParametersWithIV)object).getIV();
                this.initialAssociatedText = null;
                this.macSize = this.mac.getMacSize() / 2;
                cipherParameters = parametersWithIV2.getParameters();
            }
            Object object2 = new byte[bl ? this.blockSize : this.blockSize + this.macSize];
            EAXBlockCipher eAXBlockCipher = this;
            eAXBlockCipher.bufBlock = object2;
            byte[] byArray = new byte[eAXBlockCipher.blockSize];
            object2 = byArray;
            EAXBlockCipher eAXBlockCipher2 = this;
            eAXBlockCipher2.mac.init(cipherParameters);
            int n = eAXBlockCipher2.blockSize;
            byArray[n - 1] = 0;
            eAXBlockCipher.mac.update((byte[])object2, 0, n);
            Object object3 = object;
            eAXBlockCipher.mac.update((byte[])object3, 0, ((Object)object3).length);
            eAXBlockCipher.mac.doFinal(this.nonceMac, 0);
            object2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(null, this.nonceMac);
            eAXBlockCipher.cipher.init(true, (CipherParameters)object2);
            eAXBlockCipher.reset();
            return;
        }
        throw new IllegalArgumentException("invalid parameters passed to EAX");
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void processAADByte(byte by) {
        if (!this.cipherInitialized) {
            this.mac.update(by);
            return;
        }
        throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (!this.cipherInitialized) {
            this.mac.update(byArray, n, n2);
            return;
        }
        throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        this.initCipher();
        return this.process(by, byArray, n);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.initCipher();
        if (byArray.length >= n + n2) {
            int n4 = 0;
            for (int k = 0; k != n2; ++k) {
                int n5 = n4;
                int n6 = n4;
                n4 = byArray[n + k];
                int n7 = n3 + n6;
                n4 = n5 + this.process((byte)n4, byArray2, n7);
            }
            return n4;
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        EAXBlockCipher eAXBlockCipher = this;
        eAXBlockCipher.initCipher();
        int n2 = eAXBlockCipher.bufOff;
        byte[] byArray2 = eAXBlockCipher.bufBlock;
        byte[] byArray3 = new byte[eAXBlockCipher.bufBlock.length];
        eAXBlockCipher.bufOff = 0;
        if (eAXBlockCipher.forEncryption) {
            int n3 = n + n2;
            if (byArray.length >= n3 + this.macSize) {
                EAXBlockCipher eAXBlockCipher2 = this;
                this.cipher.processBlock(byArray2, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n, n2);
                eAXBlockCipher2.mac.update(byArray3, 0, n2);
                eAXBlockCipher2.calculateMac();
                int n4 = this.macSize;
                System.arraycopy(eAXBlockCipher2.macBlock, 0, byArray, n3, n4);
                eAXBlockCipher2.reset(false);
                return n2 + eAXBlockCipher2.macSize;
            }
            throw new OutputLengthException("Output buffer too short");
        }
        int n5 = this.macSize;
        if (n2 >= n5) {
            if (byArray.length >= n + n2 - n5) {
                if (n2 > n5) {
                    EAXBlockCipher eAXBlockCipher3 = this;
                    eAXBlockCipher3.mac.update(byArray2, 0, n2 - n5);
                    eAXBlockCipher3.cipher.processBlock(this.bufBlock, 0, byArray3, 0);
                    int n6 = n2 - eAXBlockCipher3.macSize;
                    System.arraycopy(byArray3, 0, byArray, n, n6);
                }
                EAXBlockCipher eAXBlockCipher4 = this;
                eAXBlockCipher4.calculateMac();
                byArray = eAXBlockCipher4.bufBlock;
                if (this.verifyMac(byArray, n2 - eAXBlockCipher4.macSize)) {
                    EAXBlockCipher eAXBlockCipher5 = this;
                    eAXBlockCipher5.reset(false);
                    return n2 - eAXBlockCipher5.macSize;
                }
                throw new InvalidCipherTextException("mac check in EAX failed");
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new InvalidCipherTextException("data too short");
    }

    @Override
    public byte[] getMac() {
        int n = this.macSize;
        byte[] byArray = new byte[n];
        System.arraycopy(this.macBlock, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        n += this.bufOff;
        if (!this.forEncryption) {
            int n2 = this.macSize;
            if (n < n2) {
                return 0;
            }
            n -= n2;
        }
        int n3 = n;
        return n3 - n3 % this.blockSize;
    }

    @Override
    public int getOutputSize(int n) {
        n += this.bufOff;
        if (this.forEncryption) {
            return n + this.macSize;
        }
        int n2 = this.macSize;
        return n < n2 ? 0 : n - n2;
    }
}

