/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GOST3413CipherUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class G3413CFBBlockCipher
extends StreamBlockCipher {
    private final int s;
    private int m;
    private int blockSize;
    private byte[] R;
    private byte[] R_init;
    private BlockCipher cipher;
    private boolean forEncryption;
    private boolean initialized;
    private byte[] gamma;
    private byte[] inBuf;
    private int byteCount;

    public G3413CFBBlockCipher(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8);
    }

    public G3413CFBBlockCipher(BlockCipher blockCipher, int n) {
        super(blockCipher);
        this.initialized = false;
        if (n >= 0 && n <= blockCipher.getBlockSize() * 8) {
            this.blockSize = blockCipher.getBlockSize();
            this.cipher = blockCipher;
            this.s = n / 8;
            this.inBuf = new byte[this.getBlockSize()];
            return;
        }
        throw new IllegalArgumentException(b.a("Parameter bitBlockSize must be in range 0 < bitBlockSize <= ").append(blockCipher.getBlockSize() * 8).toString());
    }

    private void initArrays() {
        int n = this.m;
        this.R = new byte[n];
        this.R_init = new byte[n];
    }

    private void setupDefaultParams() {
        this.m = this.blockSize * 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl, CipherParameters object) {
        this.forEncryption = bl;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            if (byArray.length < this.blockSize) throw new IllegalArgumentException("Parameter m must blockSize <= m");
            this.m = ((Object)object).length;
            this.initArrays();
            byte[] byArray2 = Arrays.clone((byte[])object);
            object = byArray2;
            this.R_init = (byte[])object;
            object = this.R;
            int n = byArray2.length;
            System.arraycopy(byArray2, 0, object, 0, n);
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            G3413CFBBlockCipher g3413CFBBlockCipher = this;
            g3413CFBBlockCipher.setupDefaultParams();
            g3413CFBBlockCipher.initArrays();
            byte[] byArray = this.R;
            int n = g3413CFBBlockCipher.R_init.length;
            System.arraycopy(g3413CFBBlockCipher.R_init, 0, byArray, 0, n);
            if (object != null) {
                this.cipher.init(true, (CipherParameters)object);
            }
        }
        this.initialized = true;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CFB" + this.blockSize * 8;
    }

    @Override
    public int getBlockSize() {
        return this.s;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        G3413CFBBlockCipher g3413CFBBlockCipher = this;
        g3413CFBBlockCipher.processBytes(byArray, n, this.getBlockSize(), byArray2, n2);
        return g3413CFBBlockCipher.getBlockSize();
    }

    @Override
    public byte calculateByte(byte by) {
        int n;
        if (this.byteCount == 0) {
            this.gamma = this.createGamma();
        }
        G3413CFBBlockCipher g3413CFBBlockCipher = this;
        int n2 = this.byteCount;
        byte by2 = (byte)(g3413CFBBlockCipher.gamma[n2] ^ by);
        byte[] byArray = g3413CFBBlockCipher.inBuf;
        g3413CFBBlockCipher.byteCount = n = n2 + 1;
        if (g3413CFBBlockCipher.forEncryption) {
            by = by2;
        }
        byArray[n2] = by;
        if (n == this.getBlockSize()) {
            G3413CFBBlockCipher g3413CFBBlockCipher2 = this;
            g3413CFBBlockCipher2.byteCount = 0;
            g3413CFBBlockCipher2.generateR(g3413CFBBlockCipher2.inBuf);
        }
        return by2;
    }

    public byte[] createGamma() {
        byte[] byArray = GOST3413CipherUtil.MSB(this.R, this.blockSize);
        byte[] byArray2 = new byte[byArray.length];
        G3413CFBBlockCipher g3413CFBBlockCipher = this;
        g3413CFBBlockCipher.cipher.processBlock(byArray, 0, byArray2, 0);
        return GOST3413CipherUtil.MSB(byArray2, g3413CFBBlockCipher.s);
    }

    public void generateR(byte[] byArray) {
        byte[] byArray2 = byArray;
        G3413CFBBlockCipher g3413CFBBlockCipher = object;
        byArray = GOST3413CipherUtil.LSB(g3413CFBBlockCipher.R, ((G3413CFBBlockCipher)object).m - ((G3413CFBBlockCipher)object).s);
        G3413CFBBlockCipher g3413CFBBlockCipher2 = object;
        Object object = ((G3413CFBBlockCipher)object).R;
        int n = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n);
        object = g3413CFBBlockCipher2.R;
        n = byArray.length;
        int n2 = g3413CFBBlockCipher.m - byArray.length;
        System.arraycopy(byArray2, 0, object, n, n2);
    }

    @Override
    public void reset() {
        G3413CFBBlockCipher g3413CFBBlockCipher = object;
        g3413CFBBlockCipher.byteCount = 0;
        Arrays.clear(g3413CFBBlockCipher.inBuf);
        Arrays.clear(g3413CFBBlockCipher.gamma);
        if (g3413CFBBlockCipher.initialized) {
            G3413CFBBlockCipher g3413CFBBlockCipher2 = object;
            Object object = ((G3413CFBBlockCipher)object).R;
            int n = g3413CFBBlockCipher2.R_init.length;
            System.arraycopy(g3413CFBBlockCipher2.R_init, 0, object, 0, n);
            g3413CFBBlockCipher2.cipher.reset();
        }
    }
}

