/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] iv;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private boolean initialised;
    private BlockCipher engine;

    public KCTRBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.engine = blockCipher;
        this.iv = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    private void incrementCounterAt(int n) {
        while (true) {
            byte by;
            byte[] byArray = this.ofbV;
            if (n >= this.ofbV.length) break;
            int n2 = n;
            int n3 = n2 + 1;
            byArray[n] = by = (byte)(byArray[n2] + 1);
            if (by != 0) break;
            n = n3;
        }
    }

    private void checkCounter() {
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.initialised = true;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            KCTRBlockCipher kCTRBlockCipher = this;
            int n = kCTRBlockCipher.iv.length - byArray.length;
            Arrays.fill(kCTRBlockCipher.iv, (byte)0);
            object = kCTRBlockCipher.iv;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, object, n, n2);
            CipherParameters cipherParameters = parametersWithIV.getParameters();
            if (cipherParameters != null) {
                this.engine.init(true, cipherParameters);
            }
            this.reset();
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed");
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KCTR";
    }

    @Override
    public int getBlockSize() {
        return this.engine.getBlockSize();
    }

    @Override
    public byte calculateByte(byte by) {
        int n;
        int n2 = this.byteCount;
        if (n2 == 0) {
            KCTRBlockCipher kCTRBlockCipher = this;
            kCTRBlockCipher.incrementCounterAt(0);
            kCTRBlockCipher.checkCounter();
            KCTRBlockCipher kCTRBlockCipher2 = this;
            byte[] byArray = kCTRBlockCipher2.ofbV;
            byte[] byArray2 = kCTRBlockCipher2.ofbOutV;
            kCTRBlockCipher.engine.processBlock(byArray, 0, byArray2, 0);
            int n3 = this.byteCount;
            this.byteCount = n3 + 1;
            return (byte)(kCTRBlockCipher.ofbOutV[n3] ^ by);
        }
        byte[] byArray = this.ofbOutV;
        this.byteCount = n = n2 + 1;
        by = (byte)(byArray[n2] ^ by);
        if (n == this.ofbV.length) {
            this.byteCount = 0;
        }
        return by;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray.length - n >= this.getBlockSize()) {
            if (byArray2.length - n2 >= this.getBlockSize()) {
                KCTRBlockCipher kCTRBlockCipher = this;
                kCTRBlockCipher.processBytes(byArray, n, this.getBlockSize(), byArray2, n2);
                return kCTRBlockCipher.getBlockSize();
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        if (this.initialised) {
            KCTRBlockCipher kCTRBlockCipher = this;
            byte[] byArray = kCTRBlockCipher.iv;
            byte[] byArray2 = kCTRBlockCipher.ofbV;
            this.engine.processBlock(byArray, 0, byArray2, 0);
        }
        this.engine.reset();
        this.byteCount = 0;
    }
}

