/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class KXTSBlockCipher
extends BufferedBlockCipher {
    private static final long RED_POLY_128 = 135L;
    private static final long RED_POLY_256 = 1061L;
    private static final long RED_POLY_512 = 293L;
    private final int blockSize;
    private final long reductionPolynomial;
    private final long[] tw_init;
    private final long[] tw_current;
    private int counter;

    public static long getReductionPolynomial(int n) {
        if (n != 16) {
            if (n != 32) {
                if (n == 64) {
                    return 293L;
                }
                throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
            }
            return 1061L;
        }
        return 135L;
    }

    public KXTSBlockCipher(BlockCipher blockCipher) {
        int n;
        KXTSBlockCipher kXTSBlockCipher = this;
        this.cipher = blockCipher;
        this.blockSize = n = blockCipher.getBlockSize();
        this.reductionPolynomial = KXTSBlockCipher.getReductionPolynomial(n);
        this.tw_init = new long[n >>> 3];
        kXTSBlockCipher.tw_current = new long[n >>> 3];
        kXTSBlockCipher.counter = -1;
    }

    private void processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.counter;
        if (n3 != -1) {
            KXTSBlockCipher kXTSBlockCipher = this;
            kXTSBlockCipher.counter = n3 + 1;
            KXTSBlockCipher.GF_double(kXTSBlockCipher.reductionPolynomial, this.tw_current);
            byte[] byArray3 = new byte[kXTSBlockCipher.blockSize];
            KXTSBlockCipher kXTSBlockCipher2 = this;
            Pack.longToLittleEndian(kXTSBlockCipher2.tw_current, byArray3, 0);
            int n4 = kXTSBlockCipher2.blockSize;
            byte[] byArray4 = new byte[n4];
            System.arraycopy(byArray3, 0, byArray4, 0, n4);
            for (n4 = 0; n4 < this.blockSize; ++n4) {
                byArray4[n4] = (byte)(byArray4[n4] ^ byArray[n + n4]);
            }
            this.cipher.processBlock(byArray4, 0, byArray4, 0);
            for (int k = 0; k < this.blockSize; ++k) {
                n = n2 + k;
                byArray2[n] = (byte)(byArray4[k] ^ byArray3[k]);
            }
            return;
        }
        throw new IllegalStateException("Attempt to process too many blocks");
    }

    private static void GF_double(long l, long[] lArray) {
        long l2 = 0L;
        for (int k = 0; k < lArray.length; ++k) {
            long l3 = lArray[k];
            long l4 = l3 >>> 63;
            lArray[k] = l3 << 1 ^ l2;
            l2 = l4;
        }
        lArray[0] = l = lArray[0] ^ l & -l2;
    }

    @Override
    public int getOutputSize(int n) {
        return n;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        return n;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters2 instanceof ParametersWithIV) {
            Object object;
            int n;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters2;
            cipherParameters2 = parametersWithIV.getParameters();
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length == (n = ((KXTSBlockCipher)object).blockSize)) {
                KXTSBlockCipher kXTSBlockCipher = object;
                byte[] byArray2 = new byte[n];
                KXTSBlockCipher kXTSBlockCipher2 = object;
                System.arraycopy(byArray, 0, byArray2, 0, n);
                kXTSBlockCipher2.cipher.init(true, cipherParameters2);
                kXTSBlockCipher2.cipher.processBlock(byArray2, 0, byArray2, 0);
                kXTSBlockCipher2.cipher.init(bl, cipherParameters2);
                Pack.littleEndianToLong(byArray2, 0, kXTSBlockCipher2.tw_init);
                object = ((KXTSBlockCipher)object).tw_current;
                int n2 = kXTSBlockCipher.tw_init.length;
                System.arraycopy(kXTSBlockCipher.tw_init, 0, object, 0, n2);
                kXTSBlockCipher.counter = 0;
                return;
            }
            throw new IllegalArgumentException("Currently only support IVs of exactly one block");
        }
        throw new IllegalArgumentException("Invalid parameters passed");
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length - n >= n2) {
            if (byArray2.length - n >= n2) {
                if (n2 % this.blockSize == 0) {
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5 = n4;
                        KXTSBlockCipher kXTSBlockCipher = this;
                        int n6 = n4;
                        n4 = n + n4;
                        int n7 = n3 + n6;
                        kXTSBlockCipher.processBlock(byArray, n4, byArray2, n7);
                        n4 = n5 + kXTSBlockCipher.blockSize;
                    }
                    return n2;
                }
                throw new IllegalArgumentException("Partial blocks not supported");
            }
            throw new OutputLengthException("Output buffer too short");
        }
        throw new DataLengthException("Input buffer too short");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.reset();
        return 0;
    }

    @Override
    public void reset() {
        KXTSBlockCipher kXTSBlockCipher = object;
        kXTSBlockCipher.cipher.reset();
        Object object = ((KXTSBlockCipher)object).tw_current;
        int n = kXTSBlockCipher.tw_init.length;
        System.arraycopy(kXTSBlockCipher.tw_init, 0, object, 0, n);
        kXTSBlockCipher.counter = 0;
    }
}

