/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final byte[] data;
    private Ed25519PublicKeyParameters cachedPublicKey;

    public Ed25519PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        byte[] byArray = new byte[32];
        Object object = byArray;
        v1.data = byArray;
        Ed25519.generatePrivateKey(secureRandom, (byte[])object);
    }

    public Ed25519PrivateKeyParameters(byte[] byArray, int n) {
        super(true);
        byte[] byArray2 = new byte[32];
        Object object = byArray2;
        v1.data = byArray2;
        System.arraycopy(byArray, n, object, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream object) {
        InputStream inputStream = object;
        super(true);
        byte[] byArray = new byte[32];
        object = byArray;
        this.data = byArray;
        if (32 == Streams.readFully(inputStream, (byte[])object)) {
            return;
        }
        throw new EOFException("EOF encountered in middle of Ed25519 private key");
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Ed25519PublicKeyParameters generatePublicKey() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = this;
        byte[] byArray = ed25519PrivateKeyParameters.data;
        synchronized (ed25519PrivateKeyParameters.data) {
            if (ed25519PrivateKeyParameters.cachedPublicKey == null) {
                byte[] byArray2 = new byte[32];
                Ed25519.generatePublicKey(this.data, 0, byArray2, 0);
                this.cachedPublicKey = new Ed25519PublicKeyParameters(byArray2, 0);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cachedPublicKey;
        }
    }

    public void sign(int n, Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        this.sign(n, byArray, byArray2, n2, n3, byArray3, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sign(int n, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        byte[] byArray4 = new byte[32];
        this.generatePublicKey().encode(byArray4, 0);
        if (n != 0) {
            if (n != 1) {
                if (n != 2) throw new IllegalArgumentException("algorithm");
                if (64 != n3) throw new IllegalArgumentException("msgLen");
                Ed25519.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n2, byArray3, n4);
                return;
            } else {
                Ed25519.sign(this.data, 0, byArray4, 0, byArray, byArray2, n2, n3, byArray3, n4);
            }
            return;
        } else {
            if (byArray != null) throw new IllegalArgumentException("ctx");
            Ed25519.sign(this.data, 0, byArray4, 0, byArray2, n2, n3, byArray3, n4);
        }
    }
}

