/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PublicKeyParameters;

public class XDHUPrivateParameters
implements CipherParameters {
    private AsymmetricKeyParameter staticPrivateKey;
    private AsymmetricKeyParameter ephemeralPrivateKey;
    private AsymmetricKeyParameter ephemeralPublicKey;

    public XDHUPrivateParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        this(asymmetricKeyParameter, asymmetricKeyParameter2, null);
    }

    public XDHUPrivateParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2, AsymmetricKeyParameter asymmetricKeyParameter3) {
        if (asymmetricKeyParameter != null) {
            boolean bl = asymmetricKeyParameter instanceof X448PrivateKeyParameters;
            if (!bl && !(asymmetricKeyParameter instanceof X25519PrivateKeyParameters)) {
                throw new IllegalArgumentException("only X25519 and X448 paramaters can be used");
            }
            if (asymmetricKeyParameter2 != null) {
                if (asymmetricKeyParameter.getClass().isAssignableFrom(asymmetricKeyParameter2.getClass())) {
                    if (asymmetricKeyParameter3 == null) {
                        asymmetricKeyParameter3 = asymmetricKeyParameter2 instanceof X448PrivateKeyParameters ? ((X448PrivateKeyParameters)asymmetricKeyParameter2).generatePublicKey() : ((X25519PrivateKeyParameters)asymmetricKeyParameter2).generatePublicKey();
                    } else {
                        if (asymmetricKeyParameter3 instanceof X448PublicKeyParameters && !bl) {
                            throw new IllegalArgumentException("ephemeral public key has different domain parameters");
                        }
                        if (asymmetricKeyParameter3 instanceof X25519PublicKeyParameters && !(asymmetricKeyParameter instanceof X25519PrivateKeyParameters)) {
                            throw new IllegalArgumentException("ephemeral public key has different domain parameters");
                        }
                    }
                    XDHUPrivateParameters xDHUPrivateParameters = this;
                    xDHUPrivateParameters.staticPrivateKey = asymmetricKeyParameter;
                    xDHUPrivateParameters.ephemeralPrivateKey = asymmetricKeyParameter2;
                    xDHUPrivateParameters.ephemeralPublicKey = asymmetricKeyParameter3;
                    return;
                }
                throw new IllegalArgumentException("static and ephemeral private keys have different domain parameters");
            }
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        throw new NullPointerException("staticPrivateKey cannot be null");
    }

    public AsymmetricKeyParameter getStaticPrivateKey() {
        return this.staticPrivateKey;
    }

    public AsymmetricKeyParameter getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public AsymmetricKeyParameter getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

