/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.DRBGProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import java.security.SecureRandom;

public class SP800SecureRandom
extends SecureRandom {
    private final DRBGProvider drbgProvider;
    private final boolean predictionResistant;
    private final SecureRandom randomSource;
    private final EntropySource entropySource;
    private SP80090DRBG drbg;

    public SP800SecureRandom(SecureRandom secureRandom, EntropySource entropySource, DRBGProvider dRBGProvider, boolean bl) {
        this.randomSource = secureRandom;
        this.entropySource = entropySource;
        this.drbgProvider = dRBGProvider;
        this.predictionResistant = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSeed(byte[] byArray) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            SecureRandom secureRandom = sP800SecureRandom.randomSource;
            if (secureRandom != null) {
                secureRandom.setSeed(byArray);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSeed(long l) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            SecureRandom secureRandom = sP800SecureRandom.randomSource;
            if (secureRandom != null) {
                secureRandom.setSeed(l);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getAlgorithm() {
        return this.drbgProvider.getAlgorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void nextBytes(byte[] byArray) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            byte[] byArray2;
            if (sP800SecureRandom.drbg == null) {
                this.drbg = this.drbgProvider.get(this.entropySource);
            }
            if (this.drbg.generate(byArray, byArray2 = null, this.predictionResistant) < 0) {
                SP800SecureRandom sP800SecureRandom2 = this;
                sP800SecureRandom2.drbg.reseed(null);
                byte[] byArray3 = byArray;
                byArray = null;
                sP800SecureRandom2.drbg.generate(byArray3, byArray, this.predictionResistant);
            }
            {
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public byte[] generateSeed(int n) {
        return EntropyUtil.generateSeed(this.entropySource, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reseed(byte[] byArray) {
        SP800SecureRandom sP800SecureRandom = this;
        synchronized (sP800SecureRandom) {
            if (sP800SecureRandom.drbg == null) {
                this.drbg = this.drbgProvider.get(this.entropySource);
            }
            SP800SecureRandom sP800SecureRandom2 = this;
            sP800SecureRandom2.drbg.reseed(byArray);
            // ** MonitorExit[v1] (shouldn't be in output)
            return;
        }
    }
}

