/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;

public class X931RNG {
    private static final long BLOCK64_RESEED_MAX = 32768L;
    private static final long BLOCK128_RESEED_MAX = 0x800000L;
    private static final int BLOCK64_MAX_BITS_REQUEST = 4096;
    private static final int BLOCK128_MAX_BITS_REQUEST = 262144;
    private final BlockCipher engine;
    private final EntropySource entropySource;
    private final byte[] DT;
    private final byte[] I;
    private final byte[] R;
    private byte[] V;
    private long reseedCounter;

    public X931RNG(BlockCipher object, byte[] byArray, EntropySource entropySource) {
        BlockCipher blockCipher = object;
        BlockCipher blockCipher2 = object;
        this.reseedCounter = 1L;
        this.engine = object;
        this.entropySource = entropySource;
        byte[] byArray2 = new byte[object.getBlockSize()];
        object = byArray2;
        this.DT = (byte[])object;
        int n = byArray2.length;
        System.arraycopy(byArray, 0, object, 0, n);
        this.I = new byte[blockCipher2.getBlockSize()];
        this.R = new byte[blockCipher.getBlockSize()];
    }

    private void process(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int k = 0; k != byArray.length; ++k) {
            byArray[k] = (byte)(byArray2[k] ^ byArray3[k]);
        }
        this.engine.processBlock(byArray, 0, byArray, 0);
    }

    private void increment(byte[] byArray) {
        for (int k = byArray.length - 1; k >= 0; --k) {
            byte by;
            byArray[k] = by = (byte)(byArray[k] + 1);
            if (by != 0) break;
        }
    }

    private static boolean isTooLarge(byte[] byArray, int n) {
        return byArray != null && byArray.length > n;
    }

    public int generate(byte[] byArray, boolean n) {
        block11: {
            block13: {
                byte[] byArray2;
                int n2;
                block12: {
                    block10: {
                        block9: {
                            if (this.R.length != 8) break block9;
                            if (this.reseedCounter > 32768L) {
                                return -1;
                            }
                            if (X931RNG.isTooLarge(byArray, 512)) {
                                throw new IllegalArgumentException("Number of bits per request limited to 4096");
                            }
                            break block10;
                        }
                        if (this.reseedCounter > 0x800000L) {
                            return -1;
                        }
                        if (X931RNG.isTooLarge(byArray, 32768)) break block11;
                    }
                    if (n == 0 && this.V != null) break block12;
                    byte[] byArray3 = this.entropySource.getEntropy();
                    this.V = byArray3;
                    if (byArray3.length != this.engine.getBlockSize()) break block13;
                }
                n = byArray.length / this.R.length;
                for (n2 = 0; n2 < n; ++n2) {
                    X931RNG x931RNG = this;
                    X931RNG x931RNG2 = this;
                    byte[] byArray4 = x931RNG2.DT;
                    byte[] byArray5 = x931RNG2.I;
                    x931RNG.engine.processBlock(byArray4, 0, byArray5, 0);
                    byArray4 = x931RNG.R;
                    byArray5 = x931RNG.I;
                    byArray2 = x931RNG.V;
                    x931RNG.process(byArray4, byArray5, byArray2);
                    byArray4 = x931RNG.V;
                    byArray5 = x931RNG.R;
                    byArray2 = x931RNG.I;
                    x931RNG.process(byArray4, byArray5, byArray2);
                    int n3 = n2 * x931RNG.R.length;
                    int n4 = x931RNG.R.length;
                    System.arraycopy(x931RNG.R, 0, byArray, n3, n4);
                    x931RNG.increment(x931RNG.DT);
                }
                n2 = byArray.length - n * this.R.length;
                if (n2 > 0) {
                    X931RNG x931RNG = this;
                    X931RNG x931RNG3 = this;
                    byte[] byArray6 = x931RNG3.DT;
                    byte[] byArray7 = x931RNG3.I;
                    x931RNG.engine.processBlock(byArray6, 0, byArray7, 0);
                    byArray6 = x931RNG.R;
                    byArray7 = x931RNG.I;
                    byArray2 = x931RNG.V;
                    x931RNG.process(byArray6, byArray7, byArray2);
                    byArray6 = x931RNG.V;
                    byArray7 = x931RNG.R;
                    byArray2 = x931RNG.I;
                    x931RNG.process(byArray6, byArray7, byArray2);
                    System.arraycopy(x931RNG.R, 0, byArray, n *= x931RNG.R.length, n2);
                    x931RNG.increment(x931RNG.DT);
                }
                ++this.reseedCounter;
                return byArray.length;
            }
            throw new IllegalStateException("Insufficient entropy returned");
        }
        throw new IllegalArgumentException("Number of bits per request limited to 262144");
    }

    public void reseed() {
        byte[] byArray = this.entropySource.getEntropy();
        this.V = byArray;
        if (byArray.length == this.engine.getBlockSize()) {
            this.reseedCounter = 1L;
            return;
        }
        throw new IllegalStateException("Insufficient entropy returned");
    }

    public EntropySource getEntropySource() {
        return this.entropySource;
    }
}

