/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Hashtable;

class Utils {
    public static final Hashtable maxSecurityStrengths = new Hashtable<String, Integer>();

    public static int getMaxSecurityStrength(Digest digest) {
        return (Integer)maxSecurityStrengths.get(digest.getAlgorithmName());
    }

    public static int getMaxSecurityStrength(Mac mac) {
        String string = mac.getAlgorithmName();
        return (Integer)maxSecurityStrengths.get(string.substring(0, string.indexOf("/")));
    }

    public static byte[] hash_df(Digest digest, byte[] byArray, int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray2 = new byte[n2];
        int n3 = n2 / digest.getDigestSize();
        int n4 = 1;
        int n5 = digest.getDigestSize();
        byte[] byArray3 = new byte[n5];
        for (int k = 0; k <= n3; ++k) {
            digest.update((byte)n4);
            digest.update((byte)(n >> 24));
            digest.update((byte)(n >> 16));
            digest.update((byte)(n >> 8));
            digest.update((byte)n);
            digest.update(byArray, 0, byArray.length);
            digest.doFinal(byArray3, 0);
            int n6 = k * n5;
            int n7 = n2 - n6;
            if (n7 > n5) {
                n7 = n5;
            }
            System.arraycopy(byArray3, 0, byArray2, n6, n7);
            ++n4;
        }
        int n8 = n % 8;
        if (n8 != 0) {
            n8 = 8 - n8;
            int n9 = 0;
            for (n = 0; n != n2; ++n) {
                n3 = byArray2[n] & 0xFF;
                byArray2[n] = (byte)(n3 >>> n8 | n9 << 8 - n8);
                n9 = n3;
            }
        }
        return byArray2;
    }

    public static boolean isTooLarge(byte[] byArray, int n) {
        return byArray != null && byArray.length > n;
    }

    static {
        maxSecurityStrengths.put("SHA-1", Integers.valueOf(128));
        maxSecurityStrengths.put("SHA-224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-256", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-384", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512/224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-512/256", Integers.valueOf(256));
    }
}

