/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECGOST3410_2012Signer
implements DSAExt {
    public ECKeyParameters key;
    public SecureRandom random;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ECGOST3410_2012Signer eCGOST3410_2012Signer = parametersWithRandom;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                eCGOST3410_2012Signer.random = parametersWithRandom.getRandom();
                eCGOST3410_2012Signer.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                ((ECGOST3410_2012Signer)((Object)parametersWithRandom)).random = CryptoServicesRegistrar.getSecureRandom();
                ((ECGOST3410_2012Signer)((Object)parametersWithRandom)).key = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            ((ECGOST3410_2012Signer)((Object)parametersWithRandom)).key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] object) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        ECGOST3410_2012Signer eCGOST3410_2012Signer = this;
        object = Arrays.reverse((byte[])object);
        BigInteger bigInteger5 = bigInteger4;
        bigInteger4 = new BigInteger(1, (byte[])object);
        ECDomainParameters eCDomainParameters = eCGOST3410_2012Signer.key.getParameters();
        object = eCDomainParameters;
        BigInteger bigInteger6 = eCDomainParameters.getN();
        BigInteger bigInteger7 = ((ECPrivateKeyParameters)eCGOST3410_2012Signer.key).getD();
        ECMultiplier eCMultiplier = eCGOST3410_2012Signer.createBasePointMultiplier();
        while ((bigInteger3 = BigIntegers.createRandomBigInteger(bigInteger6.bitLength(), this.random)).equals(bigInteger2 = ECConstants.ZERO) || (bigInteger = eCMultiplier.multiply(((ECDomainParameters)object).getG(), bigInteger3).normalize().getAffineXCoord().toBigInteger().mod(bigInteger6)).equals(bigInteger2) || (bigInteger3 = bigInteger3.multiply(bigInteger5).add(bigInteger7.multiply(bigInteger)).mod(bigInteger6)).equals(bigInteger2)) {
        }
        return new BigInteger[]{bigInteger, bigInteger3};
    }

    @Override
    public boolean verifySignature(byte[] object, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        object = Arrays.reverse((byte[])object);
        BigInteger bigInteger4 = bigInteger3;
        bigInteger3 = new BigInteger(1, (byte[])object);
        object = ((ECGOST3410_2012Signer)((Object)eCPoint)).key.getParameters().getN();
        BigInteger bigInteger5 = ECConstants.ONE;
        if (bigInteger.compareTo(bigInteger5) >= 0 && bigInteger.compareTo((BigInteger)object) < 0) {
            if (bigInteger2.compareTo(bigInteger5) >= 0 && bigInteger2.compareTo((BigInteger)object) < 0) {
                BigInteger bigInteger6 = bigInteger2;
                bigInteger2 = BigIntegers.modOddInverseVar((BigInteger)object, bigInteger4);
                bigInteger4 = bigInteger6.multiply(bigInteger2).mod((BigInteger)object);
                bigInteger2 = ((BigInteger)object).subtract(bigInteger).multiply(bigInteger2).mod((BigInteger)object);
                ECPoint eCPoint = ECAlgorithms.sumOfTwoMultiplies(((ECGOST3410_2012Signer)((Object)eCPoint)).key.getParameters().getG(), bigInteger4, ((ECPublicKeyParameters)((ECGOST3410_2012Signer)((Object)eCPoint)).key).getQ(), bigInteger2).normalize();
                if (eCPoint.isInfinity()) {
                    return false;
                }
                return eCPoint.getAffineXCoord().toBigInteger().mod((BigInteger)object).equals(bigInteger);
            }
            return false;
        }
        return false;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

