/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Ed448phSigner
implements Signer {
    private final Xof prehash = Ed448.createPrehash();
    private final byte[] context;
    private boolean forSigning;
    private Ed448PrivateKeyParameters privateKey;
    private Ed448PublicKeyParameters publicKey;

    public Ed448phSigner(byte[] byArray) {
        this.context = Arrays.clone(byArray);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            Ed448phSigner ed448phSigner = this;
            ed448phSigner.privateKey = (Ed448PrivateKeyParameters)cipherParameters;
            ed448phSigner.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed448PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.prehash.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.prehash.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (this.forSigning && this.privateKey != null) {
            byte[] byArray = new byte[64];
            if (64 == this.prehash.doFinal(byArray, 0, 64)) {
                byte[] byArray2 = new byte[114];
                this.privateKey.sign(1, this.context, byArray, 0, 64, byArray2, 0);
                return byArray2;
            }
            throw new IllegalStateException("Prehash digest failed");
        }
        throw new IllegalStateException("Ed448phSigner not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Object object;
        if (!((Ed448phSigner)object2).forSigning && (object = ((Ed448phSigner)object2).publicKey) != null) {
            if (114 != byArray.length) {
                ((Ed448phSigner)object2).prehash.reset();
                return false;
            }
            byte[] byArray2 = byArray;
            Ed448phSigner ed448phSigner = object2;
            Object object2 = ((Ed448PublicKeyParameters)object).getEncoded();
            byArray = ed448phSigner.context;
            object = ed448phSigner.prehash;
            return Ed448.verifyPrehash(byArray2, 0, (byte[])object2, 0, byArray, (Xof)object);
        }
        throw new IllegalStateException("Ed448phSigner not initialised for verification");
    }

    @Override
    public void reset() {
        this.prehash.reset();
    }
}

