/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SignerWithRecovery;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ISOTrailers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;
    private byte[] preSig;
    private byte[] preBlock;

    public ISO9796d2Signer(AsymmetricBlockCipher object, Digest digest, boolean bl) {
        block4: {
            block3: {
                block2: {
                    this.cipher = object;
                    this.digest = digest;
                    if (!bl) break block2;
                    this.trailer = 188;
                    break block3;
                }
                object = ISOTrailers.getTrailer(digest);
                if (object == null) break block4;
                this.trailer = (Integer)object;
            }
            return;
        }
        throw new IllegalArgumentException(b.a("no valid trailer for digest: ").append(digest.getAlgorithmName()).toString());
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = this.messageLength;
        byte[] byArray3 = this.mBuf;
        if (n > this.mBuf.length) {
            if (byArray3.length > byArray2.length) {
                bl = false;
            }
            for (n = 0; n != this.mBuf.length; ++n) {
                if (byArray[n] == byArray2[n]) continue;
                bl = false;
            }
        } else {
            if (n != byArray2.length) {
                bl = false;
            }
            for (int k = 0; k != byArray2.length; ++k) {
                if (byArray[k] == byArray2[k]) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void clearBlock(byte[] byArray) {
        for (int k = 0; k != byArray.length; ++k) {
            byArray[k] = 0;
        }
    }

    private boolean returnFalse(byte[] byArray) {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.messageLength = 0;
        iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
        this.clearBlock(byArray);
        return false;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        cipherParameters = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, cipherParameters);
        this.keyBits = ((RSAKeyParameters)cipherParameters).getModulus().bitLength();
        byte[] byArray = new byte[(this.keyBits + 7) / 8];
        this.block = byArray;
        this.mBuf = this.trailer == 188 ? new byte[byArray.length - this.digest.getDigestSize() - 2] : new byte[byArray.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) {
        block8: {
            block9: {
                block12: {
                    int n;
                    int n2;
                    byte[] byArray2;
                    block11: {
                        block10: {
                            byArray2 = ((ISO9796d2Signer)object).cipher.processBlock(byArray, 0, byArray.length);
                            if ((byArray2[0] & 0xC0 ^ 0x40) != 0) break block8;
                            if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) break block9;
                            if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) != 0) break block10;
                            n2 = 1;
                            break block11;
                        }
                        n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
                        Integer n3 = ISOTrailers.getTrailer(((ISO9796d2Signer)object).digest);
                        if (n3 == null) break block12;
                        n = n3;
                        if (n2 != n && (n != 15052 || n2 != 16588)) {
                            throw new IllegalStateException(a.a("signer initialised with wrong digest for trailer ", n2));
                        }
                        n2 = 2;
                    }
                    for (n = 0; n != byArray2.length && (byArray2[n] & 0xF ^ 0xA) != 0; ++n) {
                    }
                    if ((n2 = byArray2.length - n2 - ((ISO9796d2Signer)object).digest.getDigestSize() - ++n) > 0) {
                        if ((byArray2[0] & 0x20) == 0) {
                            ((ISO9796d2Signer)object).fullMessage = true;
                            byte[] byArray3 = new byte[n2];
                            ((ISO9796d2Signer)object).recoveredMessage = byArray3;
                            int n4 = byArray3.length;
                            System.arraycopy(byArray2, n, byArray3, 0, n4);
                        } else {
                            ((ISO9796d2Signer)object).fullMessage = false;
                            byte[] byArray4 = new byte[n2];
                            ((ISO9796d2Signer)object).recoveredMessage = byArray4;
                            int n5 = byArray4.length;
                            System.arraycopy(byArray2, n, byArray4, 0, n5);
                        }
                        ISO9796d2Signer iSO9796d2Signer = object;
                        ((ISO9796d2Signer)object).preSig = byArray;
                        iSO9796d2Signer.preBlock = byArray2;
                        iSO9796d2Signer.digest.update(((ISO9796d2Signer)object).recoveredMessage, 0, ((ISO9796d2Signer)object).recoveredMessage.length);
                        byArray = iSO9796d2Signer.recoveredMessage;
                        ((ISO9796d2Signer)object).messageLength = byArray.length;
                        Object object = ((ISO9796d2Signer)object).mBuf;
                        int n6 = byArray.length;
                        System.arraycopy(iSO9796d2Signer.recoveredMessage, 0, object, 0, n6);
                        return;
                    }
                    throw new InvalidCipherTextException("malformed block");
                }
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            throw new InvalidCipherTextException("malformed signature");
        }
        throw new InvalidCipherTextException("malformed signature");
    }

    @Override
    public void update(byte by) {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.update(by);
        int n = iSO9796d2Signer.messageLength;
        byte[] byArray = this.mBuf;
        if (n < this.mBuf.length) {
            byArray[n] = by;
        }
        this.messageLength = n + 1;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        while (n2 > 0 && this.messageLength < this.mBuf.length) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.update(byArray, n, n2);
        iSO9796d2Signer.messageLength += n2;
    }

    @Override
    public void reset() {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.reset();
        iSO9796d2Signer.messageLength = 0;
        iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
        byte[] byArray = iSO9796d2Signer.recoveredMessage;
        if (iSO9796d2Signer.recoveredMessage != null) {
            this.clearBlock(byArray);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
        if (this.preSig != null) {
            ISO9796d2Signer iSO9796d2Signer2 = this;
            iSO9796d2Signer2.preSig = null;
            iSO9796d2Signer2.clearBlock(iSO9796d2Signer2.preBlock);
            iSO9796d2Signer2.preBlock = null;
        }
    }

    @Override
    public byte[] generateSignature() {
        int n;
        int n2;
        int n3;
        ISO9796d2Signer iSO9796d2Signer = object;
        int n4 = iSO9796d2Signer.digest.getDigestSize();
        if (iSO9796d2Signer.trailer == 188) {
            ISO9796d2Signer iSO9796d2Signer2 = object;
            n3 = 8;
            byte[] byArray = iSO9796d2Signer2.block;
            n2 = iSO9796d2Signer2.block.length - n4 - 1;
            iSO9796d2Signer2.digest.doFinal(byArray, n2);
            iSO9796d2Signer2.block[iSO9796d2Signer2.block.length - 1] = -68;
        } else {
            ISO9796d2Signer iSO9796d2Signer3 = object;
            n3 = 16;
            byte[] byArray = iSO9796d2Signer3.block;
            n2 = iSO9796d2Signer3.block.length - n4 - 2;
            iSO9796d2Signer3.digest.doFinal(byArray, n2);
            byArray = iSO9796d2Signer3.block;
            int n5 = byArray.length - 2;
            int n6 = ((ISO9796d2Signer)object).trailer;
            byArray[n5] = (byte)(n6 >>> 8);
            int n7 = byArray.length - 1;
            iSO9796d2Signer3.block[n7] = (byte)n6;
        }
        int n8 = n4;
        n4 = ((ISO9796d2Signer)object).messageLength;
        n3 = (n8 + n4) * 8 + n3 + 4 - ((ISO9796d2Signer)object).keyBits;
        if (n3 > 0) {
            n4 -= (n3 + 7) / 8;
            n3 = 96;
            n = n2 - n4;
            System.arraycopy(((ISO9796d2Signer)object).mBuf, 0, ((ISO9796d2Signer)object).block, n, n4);
            ((ISO9796d2Signer)object).recoveredMessage = new byte[n4];
        } else {
            ISO9796d2Signer iSO9796d2Signer4 = object;
            n3 = 64;
            n = n2 - n4;
            System.arraycopy(iSO9796d2Signer4.mBuf, 0, ((ISO9796d2Signer)object).block, n, n4);
            iSO9796d2Signer4.recoveredMessage = new byte[iSO9796d2Signer4.messageLength];
        }
        n4 = n - 1;
        if (n4 > 0) {
            for (n = n4; n != 0; --n) {
                ((ISO9796d2Signer)object).block[n] = -69;
            }
            byte[] byArray = ((ISO9796d2Signer)object).block;
            byte[] byArray2 = ((ISO9796d2Signer)object).block;
            byArray2[n4] = (byte)(byArray[n4] ^ 1);
            byArray[0] = 11;
            byArray2[0] = (byte)(0xB | n3);
        } else {
            ((ISO9796d2Signer)object).block[0] = 10;
            ((ISO9796d2Signer)object).block[0] = (byte)(0xA | n3);
        }
        byte[] byArray = ((ISO9796d2Signer)object).cipher.processBlock(((ISO9796d2Signer)object).block, 0, ((ISO9796d2Signer)object).block.length);
        n3 = (n3 & 0x20) == 0 ? 1 : 0;
        ISO9796d2Signer iSO9796d2Signer5 = object;
        iSO9796d2Signer5.fullMessage = n3;
        Object object = ((ISO9796d2Signer)object).recoveredMessage;
        int n9 = ((ISO9796d2Signer)object).recoveredMessage.length;
        System.arraycopy(iSO9796d2Signer5.mBuf, 0, object, 0, n9);
        iSO9796d2Signer5.messageLength = 0;
        iSO9796d2Signer5.clearBlock(iSO9796d2Signer5.mBuf);
        iSO9796d2Signer5.clearBlock(iSO9796d2Signer5.block);
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        block22: {
            block25: {
                byte[] byArray2;
                int n;
                int n2;
                int n3;
                block24: {
                    block23: {
                        byte[] byArray3 = this.preSig;
                        if (this.preSig == null) {
                            int n4;
                            AsymmetricBlockCipher asymmetricBlockCipher;
                            try {
                                asymmetricBlockCipher = this.cipher;
                                n4 = 0;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                            byArray = asymmetricBlockCipher.processBlock(byArray, n4, byArray.length);
                        }
                        if (!Arrays.areEqual(byArray3, byArray)) break block22;
                        byArray = this.preBlock;
                        this.preSig = null;
                        this.preBlock = null;
                        if ((byArray[0] & 0xC0 ^ 0x40) != 0) {
                            return this.returnFalse(byArray);
                        }
                        if ((byArray[byArray.length - 1] & 0xF ^ 0xC) != 0) {
                            return this.returnFalse(byArray);
                        }
                        if ((byArray[byArray.length - 1] & 0xFF ^ 0xBC) != 0) break block23;
                        n3 = 1;
                        break block24;
                    }
                    n3 = (byArray[byArray.length - 2] & 0xFF) << 8 | byArray[byArray.length - 1] & 0xFF;
                    Integer n5 = ISOTrailers.getTrailer(this.digest);
                    if (n5 == null) break block25;
                    n2 = n5;
                    if (n3 != n2 && (n2 != 15052 || n3 != 16588)) {
                        throw new IllegalStateException(a.a("signer initialised with wrong digest for trailer ", n3));
                    }
                    n3 = 2;
                }
                for (n2 = 0; n2 != byArray.length && (byArray[n2] & 0xF ^ 0xA) != 0; ++n2) {
                }
                int n6 = this.digest.getDigestSize();
                byte[] byArray4 = new byte[n6];
                if ((n = (n3 = byArray.length - n3 - n6) - ++n2) <= 0) {
                    return this.returnFalse(byArray);
                }
                if ((byArray[0] & 0x20) == 0) {
                    this.fullMessage = true;
                    if (this.messageLength > n) {
                        return this.returnFalse(byArray);
                    }
                    ISO9796d2Signer iSO9796d2Signer = this;
                    iSO9796d2Signer.digest.reset();
                    iSO9796d2Signer.digest.update(byArray, n2, n);
                    iSO9796d2Signer.digest.doFinal(byArray4, 0);
                    boolean bl = true;
                    for (int k = 0; k != n6; ++k) {
                        byte by;
                        int n7 = n3 + k;
                        byArray[n7] = by = (byte)(byArray[n7] ^ byArray4[k]);
                        if (by == 0) continue;
                        bl = false;
                    }
                    if (!bl) {
                        return this.returnFalse(byArray);
                    }
                    byArray2 = new byte[n];
                    this.recoveredMessage = byArray2;
                    n6 = byArray2.length;
                    System.arraycopy(byArray, n2, byArray2, 0, n6);
                } else {
                    this.fullMessage = false;
                    this.digest.doFinal(byArray4, 0);
                    boolean bl = true;
                    for (int k = 0; k != n6; ++k) {
                        byte by;
                        int n8 = n3 + k;
                        byArray[n8] = by = (byte)(byArray[n8] ^ byArray4[k]);
                        if (by == 0) continue;
                        bl = false;
                    }
                    if (!bl) {
                        return this.returnFalse(byArray);
                    }
                    byArray2 = new byte[n];
                    this.recoveredMessage = byArray2;
                    n6 = byArray2.length;
                    System.arraycopy(byArray, n2, byArray2, 0, n6);
                }
                if (this.messageLength != 0) {
                    ISO9796d2Signer iSO9796d2Signer = this;
                    byArray2 = iSO9796d2Signer.mBuf;
                    if (!iSO9796d2Signer.isSameAs(byArray2, iSO9796d2Signer.recoveredMessage)) {
                        return this.returnFalse(byArray);
                    }
                }
                ISO9796d2Signer iSO9796d2Signer = this;
                iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
                this.clearBlock(byArray);
                this.messageLength = 0;
                return true;
            }
            throw new IllegalArgumentException("unrecognised hash in signature");
        }
        throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
    }

    @Override
    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

