/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class PlainDSAEncoding
implements DSAEncoding {
    public static final PlainDSAEncoding INSTANCE = new PlainDSAEncoding();

    private void encodeValue(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n, int n2) {
        byte[] byArray2 = ((PlainDSAEncoding)this).checkValue(bigInteger, bigInteger2).toByteArray();
        Object object = this = (Object)byArray2;
        int n3 = Math.max(0, ((Object)object).length - n2);
        int n4 = ((Object)object).length - n3;
        int n5 = n2 - n4 + n;
        Arrays.fill(byArray, n, n5, (byte)0);
        System.arraycopy(byArray2, n3, byArray, n5, n4);
    }

    @Override
    public byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = BigIntegers.getUnsignedByteLength(bigInteger);
        byte[] byArray = new byte[n * 2];
        this.encodeValue(bigInteger, bigInteger2, byArray, 0, n);
        int n2 = n;
        this.encodeValue(bigInteger, bigInteger3, byArray, n2, n2);
        return byArray;
    }

    @Override
    public BigInteger[] decode(BigInteger bigInteger, byte[] byArray) {
        int n = BigIntegers.getUnsignedByteLength(bigInteger);
        if (byArray.length == n * 2) {
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = this.decodeValue(bigInteger, byArray, 0, n);
            int n2 = n;
            bigIntegerArray[1] = this.decodeValue(bigInteger, byArray, n2, n2);
            return bigIntegerArray;
        }
        throw new IllegalArgumentException("Encoding has incorrect length");
    }

    public BigInteger checkValue(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.signum() >= 0 && bigInteger2.compareTo(bigInteger) < 0) {
            return bigInteger2;
        }
        throw new IllegalArgumentException("Value out of range");
    }

    public BigInteger decodeValue(BigInteger bigInteger, byte[] byArray, int n, int n2) {
        PlainDSAEncoding plainDSAEncoding = object;
        int n3 = n;
        Object object = Arrays.copyOfRange(byArray, n3, n3 + n2);
        return plainDSAEncoding.checkValue(bigInteger, new BigInteger(1, (byte[])object));
    }
}

