/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ISOTrailers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class X931Signer
implements Signer {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    public static final int TRAILER_SHA224 = 14540;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private RSAKeyParameters kParam;
    private int trailer;
    private int keyBits;
    private byte[] block;

    public X931Signer(AsymmetricBlockCipher object, Digest digest, boolean bl) {
        block4: {
            block3: {
                block2: {
                    this.cipher = object;
                    this.digest = digest;
                    if (!bl) break block2;
                    this.trailer = 188;
                    break block3;
                }
                object = ISOTrailers.getTrailer(digest);
                if (object == null) break block4;
                this.trailer = (Integer)object;
            }
            return;
        }
        throw new IllegalArgumentException(b.a("no valid trailer for digest: ").append(digest.getAlgorithmName()).toString());
    }

    public X931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    private void clearBlock(byte[] byArray) {
        for (int k = 0; k != byArray.length; ++k) {
            byArray[k] = 0;
        }
    }

    private void createSignatureBlock(int n) {
        int n2 = this.digest.getDigestSize();
        if (n == 188) {
            X931Signer x931Signer = this;
            byte[] byArray = x931Signer.block;
            n2 = x931Signer.block.length - n2 - 1;
            x931Signer.digest.doFinal(byArray, n2);
            x931Signer.block[x931Signer.block.length - 1] = -68;
        } else {
            X931Signer x931Signer = this;
            byte[] byArray = x931Signer.block;
            n2 = x931Signer.block.length - n2 - 2;
            x931Signer.digest.doFinal(byArray, n2);
            byArray = x931Signer.block;
            int n3 = n;
            int n4 = n;
            n = byArray.length - 2;
            byArray[n] = (byte)(n4 >>> 8);
            n = byArray.length - 1;
            x931Signer.block[n] = (byte)n3;
        }
        this.block[0] = 107;
        for (int k = n2 - 2; k != 0; --k) {
            this.block[k] = -69;
        }
        this.block[n2 - 1] = -70;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        X931Signer x931Signer = this;
        cipherParameters = (RSAKeyParameters)cipherParameters;
        x931Signer.kParam = cipherParameters;
        x931Signer.cipher.init(bl, cipherParameters);
        this.keyBits = x931Signer.kParam.getModulus().bitLength();
        x931Signer.block = new byte[(this.keyBits + 7) / 8];
        x931Signer.reset();
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    @Override
    public byte[] generateSignature() {
        BigInteger bigInteger;
        X931Signer x931Signer = bigInteger3;
        x931Signer.createSignatureBlock(x931Signer.trailer);
        BigInteger bigInteger2 = bigInteger;
        X931Signer x931Signer2 = bigInteger3;
        bigInteger2(1, ((X931Signer)((Object)bigInteger3)).cipher.processBlock(((X931Signer)((Object)bigInteger3)).block, 0, ((X931Signer)((Object)bigInteger3)).block.length));
        x931Signer2.clearBlock(x931Signer2.block);
        BigInteger bigInteger3 = bigInteger.min(x931Signer2.kParam.getModulus().subtract(bigInteger2));
        return BigIntegers.asUnsignedByteArray(BigIntegers.getUnsignedByteLength(x931Signer.kParam.getModulus()), bigInteger3);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        BigInteger bigInteger;
        int n;
        AsymmetricBlockCipher asymmetricBlockCipher;
        try {
            X931Signer x931Signer = this;
            X931Signer x931Signer2 = x931Signer;
            asymmetricBlockCipher = x931Signer.cipher;
            n = 0;
        }
        catch (Exception exception) {
            return false;
        }
        x931Signer2.block = asymmetricBlockCipher.processBlock(byArray, n, byArray.length);
        Object object = bigInteger;
        if ((new BigInteger(1, this.block).intValue() & 0xF) == 12 || (((BigInteger)(object = this.kParam.getModulus().subtract((BigInteger)object))).intValue() & 0xF) == 12) {
            X931Signer x931Signer = this;
            x931Signer.createSignatureBlock(x931Signer.trailer);
            object = BigIntegers.asUnsignedByteArray(x931Signer.block.length, (BigInteger)object);
            boolean bl = Arrays.constantTimeAreEqual(x931Signer.block, (byte[])object);
            if (x931Signer.trailer == 15052 && !bl) {
                byte[] byArray2 = this.block;
                byArray2[byArray2.length - 2] = 64;
                bl = Arrays.constantTimeAreEqual(this.block, (byte[])object);
            }
            X931Signer x931Signer3 = this;
            x931Signer3.clearBlock(x931Signer3.block);
            this.clearBlock((byte[])object);
            return bl;
        }
        return false;
    }
}

