/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import c.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.JournalingSecureRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JournaledAlgorithm
implements Encodable,
Serializable {
    private transient JournalingSecureRandom journaling;
    private transient AlgorithmIdentifier algID;

    public JournaledAlgorithm(AlgorithmIdentifier algorithmIdentifier, JournalingSecureRandom journalingSecureRandom) {
        if (algorithmIdentifier != null) {
            if (journalingSecureRandom != null) {
                JournaledAlgorithm journaledAlgorithm = this;
                journaledAlgorithm.journaling = journalingSecureRandom;
                journaledAlgorithm.algID = algorithmIdentifier;
                return;
            }
            throw new NullPointerException("JournalingSecureRandom passed to JournaledAlgorithm is null");
        }
        throw new NullPointerException("AlgorithmIdentifier passed to JournaledAlgorithm is null");
    }

    public JournaledAlgorithm(byte[] byArray) {
        this(byArray, CryptoServicesRegistrar.getSecureRandom());
    }

    public JournaledAlgorithm(byte[] byArray, SecureRandom secureRandom) {
        if (byArray != null) {
            if (secureRandom != null) {
                this.initFromEncoding(byArray, secureRandom);
                return;
            }
            throw new NullPointerException("random passed to JournaledAlgorithm is null");
        }
        throw new NullPointerException("encoding passed to JournaledAlgorithm is null");
    }

    private void initFromEncoding(byte[] byArray, SecureRandom secureRandom) {
        JournaledAlgorithm journaledAlgorithm = encodable;
        Encodable encodable = ASN1Sequence.getInstance(byArray);
        journaledAlgorithm.algID = AlgorithmIdentifier.getInstance(((ASN1Sequence)encodable).getObjectAt(0));
        journaledAlgorithm.journaling = new JournalingSecureRandom(a.a((ASN1Sequence)encodable, 1), secureRandom);
    }

    public static JournaledAlgorithm getState(InputStream inputStream, SecureRandom secureRandom) {
        if (inputStream != null) {
            JournaledAlgorithm journaledAlgorithm;
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                journaledAlgorithm = new JournaledAlgorithm(Streams.readAll(bufferedInputStream2), secureRandom);
                ((InputStream)bufferedInputStream2).close();
            }
            catch (Throwable throwable) {
                ((InputStream)bufferedInputStream2).close();
                throw throwable;
            }
            return journaledAlgorithm;
        }
        throw new NullPointerException("stream for loading is null in JournaledAlgorithm");
    }

    public static JournaledAlgorithm getState(File file, SecureRandom secureRandom) {
        if (file != null) {
            JournaledAlgorithm journaledAlgorithm;
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                journaledAlgorithm = new JournaledAlgorithm(Streams.readAll(bufferedInputStream2), secureRandom);
                ((InputStream)bufferedInputStream2).close();
            }
            catch (Throwable throwable) {
                ((InputStream)bufferedInputStream2).close();
                throw throwable;
            }
            return journaledAlgorithm;
        }
        throw new NullPointerException("File for loading is null in JournaledAlgorithm");
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.initFromEncoding((byte[])objectInputStream2.readObject(), CryptoServicesRegistrar.getSecureRandom());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public JournalingSecureRandom getJournalingSecureRandom() {
        return this.journaling;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algID;
    }

    public void storeState(File file) {
        if (file != null) {
            FileOutputStream fileOutputStream;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2(file);
            try {
                this.storeState(fileOutputStream2);
            }
            catch (Throwable throwable) {
                fileOutputStream2.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        throw new NullPointerException("file for storage is null in JournaledAlgorithm");
    }

    public void storeState(OutputStream outputStream) {
        if (outputStream != null) {
            outputStream.write(this.getEncoded());
            return;
        }
        throw new NullPointerException("output stream for storage is null in JournaledAlgorithm");
    }

    @Override
    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2();
        aSN1EncodableVector.add(this.algID);
        aSN1EncodableVector.add(new DEROctetString(this.journaling.getFullTranscript()));
        return new DERSequence(aSN1EncodableVector2).getEncoded();
    }
}

