/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import java.io.IOException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.util.Collection;

public class PKIXCertStoreSelector<T extends Certificate>
implements Selector<T> {
    private final CertSelector baseSelector;

    private PKIXCertStoreSelector(CertSelector certSelector) {
        this.baseSelector = certSelector;
    }

    public static Collection<? extends Certificate> getCertificates(PKIXCertStoreSelector pKIXCertStoreSelector, CertStore certStore) {
        return certStore.getCertificates(new SelectorClone(pKIXCertStoreSelector));
    }

    public /* synthetic */ PKIXCertStoreSelector(CertSelector certSelector, 1 var2_2) {
        this(certSelector);
    }

    public Certificate getCertificate() {
        Cloneable cloneable = cloneable.baseSelector;
        if (cloneable instanceof X509CertSelector) {
            return ((X509CertSelector)cloneable).getCertificate();
        }
        return null;
    }

    @Override
    public boolean match(Certificate certificate) {
        return this.baseSelector.match(certificate);
    }

    @Override
    public Object clone() {
        return new PKIXCertStoreSelector<T>(this.baseSelector);
    }

    public static class SelectorClone
    extends X509CertSelector {
        private final PKIXCertStoreSelector selector;

        public SelectorClone(PKIXCertStoreSelector cloneable) {
            this.selector = cloneable;
            if (((PKIXCertStoreSelector)cloneable).baseSelector instanceof X509CertSelector) {
                SelectorClone selectorClone = this;
                cloneable = (X509CertSelector)((PKIXCertStoreSelector)cloneable).baseSelector;
                selectorClone.setAuthorityKeyIdentifier(((X509CertSelector)cloneable).getAuthorityKeyIdentifier());
                selectorClone.setBasicConstraints(((X509CertSelector)cloneable).getBasicConstraints());
                selectorClone.setCertificate(((X509CertSelector)cloneable).getCertificate());
                selectorClone.setCertificateValid(((X509CertSelector)cloneable).getCertificateValid());
                selectorClone.setKeyUsage(((X509CertSelector)cloneable).getKeyUsage());
                selectorClone.setMatchAllSubjectAltNames(((X509CertSelector)cloneable).getMatchAllSubjectAltNames());
                selectorClone.setPrivateKeyValid(((X509CertSelector)cloneable).getPrivateKeyValid());
                selectorClone.setSerialNumber(((X509CertSelector)cloneable).getSerialNumber());
                selectorClone.setSubjectKeyIdentifier(((X509CertSelector)cloneable).getSubjectKeyIdentifier());
                selectorClone.setSubjectPublicKey(((X509CertSelector)cloneable).getSubjectPublicKey());
                try {
                    selectorClone.setExtendedKeyUsage(((X509CertSelector)cloneable).getExtendedKeyUsage());
                    selectorClone.setIssuer(((X509CertSelector)cloneable).getIssuerAsBytes());
                    selectorClone.setNameConstraints(((X509CertSelector)cloneable).getNameConstraints());
                    selectorClone.setPathToNames(((X509CertSelector)cloneable).getPathToNames());
                    selectorClone.setPolicy(((X509CertSelector)cloneable).getPolicy());
                    selectorClone.setSubject(((X509CertSelector)cloneable).getSubjectAsBytes());
                    selectorClone.setSubjectAlternativeNames(((X509CertSelector)cloneable).getSubjectAlternativeNames());
                    selectorClone.setSubjectPublicKeyAlgID(((X509CertSelector)cloneable).getSubjectPublicKeyAlgID());
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(b.a(iOException, b.b.a("base selector invalid: ")), iOException);
                }
            }
        }

        @Override
        public boolean match(Certificate certificate) {
            Cloneable cloneable = ((SelectorClone)cloneable).selector;
            return cloneable == null ? certificate != null : ((PKIXCertStoreSelector)cloneable).match(certificate);
        }
    }

    public static class Builder {
        private final CertSelector baseSelector;

        public Builder(CertSelector certSelector) {
            this.baseSelector = (CertSelector)certSelector.clone();
        }

        public PKIXCertStoreSelector<? extends Certificate> build() {
            return new PKIXCertStoreSelector(this.baseSelector, null);
        }
    }
}

