/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCRLStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStoreSelector;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PKIXExtendedParameters
implements CertPathParameters {
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private final PKIXParameters baseParameters;
    private final PKIXCertStoreSelector targetConstraints;
    private final Date date;
    private final List<PKIXCertStore> extraCertStores;
    private final Map<GeneralName, PKIXCertStore> namedCertificateStoreMap;
    private final List<PKIXCRLStore> extraCRLStores;
    private final Map<GeneralName, PKIXCRLStore> namedCRLStoreMap;
    private final boolean revocationEnabled;
    private final boolean useDeltas;
    private final int validityModel;
    private final Set<TrustAnchor> trustAnchors;

    private PKIXExtendedParameters(Builder builder) {
        PKIXExtendedParameters pKIXExtendedParameters = this;
        PKIXExtendedParameters pKIXExtendedParameters2 = this;
        this.baseParameters = builder.baseParameters;
        this.date = builder.date;
        pKIXExtendedParameters2.extraCertStores = Collections.unmodifiableList(builder.extraCertStores);
        pKIXExtendedParameters2.namedCertificateStoreMap = Collections.unmodifiableMap(new HashMap(builder.namedCertificateStoreMap));
        pKIXExtendedParameters.extraCRLStores = Collections.unmodifiableList(builder.extraCRLStores);
        pKIXExtendedParameters.namedCRLStoreMap = Collections.unmodifiableMap(new HashMap(builder.namedCRLStoreMap));
        this.targetConstraints = builder.targetConstraints;
        this.revocationEnabled = builder.revocationEnabled;
        this.useDeltas = builder.useDeltas;
        this.validityModel = builder.validityModel;
        this.trustAnchors = Collections.unmodifiableSet(builder.trustAnchors);
    }

    public /* synthetic */ PKIXExtendedParameters(Builder builder, 1 var2_2) {
        this(builder);
    }

    public List<PKIXCertStore> getCertificateStores() {
        return this.extraCertStores;
    }

    public Map<GeneralName, PKIXCertStore> getNamedCertificateStoreMap() {
        return this.namedCertificateStoreMap;
    }

    public List<PKIXCRLStore> getCRLStores() {
        return this.extraCRLStores;
    }

    public Map<GeneralName, PKIXCRLStore> getNamedCRLStoreMap() {
        return this.namedCRLStoreMap;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public boolean isUseDeltasEnabled() {
        return this.useDeltas;
    }

    public int getValidityModel() {
        return this.validityModel;
    }

    @Override
    public Object clone() {
        return this;
    }

    public PKIXCertStoreSelector getTargetConstraints() {
        return this.targetConstraints;
    }

    public Set getTrustAnchors() {
        return this.trustAnchors;
    }

    public Set getInitialPolicies() {
        return this.baseParameters.getInitialPolicies();
    }

    public String getSigProvider() {
        return this.baseParameters.getSigProvider();
    }

    public boolean isExplicitPolicyRequired() {
        return this.baseParameters.isExplicitPolicyRequired();
    }

    public boolean isAnyPolicyInhibited() {
        return this.baseParameters.isAnyPolicyInhibited();
    }

    public boolean isPolicyMappingInhibited() {
        return this.baseParameters.isPolicyMappingInhibited();
    }

    public List getCertPathCheckers() {
        return this.baseParameters.getCertPathCheckers();
    }

    public List<CertStore> getCertStores() {
        return this.baseParameters.getCertStores();
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.baseParameters.getPolicyQualifiersRejected();
    }

    public static class Builder {
        private final PKIXParameters baseParameters;
        private final Date date;
        private PKIXCertStoreSelector targetConstraints;
        private List<PKIXCertStore> extraCertStores;
        private Map<GeneralName, PKIXCertStore> namedCertificateStoreMap;
        private List<PKIXCRLStore> extraCRLStores;
        private Map<GeneralName, PKIXCRLStore> namedCRLStoreMap;
        private boolean revocationEnabled;
        private int validityModel;
        private boolean useDeltas;
        private Set<TrustAnchor> trustAnchors;

        public Builder(PKIXParameters pKIXParameters) {
            this.extraCertStores = new ArrayList<PKIXCertStore>();
            this.namedCertificateStoreMap = new HashMap<GeneralName, PKIXCertStore>();
            this.extraCRLStores = new ArrayList<PKIXCRLStore>();
            this.namedCRLStoreMap = new HashMap<GeneralName, PKIXCRLStore>();
            this.validityModel = 0;
            this.useDeltas = false;
            this.baseParameters = (PKIXParameters)pKIXParameters.clone();
            Cloneable cloneable = pKIXParameters.getTargetCertConstraints();
            if (cloneable != null) {
                this.targetConstraints = new PKIXCertStoreSelector.Builder((CertSelector)cloneable).build();
            }
            if ((cloneable = pKIXParameters.getDate()) == null) {
                Date date;
                cloneable = date;
                date = new Date();
            }
            this.date = cloneable;
            this.revocationEnabled = pKIXParameters.isRevocationEnabled();
            this.trustAnchors = pKIXParameters.getTrustAnchors();
        }

        public Builder(PKIXExtendedParameters pKIXExtendedParameters) {
            Builder builder = this;
            this.extraCertStores = new ArrayList<PKIXCertStore>();
            this.namedCertificateStoreMap = new HashMap<GeneralName, PKIXCertStore>();
            this.extraCRLStores = new ArrayList<PKIXCRLStore>();
            this.namedCRLStoreMap = new HashMap<GeneralName, PKIXCRLStore>();
            this.validityModel = 0;
            this.useDeltas = false;
            this.baseParameters = pKIXExtendedParameters.baseParameters;
            this.date = pKIXExtendedParameters.date;
            builder.targetConstraints = pKIXExtendedParameters.targetConstraints;
            builder.extraCertStores = new ArrayList<PKIXCertStore>(pKIXExtendedParameters.extraCertStores);
            builder.namedCertificateStoreMap = new HashMap<GeneralName, PKIXCertStore>(pKIXExtendedParameters.namedCertificateStoreMap);
            builder.extraCRLStores = new ArrayList<PKIXCRLStore>(pKIXExtendedParameters.extraCRLStores);
            builder.namedCRLStoreMap = new HashMap<GeneralName, PKIXCRLStore>(pKIXExtendedParameters.namedCRLStoreMap);
            this.useDeltas = pKIXExtendedParameters.useDeltas;
            this.validityModel = pKIXExtendedParameters.validityModel;
            this.revocationEnabled = pKIXExtendedParameters.isRevocationEnabled();
            this.trustAnchors = pKIXExtendedParameters.getTrustAnchors();
        }

        public Builder addCertificateStore(PKIXCertStore pKIXCertStore) {
            Builder builder = this;
            builder.extraCertStores.add(pKIXCertStore);
            return builder;
        }

        public Builder addNamedCertificateStore(GeneralName generalName, PKIXCertStore pKIXCertStore) {
            Builder builder = this;
            builder.namedCertificateStoreMap.put(generalName, pKIXCertStore);
            return builder;
        }

        public Builder addCRLStore(PKIXCRLStore pKIXCRLStore) {
            Builder builder = this;
            builder.extraCRLStores.add(pKIXCRLStore);
            return builder;
        }

        public Builder addNamedCRLStore(GeneralName generalName, PKIXCRLStore pKIXCRLStore) {
            Builder builder = this;
            builder.namedCRLStoreMap.put(generalName, pKIXCRLStore);
            return builder;
        }

        public Builder setTargetConstraints(PKIXCertStoreSelector pKIXCertStoreSelector) {
            this.targetConstraints = pKIXCertStoreSelector;
            return this;
        }

        public Builder setUseDeltasEnabled(boolean bl) {
            this.useDeltas = bl;
            return this;
        }

        public Builder setValidityModel(int n) {
            this.validityModel = n;
            return this;
        }

        public Builder setTrustAnchor(TrustAnchor trustAnchor) {
            this.trustAnchors = Collections.singleton(trustAnchor);
            return this;
        }

        public Builder setTrustAnchors(Set<TrustAnchor> set) {
            this.trustAnchors = set;
            return this;
        }

        public void setRevocationEnabled(boolean bl) {
            this.revocationEnabled = bl;
        }

        public PKIXExtendedParameters build() {
            return new PKIXExtendedParameters(this, null);
        }
    }
}

