/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.DHUnifiedAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.MQVBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.DHKEKGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHMQVPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHMQVPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHUPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHUPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHUParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.MQVParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final DHUnifiedAgreement unifiedAgreement;
    private final BasicAgreement mqvAgreement;
    private DHUParameterSpec dheParameters;
    private MQVParameterSpec mqvParameters;
    private BigInteger x;
    private BigInteger p;
    private BigInteger g;
    private byte[] result;

    public KeyAgreementSpi() {
        this("Diffie-Hellman", null);
    }

    public KeyAgreementSpi(String string, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = null;
        this.mqvAgreement = null;
    }

    public KeyAgreementSpi(String string, DHUnifiedAgreement dHUnifiedAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = dHUnifiedAgreement;
        this.mqvAgreement = null;
    }

    public KeyAgreementSpi(String string, BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = null;
        this.mqvAgreement = basicAgreement;
    }

    private DHPrivateKeyParameters generatePrivateKeyParameter(PrivateKey object) {
        if (object instanceof DHPrivateKey) {
            DHParameters dHParameters;
            if (object instanceof BCDHPrivateKey) {
                return ((BCDHPrivateKey)object).engineGetKeyParameters();
            }
            Object object2 = (DHPrivateKey)object;
            object = object2.getParams();
            object2 = object2.getX();
            DHParameters dHParameters2 = dHParameters;
            Object object3 = object;
            object = ((DHParameterSpec)object3).getP();
            BigInteger bigInteger = ((DHParameterSpec)object3).getG();
            int n = ((DHParameterSpec)object3).getL();
            dHParameters = new DHParameters((BigInteger)object, bigInteger, null, n);
            return new DHPrivateKeyParameters((BigInteger)object2, dHParameters2);
        }
        throw new InvalidKeyException("private key not a DHPrivateKey");
    }

    private DHPublicKeyParameters generatePublicKeyParameter(PublicKey object) {
        if (object instanceof DHPublicKey) {
            DHParameters dHParameters;
            if (object instanceof BCDHPublicKey) {
                return ((BCDHPublicKey)object).engineGetKeyParameters();
            }
            Object object2 = (DHPublicKey)object;
            if ((object = object2.getParams()) instanceof DHDomainParameterSpec) {
                return new DHPublicKeyParameters(object2.getY(), ((DHDomainParameterSpec)object).getDomainParameters());
            }
            object2 = object2.getY();
            DHParameters dHParameters2 = dHParameters;
            Object object3 = object;
            object = ((DHParameterSpec)object3).getP();
            BigInteger bigInteger = ((DHParameterSpec)object3).getG();
            int n = ((DHParameterSpec)object3).getL();
            dHParameters = new DHParameters((BigInteger)object, bigInteger, null, n);
            return new DHPublicKeyParameters((BigInteger)object2, dHParameters2);
        }
        throw new InvalidKeyException("public key not a DHPublicKey");
    }

    public byte[] bigIntToBytes(BigInteger object) {
        int n = (this.p.bitLength() + 7) / 8;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        if (byArray.length == n) {
            return object;
        }
        if (object[0] == false && ((Object)object).length == n + 1) {
            n = ((Object)object).length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(object, 1, byArray2, 0, n);
            return byArray2;
        }
        byte[] byArray3 = new byte[n];
        Object object2 = object;
        int n2 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray3, n -= ((Object)object).length, n2);
        return byArray3;
    }

    @Override
    public Key engineDoPhase(Key object, boolean bl) {
        if (((KeyAgreementSpi)object2).x != null) {
            if (object instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)object;
                if (dHPublicKey.getParams().getG().equals(((KeyAgreementSpi)object2).g) && dHPublicKey.getParams().getP().equals(((KeyAgreementSpi)object2).p)) {
                    BigInteger bigInteger;
                    BigInteger bigInteger2 = dHPublicKey.getY();
                    if (bigInteger2 != null && bigInteger2.compareTo(TWO) >= 0 && bigInteger2.compareTo(((KeyAgreementSpi)object2).p.subtract(bigInteger = ONE)) < 0) {
                        Object object2;
                        if (((KeyAgreementSpi)object2).unifiedAgreement != null) {
                            if (bl) {
                                DHUPublicParameters dHUPublicParameters;
                                KeyAgreementSpi keyAgreementSpi = object2;
                                object2 = keyAgreementSpi.generatePublicKeyParameter((PublicKey)object);
                                object = keyAgreementSpi.generatePublicKeyParameter(keyAgreementSpi.dheParameters.getOtherPartyEphemeralKey());
                                DHUPublicParameters dHUPublicParameters2 = dHUPublicParameters;
                                dHUPublicParameters = new DHUPublicParameters((DHPublicKeyParameters)object2, (DHPublicKeyParameters)object);
                                keyAgreementSpi.result = keyAgreementSpi.unifiedAgreement.calculateAgreement(dHUPublicParameters2);
                                return null;
                            }
                            throw new IllegalStateException("unified Diffie-Hellman can use only two key pairs");
                        }
                        if (((KeyAgreementSpi)object2).mqvAgreement != null) {
                            if (bl) {
                                DHMQVPublicParameters dHMQVPublicParameters;
                                KeyAgreementSpi keyAgreementSpi = object2;
                                object2 = keyAgreementSpi.generatePublicKeyParameter((PublicKey)object);
                                object = keyAgreementSpi.generatePublicKeyParameter(keyAgreementSpi.mqvParameters.getOtherPartyEphemeralKey());
                                DHMQVPublicParameters dHMQVPublicParameters2 = dHMQVPublicParameters;
                                dHMQVPublicParameters = new DHMQVPublicParameters((DHPublicKeyParameters)object2, (DHPublicKeyParameters)object);
                                keyAgreementSpi.result = keyAgreementSpi.bigIntToBytes(keyAgreementSpi.mqvAgreement.calculateAgreement(dHMQVPublicParameters2));
                                return null;
                            }
                            throw new IllegalStateException("MQV Diffie-Hellman can use only two key pairs");
                        }
                        KeyAgreementSpi keyAgreementSpi = object2;
                        object = keyAgreementSpi.x;
                        if (((BigInteger)(object = bigInteger2.modPow((BigInteger)object, keyAgreementSpi.p))).compareTo(bigInteger) != 0) {
                            ((KeyAgreementSpi)object2).result = ((KeyAgreementSpi)object2).bigIntToBytes((BigInteger)object);
                            if (bl) {
                                return null;
                            }
                            return new BCDHPublicKey((BigInteger)object, dHPublicKey.getParams());
                        }
                        throw new InvalidKeyException("Shared key can't be 1");
                    }
                    throw new InvalidKeyException("Invalid DH PublicKey");
                }
                throw new InvalidKeyException("DHPublicKey not for this KeyAgreement!");
            }
            throw new InvalidKeyException("DHKeyAgreement doPhase requires DHPublicKey");
        }
        throw new IllegalStateException("Diffie-Hellman not initialised.");
    }

    @Override
    public byte[] engineGenerateSecret() {
        if (this.x != null) {
            return super.engineGenerateSecret();
        }
        throw new IllegalStateException("Diffie-Hellman not initialised.");
    }

    @Override
    public int engineGenerateSecret(byte[] byArray, int n) {
        if (this.x != null) {
            return super.engineGenerateSecret(byArray, n);
        }
        throw new IllegalStateException("Diffie-Hellman not initialised.");
    }

    @Override
    public SecretKey engineGenerateSecret(String string) {
        if (this.x != null) {
            if (string.equals("TlsPremasterSecret")) {
                return new SecretKeySpec(BaseAgreementSpi.trimZeroes(this.result), string);
            }
            return super.engineGenerateSecret(string);
        }
        throw new IllegalStateException("Diffie-Hellman not initialised.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(Key key, AlgorithmParameterSpec object, SecureRandom object2) {
        if (!(key instanceof DHPrivateKey)) throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey for initialisation");
        key = (DHPrivateKey)key;
        if (object != null) {
            if (object instanceof DHParameterSpec) {
                KeyAgreementSpi keyAgreementSpi = bigInteger;
                object = (DHParameterSpec)object;
                keyAgreementSpi.p = ((DHParameterSpec)object).getP();
                keyAgreementSpi.g = ((DHParameterSpec)object).getG();
                keyAgreementSpi.dheParameters = null;
                keyAgreementSpi.ukmParameters = null;
            } else if (object instanceof DHUParameterSpec) {
                if (((KeyAgreementSpi)((Object)bigInteger)).unifiedAgreement == null) throw new InvalidAlgorithmParameterException("agreement algorithm not DHU based");
                ((KeyAgreementSpi)((Object)bigInteger)).p = key.getParams().getP();
                ((KeyAgreementSpi)((Object)bigInteger)).g = key.getParams().getG();
                object = (DHUParameterSpec)object;
                ((KeyAgreementSpi)((Object)bigInteger)).dheParameters = object;
                ((BaseAgreementSpi)((Object)bigInteger)).ukmParameters = ((DHUParameterSpec)object).getUserKeyingMaterial();
                if (((KeyAgreementSpi)((Object)bigInteger)).dheParameters.getEphemeralPublicKey() != null) {
                    BigInteger bigInteger = bigInteger;
                    object = super.generatePrivateKeyParameter((PrivateKey)key);
                    object2 = super.generatePrivateKeyParameter(((KeyAgreementSpi)((Object)bigInteger)).dheParameters.getEphemeralPrivateKey());
                    DHPublicKeyParameters dHPublicKeyParameters = super.generatePublicKeyParameter(((KeyAgreementSpi)((Object)bigInteger)).dheParameters.getEphemeralPublicKey());
                    ((KeyAgreementSpi)((Object)bigInteger)).unifiedAgreement.init(new DHUPrivateParameters((DHPrivateKeyParameters)object, (DHPrivateKeyParameters)object2, dHPublicKeyParameters));
                } else {
                    Object object3 = bigInteger;
                    object = super.generatePrivateKeyParameter((PrivateKey)key);
                    ((KeyAgreementSpi)((Object)bigInteger)).unifiedAgreement.init(new DHUPrivateParameters((DHPrivateKeyParameters)object, super.generatePrivateKeyParameter(((KeyAgreementSpi)object3).dheParameters.getEphemeralPrivateKey())));
                }
            } else if (object instanceof MQVParameterSpec) {
                if (((KeyAgreementSpi)((Object)bigInteger)).mqvAgreement == null) throw new InvalidAlgorithmParameterException("agreement algorithm not MQV based");
                ((KeyAgreementSpi)((Object)bigInteger)).p = key.getParams().getP();
                ((KeyAgreementSpi)((Object)bigInteger)).g = key.getParams().getG();
                object = (MQVParameterSpec)object;
                ((KeyAgreementSpi)((Object)bigInteger)).mqvParameters = object;
                ((BaseAgreementSpi)((Object)bigInteger)).ukmParameters = ((MQVParameterSpec)object).getUserKeyingMaterial();
                if (((KeyAgreementSpi)((Object)bigInteger)).mqvParameters.getEphemeralPublicKey() != null) {
                    Object object4 = bigInteger;
                    object = super.generatePrivateKeyParameter((PrivateKey)key);
                    object2 = super.generatePrivateKeyParameter(((KeyAgreementSpi)object4).mqvParameters.getEphemeralPrivateKey());
                    DHPublicKeyParameters dHPublicKeyParameters = super.generatePublicKeyParameter(((KeyAgreementSpi)object4).mqvParameters.getEphemeralPublicKey());
                    ((KeyAgreementSpi)((Object)bigInteger)).mqvAgreement.init(new DHMQVPrivateParameters((DHPrivateKeyParameters)object, (DHPrivateKeyParameters)object2, dHPublicKeyParameters));
                } else {
                    Object object5 = bigInteger;
                    object = super.generatePrivateKeyParameter((PrivateKey)key);
                    ((KeyAgreementSpi)((Object)bigInteger)).mqvAgreement.init(new DHMQVPrivateParameters((DHPrivateKeyParameters)object, super.generatePrivateKeyParameter(((KeyAgreementSpi)object5).mqvParameters.getEphemeralPrivateKey())));
                }
            } else {
                if (!(object instanceof UserKeyingMaterialSpec)) throw new InvalidAlgorithmParameterException("DHKeyAgreement only accepts DHParameterSpec");
                if (((BaseAgreementSpi)((Object)bigInteger)).kdf == null) throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
                Object object6 = bigInteger;
                ((KeyAgreementSpi)((Object)bigInteger)).p = key.getParams().getP();
                ((KeyAgreementSpi)object6).g = key.getParams().getG();
                ((KeyAgreementSpi)object6).dheParameters = null;
                ((BaseAgreementSpi)((Object)bigInteger)).ukmParameters = ((UserKeyingMaterialSpec)object).getUserKeyingMaterial();
            }
        } else {
            ((KeyAgreementSpi)((Object)bigInteger)).p = key.getParams().getP();
            ((KeyAgreementSpi)((Object)bigInteger)).g = key.getParams().getG();
        }
        KeyAgreementSpi keyAgreementSpi = bigInteger;
        BigInteger bigInteger = key.getX();
        keyAgreementSpi.x = bigInteger;
        keyAgreementSpi.result = keyAgreementSpi.bigIntToBytes(bigInteger);
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) {
        if (key instanceof DHPrivateKey) {
            KeyAgreementSpi keyAgreementSpi = bigInteger;
            key = (DHPrivateKey)key;
            ((KeyAgreementSpi)((Object)bigInteger)).p = key.getParams().getP();
            ((KeyAgreementSpi)((Object)bigInteger)).g = key.getParams().getG();
            BigInteger bigInteger = key.getX();
            keyAgreementSpi.x = bigInteger;
            keyAgreementSpi.result = keyAgreementSpi.bigIntToBytes(bigInteger);
            return;
        }
        throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey");
    }

    @Override
    public byte[] calcSecret() {
        return this.result;
    }

    public static class MQVwithSHA512CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA512CKDF mQVwithSHA512CKDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("MQVwithSHA512CKDF", mQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA384CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA384CKDF mQVwithSHA384CKDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("MQVwithSHA384CKDF", mQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA256CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA256CKDF mQVwithSHA256CKDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("MQVwithSHA256CKDF", mQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA224CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA224CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA224CKDF mQVwithSHA224CKDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA224());
            super("MQVwithSHA224CKDF", mQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA1CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA1CKDF mQVwithSHA1CKDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("MQVwithSHA1CKDF", mQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA512KDF
    extends KeyAgreementSpi {
        public MQVwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA512KDF mQVwithSHA512KDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("MQVwithSHA512KDF", mQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA384KDF
    extends KeyAgreementSpi {
        public MQVwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA384KDF mQVwithSHA384KDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("MQVwithSHA384KDF", mQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA256KDF
    extends KeyAgreementSpi {
        public MQVwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA256KDF mQVwithSHA256KDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("MQVwithSHA256KDF", mQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA224KDF
    extends KeyAgreementSpi {
        public MQVwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA224KDF mQVwithSHA224KDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("MQVwithSHA224KDF", mQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA1KDF
    extends KeyAgreementSpi {
        public MQVwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            MQVBasicAgreement mQVBasicAgreement;
            MQVwithSHA1KDF mQVwithSHA1KDF = mQVBasicAgreement2;
            MQVBasicAgreement mQVBasicAgreement2 = mQVBasicAgreement;
            mQVBasicAgreement = new MQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("MQVwithSHA1KDF", mQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA512CKDF dHUwithSHA512CKDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("DHUwithSHA512CKDF", dHUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA384CKDF dHUwithSHA384CKDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("DHUwithSHA384CKDF", dHUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA256CKDF dHUwithSHA256CKDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("DHUwithSHA256CKDF", dHUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA224CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA224CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA224CKDF dHUwithSHA224CKDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA224());
            super("DHUwithSHA224CKDF", dHUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA1CKDF dHUwithSHA1CKDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("DHUwithSHA1CKDF", dHUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA512KDF
    extends KeyAgreementSpi {
        public DHUwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA512KDF dHUwithSHA512KDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("DHUwithSHA512KDF", dHUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA384KDF
    extends KeyAgreementSpi {
        public DHUwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA384KDF dHUwithSHA384KDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("DHUwithSHA384KDF", dHUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA256KDF
    extends KeyAgreementSpi {
        public DHUwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA256KDF dHUwithSHA256KDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("DHUwithSHA256KDF", dHUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA224KDF
    extends KeyAgreementSpi {
        public DHUwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA224KDF dHUwithSHA224KDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("DHUwithSHA224KDF", dHUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA1KDF
    extends KeyAgreementSpi {
        public DHUwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHUnifiedAgreement dHUnifiedAgreement;
            DHUwithSHA1KDF dHUwithSHA1KDF = dHUnifiedAgreement2;
            DHUnifiedAgreement dHUnifiedAgreement2 = dHUnifiedAgreement;
            dHUnifiedAgreement = new DHUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("DHUwithSHA1KDF", dHUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHwithSHA512CKDF dHwithSHA512CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("DHwithSHA512CKDF", concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHwithSHA384CKDF dHwithSHA384CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("DHwithSHA384CKDF", concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHwithSHA256CKDF dHwithSHA256CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("DHwithSHA256CKDF", concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA224CKDF
    extends KeyAgreementSpi {
        public DHwithSHA224CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHwithSHA224CKDF dHwithSHA224CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA224());
            super("DHwithSHA224CKDF", concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            DHwithSHA1CKDF dHwithSHA1CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("DHwithSHA1CKDF", concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA512KDF
    extends KeyAgreementSpi {
        public DHwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHwithSHA512KDF dHwithSHA512KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("DHwithSHA512KDF", kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA384KDF
    extends KeyAgreementSpi {
        public DHwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHwithSHA384KDF dHwithSHA384KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("DHwithSHA384KDF", kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA256KDF
    extends KeyAgreementSpi {
        public DHwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHwithSHA256KDF dHwithSHA256KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("DHwithSHA256CKDF", kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA224KDF
    extends KeyAgreementSpi {
        public DHwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHwithSHA224KDF dHwithSHA224KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("DHwithSHA224CKDF", kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA1KDF
    extends KeyAgreementSpi {
        public DHwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            DHwithSHA1KDF dHwithSHA1KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("DHwithSHA1CKDF", kDF2BytesGenerator2);
        }
    }

    public static class DHwithRFC2631KDF
    extends KeyAgreementSpi {
        public DHwithRFC2631KDF() {
            DHKEKGenerator dHKEKGenerator;
            DHwithRFC2631KDF dHwithRFC2631KDF = dHKEKGenerator2;
            DHKEKGenerator dHKEKGenerator2 = dHKEKGenerator;
            dHKEKGenerator = new DHKEKGenerator(DigestFactory.createSHA1());
            super("DHwithRFC2631KDF", dHKEKGenerator2);
        }
    }
}

