/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DSAParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAlgorithmParameterGeneratorSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class AlgorithmParameterGeneratorSpi
extends BaseAlgorithmParameterGeneratorSpi {
    public SecureRandom random;
    public int strength = 2048;
    public DSAParameterGenerationParameters params;

    @Override
    public void engineInit(int n, SecureRandom secureRandom) {
        if (n >= 512 && n <= 3072) {
            if (n <= 1024 && n % 64 != 0) {
                throw new InvalidParameterException("strength must be a multiple of 64 below 1024 bits.");
            }
            if (n > 1024 && n % 1024 != 0) {
                throw new InvalidParameterException("strength must be a multiple of 1024 above 1024 bits.");
            }
            AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi = this;
            algorithmParameterGeneratorSpi.strength = n;
            algorithmParameterGeneratorSpi.random = secureRandom;
            return;
        }
        throw new InvalidParameterException("strength must be from 512 - 3072");
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for DSA parameter generation.");
    }

    @Override
    public AlgorithmParameters engineGenerateParameters() {
        Object object;
        Object object2;
        DSAParameterSpec dSAParameterSpec;
        DSAParameterSpec dSAParameterSpec2;
        AlgorithmParameters algorithmParameters;
        AlgorithmParameters algorithmParameters2;
        Object object3;
        if (((AlgorithmParameterGeneratorSpi)object4).strength <= 1024) {
            DSAParametersGenerator dSAParametersGenerator;
            object3 = dSAParametersGenerator;
            dSAParametersGenerator = new DSAParametersGenerator();
        } else {
            SHA256Digest sHA256Digest;
            DSAParametersGenerator dSAParametersGenerator;
            object3 = dSAParametersGenerator;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            dSAParametersGenerator = new DSAParametersGenerator(sHA256Digest2);
        }
        if (((AlgorithmParameterGeneratorSpi)object4).random == null) {
            ((AlgorithmParameterGeneratorSpi)object4).random = CryptoServicesRegistrar.getSecureRandom();
        }
        AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi = object4;
        int n = PrimeCertaintyCalculator.getDefaultCertainty(algorithmParameterGeneratorSpi.strength);
        int n2 = algorithmParameterGeneratorSpi.strength;
        if (n2 == 1024) {
            DSAParameterGenerationParameters dSAParameterGenerationParameters;
            DSAParameterGenerationParameters dSAParameterGenerationParameters2 = dSAParameterGenerationParameters;
            SecureRandom secureRandom = ((AlgorithmParameterGeneratorSpi)object4).random;
            dSAParameterGenerationParameters = new DSAParameterGenerationParameters(1024, 160, n, secureRandom);
            ((AlgorithmParameterGeneratorSpi)object4).params = dSAParameterGenerationParameters2;
            ((DSAParametersGenerator)object3).init(dSAParameterGenerationParameters2);
        } else if (n2 > 1024) {
            DSAParameterGenerationParameters dSAParameterGenerationParameters;
            DSAParameterGenerationParameters dSAParameterGenerationParameters3 = dSAParameterGenerationParameters;
            SecureRandom secureRandom = ((AlgorithmParameterGeneratorSpi)object4).random;
            dSAParameterGenerationParameters = new DSAParameterGenerationParameters(n2, 256, n, secureRandom);
            ((AlgorithmParameterGeneratorSpi)object4).params = dSAParameterGenerationParameters3;
            ((DSAParametersGenerator)object3).init(dSAParameterGenerationParameters3);
        } else {
            SecureRandom secureRandom = ((AlgorithmParameterGeneratorSpi)object4).random;
            ((DSAParametersGenerator)object3).init(n2, n, secureRandom);
        }
        AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi2 = object4;
        Object object4 = ((DSAParametersGenerator)object3).generateParameters();
        try {
            DSAParameterSpec dSAParameterSpec3;
            AlgorithmParameters algorithmParameters3 = algorithmParameterGeneratorSpi2.createParametersInstance("DSA");
            algorithmParameters2 = algorithmParameters3;
            algorithmParameters = algorithmParameters3;
            dSAParameterSpec2 = dSAParameterSpec3;
            dSAParameterSpec = dSAParameterSpec3;
            Object object5 = object4;
            object2 = object5;
            object = object5;
            object4 = ((DSAParameters)object5).getP();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        object3 = ((DSAParameters)object).getQ();
        BigInteger bigInteger = ((DSAParameters)object2).getG();
        dSAParameterSpec2((BigInteger)object4, (BigInteger)object3, bigInteger);
        algorithmParameters2.init(dSAParameterSpec);
        return algorithmParameters;
    }
}

