/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.StandardDSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSAExt signer;
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private SecureRandom random;

    public DSASigner(Digest digest, DSAExt dSAExt) {
        this.digest = digest;
        this.signer = dSAExt;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        DSASigner dSASigner = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
        dSASigner.digest.reset();
        dSASigner.signer.init(false, asymmetricKeyParameter);
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        object = DSAUtil.generatePrivateKeyParameter((PrivateKey)object);
        SecureRandom secureRandom = this.random;
        if (secureRandom != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
            object = parametersWithRandom2;
        }
        DSASigner dSASigner = this;
        dSASigner.digest.reset();
        dSASigner.signer.init(true, (CipherParameters)object);
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        DSASigner dSASigner = bigInteger;
        Object object = new byte[dSASigner.digest.getDigestSize()];
        dSASigner.digest.doFinal((byte[])object, 0);
        try {
            object = dSASigner.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
        DSAEncoding dSAEncoding = dSASigner.encoding;
        Object[] objectArray = object;
        Object[] objectArray2 = object;
        BigInteger bigInteger = ((DSASigner)((Object)bigInteger)).signer.getOrder();
        object = objectArray[0];
        byte by = objectArray2[1];
        return dSAEncoding.encode(bigInteger, (BigInteger)object, (BigInteger)by);
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        Object object;
        BigInteger[] bigIntegerArray = object;
        byte[] byArray2 = new byte[object.digest.getDigestSize()];
        bigIntegerArray.digest.doFinal(byArray2, 0);
        try {
            object = object.encoding.decode(object.signer.getOrder(), byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        object = object[0];
        return bigIntegerArray.signer.verifySignature(byArray2, (BigInteger)object, object[1]);
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            NullDigest nullDigest;
            noneDSA noneDSA2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(nullDigest2, dSASigner2);
        }
    }

    public static class detDSASha3_512
    extends DSASigner {
        public detDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_512())));
        }
    }

    public static class dsaSha3_512
    extends DSASigner {
        public dsaSha3_512() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsaSha3_512 dsaSha3_5122 = digest;
            Digest digest = DigestFactory.createSHA3_512();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSASha3_384
    extends DSASigner {
        public detDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_384())));
        }
    }

    public static class dsaSha3_384
    extends DSASigner {
        public dsaSha3_384() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsaSha3_384 dsaSha3_3842 = digest;
            Digest digest = DigestFactory.createSHA3_384();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSASha3_256
    extends DSASigner {
        public detDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_256())));
        }
    }

    public static class dsaSha3_256
    extends DSASigner {
        public dsaSha3_256() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsaSha3_256 dsaSha3_2562 = digest;
            Digest digest = DigestFactory.createSHA3_256();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSASha3_224
    extends DSASigner {
        public detDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_224())));
        }
    }

    public static class dsaSha3_224
    extends DSASigner {
        public dsaSha3_224() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsaSha3_224 dsaSha3_2242 = digest;
            Digest digest = DigestFactory.createSHA3_224();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSA512
    extends DSASigner {
        public detDSA512() {
            super(DigestFactory.createSHA512(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA512())));
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsa512 dsa5122 = digest;
            Digest digest = DigestFactory.createSHA512();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSA384
    extends DSASigner {
        public detDSA384() {
            super(DigestFactory.createSHA384(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA384())));
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsa384 dsa3842 = digest;
            Digest digest = DigestFactory.createSHA384();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSA256
    extends DSASigner {
        public detDSA256() {
            super(DigestFactory.createSHA256(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA256())));
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsa256 dsa2562 = digest;
            Digest digest = DigestFactory.createSHA256();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSA224
    extends DSASigner {
        public detDSA224() {
            super(DigestFactory.createSHA224(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA224())));
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            dsa224 dsa2242 = digest;
            Digest digest = DigestFactory.createSHA224();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }

    public static class detDSA
    extends DSASigner {
        public detDSA() {
            super(DigestFactory.createSHA1(), new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA1())));
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner;
            stdDSA stdDSA2 = digest;
            Digest digest = DigestFactory.createSHA1();
            com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner dSASigner2 = dSASigner;
            dSASigner = new com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSASigner();
            super(digest, dSASigner2);
        }
    }
}

