/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145ECBinary;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCDSTU4145PrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    public static final long serialVersionUID = 7245981689601667138L;
    private String algorithm;
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCDSTU4145PrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrier.algorithm = "DSTU4145";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCDSTU4145PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public BCDSTU4145PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams() != null ? EC5Util.convertSpec(EC5Util.convertCurve(eCPrivateKeySpec.getParams().getCurve(), eCPrivateKeySpec.getParams().getSeed()), eCPrivateKeySpec.getParams()) : null;
    }

    public BCDSTU4145PrivateKey(java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public BCDSTU4145PrivateKey(BCDSTU4145PrivateKey bCDSTU4145PrivateKey) {
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = bCDSTU4145PrivateKey.d;
        this.ecSpec = bCDSTU4145PrivateKey.ecSpec;
        this.withCompression = bCDSTU4145PrivateKey.withCompression;
        this.attrCarrier = bCDSTU4145PrivateKey.attrCarrier;
        this.publicKey = bCDSTU4145PrivateKey.publicKey;
    }

    public BCDSTU4145PrivateKey(String object, ECPrivateKeyParameters object2, BCDSTU4145PublicKey bCDSTU4145PublicKey, ECParameterSpec eCParameterSpec) {
        String string = object;
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        object = ((ECKeyParameters)object2).getParameters();
        this.algorithm = string;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.publicKey = this.getPublicKeyDetails(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String object, ECPrivateKeyParameters object2, BCDSTU4145PublicKey bCDSTU4145PublicKey, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        String string = object;
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        object = ((ECKeyParameters)object2).getParameters();
        this.algorithm = string;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        } else {
            Object object5 = object = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            object = EC5Util.convertPoint(eCParameterSpec2.getG());
            object2 = eCParameterSpec2.getN();
            int n = eCParameterSpec2.getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object5, (java.security.spec.ECPoint)object, (BigInteger)object2, n);
        }
        this.publicKey = this.getPublicKeyDetails(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        BCDSTU4145PrivateKey bCDSTU4145PrivateKey = this;
        this.algorithm = "DSTU4145";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string;
        bCDSTU4145PrivateKey.d = eCPrivateKeyParameters.getD();
        bCDSTU4145PrivateKey.ecSpec = null;
    }

    public BCDSTU4145PrivateKey(PrivateKeyInfo privateKeyInfo) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        BCDSTU4145PrivateKey bCDSTU4145PrivateKey = pKCS12BagAttributeCarrier;
        bCDSTU4145PrivateKey.algorithm = "DSTU4145";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        bCDSTU4145PrivateKey.attrCarrier = pKCS12BagAttributeCarrier;
        bCDSTU4145PrivateKey.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo aSN1Encodable) {
        Object object = X962Parameters.getInstance(((PrivateKeyInfo)aSN1Encodable).getPrivateKeyAlgorithm().getParameters());
        if (((X962Parameters)object).isNamedCurve()) {
            Object object2 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)(object = ASN1ObjectIdentifier.getInstance(((X962Parameters)object).getParameters())));
            if (object2 == null) {
                object2 = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)object);
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((ECDomainParameters)object2).getCurve(), ((ECDomainParameters)object2).getSeed());
                Object object3 = object2;
                object = ((ASN1ObjectIdentifier)object).getId();
                object2 = EC5Util.convertPoint(((ECDomainParameters)object3).getG());
                BigInteger bigInteger = ((ECDomainParameters)object3).getN();
                BigInteger bigInteger2 = ((ECDomainParameters)object3).getH();
                ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).ecSpec = new ECNamedCurveSpec((String)object, ellipticCurve, (java.security.spec.ECPoint)object2, bigInteger, bigInteger2);
            } else {
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getSeed());
                Object object4 = object2;
                object = ECUtil.getCurveName((ASN1ObjectIdentifier)object);
                object2 = EC5Util.convertPoint(((X9ECParameters)object4).getG());
                BigInteger bigInteger = ((X9ECParameters)object4).getN();
                BigInteger bigInteger3 = ((X9ECParameters)object4).getH();
                ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).ecSpec = new ECNamedCurveSpec((String)object, ellipticCurve, (java.security.spec.ECPoint)object2, bigInteger, bigInteger3);
            }
        } else if (((X962Parameters)object).isImplicitlyCA()) {
            ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).ecSpec = null;
        } else {
            Object object5 = ASN1Sequence.getInstance(((X962Parameters)object).getParameters());
            if (((ASN1Sequence)object5).getObjectAt(0) instanceof ASN1Integer) {
                object = X9ECParameters.getInstance(((X962Parameters)object).getParameters());
                Object object6 = object5 = EC5Util.convertCurve(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getSeed());
                Object object7 = object;
                object = EC5Util.convertPoint(((X9ECParameters)object7).getG());
                object5 = ((X9ECParameters)object7).getN();
                int n = ((X9ECParameters)object7).getH().intValue();
                ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).ecSpec = new ECParameterSpec((EllipticCurve)object6, (java.security.spec.ECPoint)object, (BigInteger)object5, n);
            } else {
                Object object8;
                object = DSTU4145Params.getInstance(object5);
                if (((DSTU4145Params)object).isNamedCurve()) {
                    ECNamedCurveParameterSpec eCNamedCurveParameterSpec;
                    object = ((DSTU4145Params)object).getNamedCurve();
                    object5 = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)object);
                    object8 = eCNamedCurveParameterSpec;
                    Object object9 = object5;
                    object = ((ASN1ObjectIdentifier)object).getId();
                    object5 = ((ECDomainParameters)object9).getCurve();
                    ECPoint eCPoint = ((ECDomainParameters)object9).getG();
                    BigInteger bigInteger = ((ECDomainParameters)object9).getN();
                    BigInteger bigInteger4 = ((ECDomainParameters)object9).getH();
                    byte[] byArray = ((ECDomainParameters)object9).getSeed();
                    eCNamedCurveParameterSpec = new ECNamedCurveParameterSpec((String)object, (ECCurve)object5, eCPoint, bigInteger, bigInteger4, byArray);
                } else {
                    com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec;
                    BigInteger bigInteger;
                    ECCurve.F2m f2m;
                    object = ((DSTU4145Params)object).getECBinary();
                    object5 = ((DSTU4145ECBinary)object).getB();
                    object8 = UAObjectIdentifiers.dstu4145le;
                    if (((PrivateKeyInfo)aSN1Encodable).getPrivateKeyAlgorithm().getAlgorithm().equals((ASN1Primitive)object8)) {
                        super.reverseBytes((byte[])object5);
                    }
                    Object object10 = object;
                    DSTU4145BinaryField dSTU4145BinaryField = ((DSTU4145ECBinary)object10).getField();
                    ECCurve.F2m f2m2 = f2m;
                    DSTU4145BinaryField dSTU4145BinaryField2 = dSTU4145BinaryField;
                    int n = dSTU4145BinaryField2.getM();
                    int n2 = dSTU4145BinaryField2.getK1();
                    int n3 = dSTU4145BinaryField2.getK2();
                    int n4 = dSTU4145BinaryField2.getK3();
                    BigInteger bigInteger5 = ((DSTU4145ECBinary)object).getA();
                    BigInteger bigInteger6 = bigInteger;
                    bigInteger = new BigInteger(1, (byte[])object5);
                    f2m = new ECCurve.F2m(n, n2, n3, n4, bigInteger5, bigInteger6);
                    object5 = ((DSTU4145ECBinary)object10).getG();
                    if (((PrivateKeyInfo)aSN1Encodable).getPrivateKeyAlgorithm().getAlgorithm().equals((ASN1Primitive)object8)) {
                        super.reverseBytes((byte[])object5);
                    }
                    object8 = eCParameterSpec;
                    Object object11 = object;
                    object = DSTU4145PointEncoder.decodePoint(f2m2, (byte[])object5);
                    object5 = ((DSTU4145ECBinary)object11).getN();
                    eCParameterSpec = new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec(f2m2, (ECPoint)object, (BigInteger)object5);
                }
                Object object12 = object = EC5Util.convertCurve(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object8).getCurve(), ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object8).getSeed());
                Object object13 = object8;
                object = EC5Util.convertPoint(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object13).getG());
                object5 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object13).getN();
                int n = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object13).getH().intValue();
                ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).ecSpec = new ECParameterSpec((EllipticCurve)object12, (java.security.spec.ECPoint)object, (BigInteger)object5, n);
            }
        }
        aSN1Encodable = ((PrivateKeyInfo)aSN1Encodable).parsePrivateKey();
        if (aSN1Encodable instanceof ASN1Integer) {
            ((BCDSTU4145PrivateKey)((Object)eCPrivateKey)).d = ASN1Integer.getInstance(aSN1Encodable).getValue();
        } else {
            BCDSTU4145PrivateKey bCDSTU4145PrivateKey = eCPrivateKey;
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey.getInstance(aSN1Encodable);
            bCDSTU4145PrivateKey.d = eCPrivateKey.getKey();
            bCDSTU4145PrivateKey.publicKey = eCPrivateKey.getPublicKey();
        }
    }

    private void reverseBytes(byte[] byArray) {
        for (int k = 0; k < byArray.length / 2; ++k) {
            byte[] byArray2 = byArray;
            byte by = byArray[k];
            byArray2[k] = byArray[byArray.length - 1 - k];
            byArray[byArray2.length - 1 - k] = by;
        }
    }

    private DERBitString getPublicKeyDetails(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCDSTU4145PublicKey.getEncoded())).getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])objectInputStream2.readObject())));
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getEncoded() {
        AlgorithmIdentifier algorithmIdentifier;
        PrivateKeyInfo privateKeyInfo;
        Object object;
        ASN1Object aSN1Object;
        Object object2;
        block16: {
            AlgorithmIdentifier algorithmIdentifier2;
            PrivateKeyInfo privateKeyInfo2;
            Object object3;
            BigInteger bigInteger;
            int n;
            Object object4 = ((BCDSTU4145PrivateKey)object).ecSpec;
            if (object4 instanceof ECNamedCurveSpec) {
                X962Parameters x962Parameters;
                if ((object4 = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)object4).getName())) == null) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    object4 = aSN1ObjectIdentifier;
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)((BCDSTU4145PrivateKey)object).ecSpec).getName());
                }
                object2 = x962Parameters;
                x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object4);
                BCDSTU4145PrivateKey bCDSTU4145PrivateKey = object;
                object4 = bCDSTU4145PrivateKey.ecSpec.getOrder();
                n = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, (BigInteger)object4, bCDSTU4145PrivateKey.getS());
            } else if (object4 == null) {
                X962Parameters x962Parameters;
                object2 = x962Parameters;
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
                n = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, null, ((BCDSTU4145PrivateKey)object).getS());
            } else {
                X962Parameters x962Parameters;
                X9ECPoint x9ECPoint;
                X9ECParameters x9ECParameters;
                object4 = EC5Util.convertCurve(((ECParameterSpec)object4).getCurve());
                Object object5 = x9ECParameters;
                Object object6 = object4;
                BCDSTU4145PrivateKey bCDSTU4145PrivateKey = object;
                aSN1Object = x9ECPoint;
                object4 = EC5Util.convertPoint((ECCurve)object4, ((BCDSTU4145PrivateKey)object).ecSpec.getGenerator());
                x9ECPoint = new X9ECPoint((ECPoint)object4, ((BCDSTU4145PrivateKey)object).withCompression);
                object4 = bCDSTU4145PrivateKey.ecSpec.getOrder();
                bigInteger = BigInteger.valueOf(bCDSTU4145PrivateKey.ecSpec.getCofactor());
                object3 = bCDSTU4145PrivateKey.ecSpec.getCurve().getSeed();
                x9ECParameters = new X9ECParameters((ECCurve)object6, (X9ECPoint)aSN1Object, (BigInteger)object4, bigInteger, (byte[])object3);
                object4 = x962Parameters;
                x962Parameters = new X962Parameters((X9ECParameters)object5);
                Object object7 = object;
                object5 = ((BCDSTU4145PrivateKey)object7).ecSpec.getOrder();
                int n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, (BigInteger)object5, ((BCDSTU4145PrivateKey)object7).getS());
                object2 = object4;
                n = n2;
            }
            if (((BCDSTU4145PrivateKey)object).publicKey != null) {
                com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey;
                aSN1Object = eCPrivateKey;
                BCDSTU4145PrivateKey bCDSTU4145PrivateKey = object;
                bigInteger = bCDSTU4145PrivateKey.getS();
                object3 = bCDSTU4145PrivateKey.publicKey;
                eCPrivateKey = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n, bigInteger, (DERBitString)object3, (ASN1Encodable)object2);
            } else {
                com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey;
                aSN1Object = eCPrivateKey;
                eCPrivateKey = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n, ((BCDSTU4145PrivateKey)object).getS(), (ASN1Encodable)object2);
            }
            try {
                if (!((BCDSTU4145PrivateKey)object).algorithm.equals("DSTU4145")) break block16;
            }
            catch (IOException iOException) {
                return null;
            }
            object = privateKeyInfo2;
            ASN1Object aSN1Object2 = aSN1Object;
            AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier2;
            X962Parameters x962Parameters = object2;
            object2 = UAObjectIdentifiers.dstu4145be;
            algorithmIdentifier2 = new AlgorithmIdentifier((ASN1ObjectIdentifier)object2, x962Parameters.toASN1Primitive());
            privateKeyInfo2 = new PrivateKeyInfo(algorithmIdentifier3, ((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey)aSN1Object2).toASN1Primitive());
            return ((ASN1Object)object).getEncoded("DER");
        }
        object = privateKeyInfo;
        ASN1Object aSN1Object3 = aSN1Object;
        AlgorithmIdentifier algorithmIdentifier4 = algorithmIdentifier;
        X962Parameters x962Parameters = object2;
        object2 = X9ObjectIdentifiers.id_ecPublicKey;
        algorithmIdentifier = new AlgorithmIdentifier((ASN1ObjectIdentifier)object2, x962Parameters.toASN1Primitive());
        privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier4, ((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey)aSN1Object3).toASN1Primitive());
        return ((ASN1Object)object).getEncoded("DER");
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((BCDSTU4145PrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = ((BCDSTU4145PrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PrivateKey)) {
            return false;
        }
        object = (BCDSTU4145PrivateKey)object;
        return this.getD().equals(((BCDSTU4145PrivateKey)object).getD()) && this.engineGetSpec().equals(((BCDSTU4145PrivateKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        BCDSTU4145PrivateKey bCDSTU4145PrivateKey = serializable;
        Serializable serializable = bCDSTU4145PrivateKey.d;
        return ECUtil.privateKeyToString(serializable.algorithm, (BigInteger)serializable, bCDSTU4145PrivateKey.engineGetSpec());
    }
}

