/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    public KeySpec engineGetKeySpec(Key object, Class clazz) {
        Object object2;
        if (clazz.isAssignableFrom(ECPublicKeySpec.class) && object instanceof ECPublicKey) {
            object2 = (ECPublicKey)object;
            if (object2.getParams() != null) {
                Object object3 = object2;
                object2 = object3.getW();
                return new ECPublicKeySpec((ECPoint)object2, object3.getParams());
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPublicKeySpec(object2.getW(), EC5Util.convertSpec(EC5Util.convertCurve(((ECParameterSpec)object).getCurve(), ((ECParameterSpec)object).getSeed()), (ECParameterSpec)object));
        }
        if (clazz.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && object instanceof ECPrivateKey) {
            object2 = (ECPrivateKey)object;
            if (object2.getParams() != null) {
                Object object4 = object2;
                object2 = object4.getS();
                return new java.security.spec.ECPrivateKeySpec((BigInteger)object2, object4.getParams());
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(object2.getS(), EC5Util.convertSpec(EC5Util.convertCurve(((ECParameterSpec)object).getCurve(), ((ECParameterSpec)object).getSeed()), (ECParameterSpec)object));
        }
        if (clazz.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec.class) && object instanceof ECPublicKey) {
            object2 = (ECPublicKey)object;
            if (object2.getParams() != null) {
                return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec(EC5Util.convertPoint(object2.getParams(), object2.getW()), EC5Util.convertSpec(object2.getParams()));
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec(EC5Util.convertPoint(object2.getParams(), object2.getW()), (ECParameterSpec)object);
        }
        if (clazz.isAssignableFrom(ECPrivateKeySpec.class) && object instanceof ECPrivateKey) {
            object2 = (ECPrivateKey)object;
            if (object2.getParams() != null) {
                return new ECPrivateKeySpec(object2.getS(), EC5Util.convertSpec(object2.getParams()));
            }
            object = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPrivateKeySpec(object2.getS(), (ECParameterSpec)object);
        }
        return super.engineGetKeySpec((Key)object, clazz);
    }

    @Override
    public Key engineTranslateKey(Key key) {
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof ECPrivateKeySpec) {
            return new BCDSTU4145PrivateKey((ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
            return new BCDSTU4145PrivateKey((java.security.spec.ECPrivateKeySpec)keySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec) {
            return new BCDSTU4145PublicKey((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec)keySpec, BouncyCastleProvider.CONFIGURATION);
        }
        if (keySpec instanceof ECPublicKeySpec) {
            return new BCDSTU4145PublicKey((ECPublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (!aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le) && !aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145be)) {
            throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognised"));
        }
        return new BCDSTU4145PrivateKey(privateKeyInfo);
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (!aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145le) && !aSN1ObjectIdentifier.equals(UAObjectIdentifiers.dstu4145be)) {
            throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognised"));
        }
        return new BCDSTU4145PublicKey(subjectPublicKeyInfo);
    }
}

