/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECDHCUnifiedAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDHUPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDHUPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MQVPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MQVPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHUParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.MQVParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.MQVPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.MQVPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import d.a;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private Object agreement;
    private MQVParameterSpec mqvParameters;
    private DHUParameterSpec dheParameters;
    private byte[] result;

    public KeyAgreementSpi(String string, BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.kaAlgorithm = string;
        this.agreement = basicAgreement;
    }

    public KeyAgreementSpi(String string, ECDHCUnifiedAgreement eCDHCUnifiedAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.kaAlgorithm = string;
        this.agreement = eCDHCUnifiedAgreement;
    }

    private void initFromKey(Key object, AlgorithmParameterSpec object2) {
        block15: {
            block12: {
                block13: {
                    block14: {
                        ECDHUPrivateParameters eCDHUPrivateParameters;
                        Object object3;
                        Object object4;
                        block11: {
                            MQVPrivateParameters mQVPrivateParameters;
                            ECPublicKeyParameters eCPublicKeyParameters;
                            ECPrivateKeyParameters eCPrivateKeyParameters;
                            object4 = ((KeyAgreementSpi)object3).agreement;
                            if (!(object4 instanceof ECMQVBasicAgreement)) break block11;
                            ((KeyAgreementSpi)object3).mqvParameters = null;
                            boolean bl = object instanceof MQVPrivateKey;
                            if (!bl && !(object2 instanceof MQVParameterSpec)) {
                                throw new InvalidAlgorithmParameterException(a.a(new StringBuilder().append(((KeyAgreementSpi)object3).kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(MQVParameterSpec.class), " for initialisation"));
                            }
                            if (bl) {
                                object = (MQVPrivateKey)object;
                                object2 = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(object.getStaticPrivateKey());
                                eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(object.getEphemeralPrivateKey());
                                eCPublicKeyParameters = null;
                                if (object.getEphemeralPublicKey() != null) {
                                    eCPublicKeyParameters = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(object.getEphemeralPublicKey());
                                }
                            } else {
                                object2 = (MQVParameterSpec)object2;
                                object = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object);
                                eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(((MQVParameterSpec)object2).getEphemeralPrivateKey());
                                eCPublicKeyParameters = null;
                                if (((MQVParameterSpec)object2).getEphemeralPublicKey() != null) {
                                    eCPublicKeyParameters = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(((MQVParameterSpec)object2).getEphemeralPublicKey());
                                }
                                ((KeyAgreementSpi)object3).mqvParameters = object2;
                                ((BaseAgreementSpi)object3).ukmParameters = ((MQVParameterSpec)object2).getUserKeyingMaterial();
                                object2 = object;
                            }
                            KeyAgreementSpi keyAgreementSpi = object3;
                            object3 = mQVPrivateParameters;
                            mQVPrivateParameters = new MQVPrivateParameters((ECPrivateKeyParameters)object2, eCPrivateKeyParameters, eCPublicKeyParameters);
                            keyAgreementSpi.parameters = ((ECKeyParameters)object2).getParameters();
                            ((ECMQVBasicAgreement)keyAgreementSpi.agreement).init((CipherParameters)object3);
                            break block12;
                        }
                        if (!(object2 instanceof DHUParameterSpec)) break block13;
                        if (!(object4 instanceof ECDHCUnifiedAgreement)) break block14;
                        object2 = (DHUParameterSpec)object2;
                        object = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object);
                        object4 = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(((DHUParameterSpec)object2).getEphemeralPrivateKey());
                        ECPublicKeyParameters eCPublicKeyParameters = null;
                        if (((DHUParameterSpec)object2).getEphemeralPublicKey() != null) {
                            eCPublicKeyParameters = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(((DHUParameterSpec)object2).getEphemeralPublicKey());
                        }
                        KeyAgreementSpi keyAgreementSpi = object3;
                        ((KeyAgreementSpi)object3).dheParameters = object2;
                        ((BaseAgreementSpi)object3).ukmParameters = ((DHUParameterSpec)object2).getUserKeyingMaterial();
                        object3 = eCDHUPrivateParameters;
                        eCDHUPrivateParameters = new ECDHUPrivateParameters((ECPrivateKeyParameters)object, (ECPrivateKeyParameters)object4, eCPublicKeyParameters);
                        keyAgreementSpi.parameters = ((ECKeyParameters)object).getParameters();
                        ((ECDHCUnifiedAgreement)keyAgreementSpi.agreement).init((CipherParameters)object3);
                        break block12;
                    }
                    throw new InvalidAlgorithmParameterException(((KeyAgreementSpi)object3).kaAlgorithm + " key agreement cannot be used with " + KeyAgreementSpi.getSimpleName(DHUParameterSpec.class));
                }
                if (!(object instanceof PrivateKey)) break block15;
                if (((BaseAgreementSpi)object3).kdf == null && object2 instanceof UserKeyingMaterialSpec) {
                    throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
                }
                object = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object);
                ((KeyAgreementSpi)object3).parameters = ((ECKeyParameters)object).getParameters();
                object2 = object2 instanceof UserKeyingMaterialSpec ? (Object)((UserKeyingMaterialSpec)object2).getUserKeyingMaterial() : null;
                ((BaseAgreementSpi)object3).ukmParameters = (byte[])object2;
                ((BasicAgreement)((KeyAgreementSpi)object3).agreement).init((CipherParameters)object);
            }
            return;
        }
        throw new InvalidKeyException(a.a(new StringBuilder().append(((KeyAgreementSpi)object3).kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPrivateKey.class), " for initialisation"));
    }

    private static String getSimpleName(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public byte[] bigIntToBytes(BigInteger bigInteger) {
        X9IntegerConverter x9IntegerConverter = converter;
        return x9IntegerConverter.integerToBytes(bigInteger, x9IntegerConverter.getByteLength(this.parameters.getCurve()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Key engineDoPhase(Key object, boolean bl) {
        if (this.parameters == null) throw new IllegalStateException(a.a(new StringBuilder(), this.kaAlgorithm, " not initialised."));
        if (!bl) throw new IllegalStateException(a.a(new StringBuilder(), this.kaAlgorithm, " can only be between two parties."));
        Object object2 = this.agreement;
        if (object2 instanceof ECMQVBasicAgreement) {
            if (!(object instanceof MQVPublicKey)) {
                MQVPublicParameters mQVPublicParameters;
                object = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter((PublicKey)object);
                object2 = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(this.mqvParameters.getOtherPartyEphemeralKey());
                MQVPublicParameters mQVPublicParameters2 = mQVPublicParameters;
                mQVPublicParameters = new MQVPublicParameters((ECPublicKeyParameters)object, (ECPublicKeyParameters)object2);
            } else {
                MQVPublicParameters mQVPublicParameters;
                MQVPublicKey mQVPublicKey = (MQVPublicKey)object;
                object = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mQVPublicKey.getStaticKey());
                object2 = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mQVPublicKey.getEphemeralKey());
                MQVPublicParameters mQVPublicParameters3 = mQVPublicParameters;
                mQVPublicParameters = new MQVPublicParameters((ECPublicKeyParameters)object, (ECPublicKeyParameters)object2);
            }
        } else if (object2 instanceof ECDHCUnifiedAgreement) {
            ECDHUPublicParameters eCDHUPublicParameters;
            object = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter((PublicKey)object);
            object2 = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(this.dheParameters.getOtherPartyEphemeralKey());
            ECDHUPublicParameters eCDHUPublicParameters2 = eCDHUPublicParameters;
            eCDHUPublicParameters = new ECDHUPublicParameters((ECPublicKeyParameters)object, (ECPublicKeyParameters)object2);
        } else {
            if (!(object instanceof PublicKey)) throw new InvalidKeyException(a.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPublicKey.class), " for doPhase"));
            AsymmetricKeyParameter asymmetricKeyParameter = ECUtils.generatePublicKeyParameter((PublicKey)object);
        }
        try {
            object = this.agreement;
        }
        catch (Exception exception) {
            throw new InvalidKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, b.a("calculation failed: "))){

                @Override
                public Throwable getCause() {
                    return exception;
                }
            };
        }
        {
            void var3_9;
            if (object instanceof BasicAgreement) {
                this.result = this.bigIntToBytes(((BasicAgreement)object).calculateAgreement((CipherParameters)var3_9));
                return null;
            }
            this.result = ((ECDHCUnifiedAgreement)object).calculateAgreement((CipherParameters)var3_9);
            return null;
        }
    }

    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (!(algorithmParameterSpec == null || algorithmParameterSpec instanceof MQVParameterSpec || algorithmParameterSpec instanceof UserKeyingMaterialSpec || algorithmParameterSpec instanceof DHUParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, algorithmParameterSpec);
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) {
        try {
            this.initFromKey(key, null);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public byte[] calcSecret() {
        return Arrays.clone(this.result);
    }

    public static class ECKAEGwithSHA512KDF
    extends KeyAgreementSpi {
        public ECKAEGwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithSHA512KDF eCKAEGwithSHA512KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECKAEGwithSHA512KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class ECKAEGwithSHA384KDF
    extends KeyAgreementSpi {
        public ECKAEGwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithSHA384KDF eCKAEGwithSHA384KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECKAEGwithSHA384KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class ECKAEGwithSHA256KDF
    extends KeyAgreementSpi {
        public ECKAEGwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithSHA256KDF eCKAEGwithSHA256KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECKAEGwithSHA256KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class ECKAEGwithSHA224KDF
    extends KeyAgreementSpi {
        public ECKAEGwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithSHA224KDF eCKAEGwithSHA224KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECKAEGwithSHA224KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class ECKAEGwithRIPEMD160KDF
    extends KeyAgreementSpi {
        public ECKAEGwithRIPEMD160KDF() {
            RIPEMD160Digest rIPEMD160Digest;
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithRIPEMD160KDF eCKAEGwithRIPEMD160KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
            rIPEMD160Digest = new RIPEMD160Digest();
            kDF2BytesGenerator = new KDF2BytesGenerator(rIPEMD160Digest2);
            super("ECKAEGwithRIPEMD160KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class ECKAEGwithSHA1KDF
    extends KeyAgreementSpi {
        public ECKAEGwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            ECKAEGwithSHA1KDF eCKAEGwithSHA1KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECKAEGwithSHA1KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA512KDF
    extends KeyAgreementSpi {
        public DHUwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA512KDF dHUwithSHA512KDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECCDHUwithSHA512KDF", eCDHCUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA384KDF
    extends KeyAgreementSpi {
        public DHUwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA384KDF dHUwithSHA384KDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECCDHUwithSHA384KDF", eCDHCUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA256KDF
    extends KeyAgreementSpi {
        public DHUwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA256KDF dHUwithSHA256KDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECCDHUwithSHA256KDF", eCDHCUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA224KDF
    extends KeyAgreementSpi {
        public DHUwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA224KDF dHUwithSHA224KDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECCDHUwithSHA224KDF", eCDHCUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA1KDF
    extends KeyAgreementSpi {
        public DHUwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA1KDF dHUwithSHA1KDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECCDHUwithSHA1KDF", eCDHCUnifiedAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA512CKDF dHUwithSHA512CKDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("ECCDHUwithSHA512CKDF", eCDHCUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA384CKDF dHUwithSHA384CKDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("ECCDHUwithSHA384CKDF", eCDHCUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA256CKDF dHUwithSHA256CKDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("ECCDHUwithSHA256CKDF", eCDHCUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA224CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA224CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA224CKDF dHUwithSHA224CKDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA224());
            super("ECCDHUwithSHA224CKDF", eCDHCUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHUwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUwithSHA1CKDF dHUwithSHA1CKDF = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("ECCDHUwithSHA1CKDF", eCDHCUnifiedAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA512KDF
    extends KeyAgreementSpi {
        public MQVwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA512KDF mQVwithSHA512KDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECMQVwithSHA512KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA384KDF
    extends KeyAgreementSpi {
        public MQVwithSHA384KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA384KDF mQVwithSHA384KDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECMQVwithSHA384KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA256KDF
    extends KeyAgreementSpi {
        public MQVwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA256KDF mQVwithSHA256KDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECMQVwithSHA256KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA224KDF
    extends KeyAgreementSpi {
        public MQVwithSHA224KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA224KDF mQVwithSHA224KDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECMQVwithSHA224KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA1KDF
    extends KeyAgreementSpi {
        public MQVwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA1KDF mQVwithSHA1KDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECMQVwithSHA1KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA512CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA512CKDF mQVwithSHA512CKDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("ECMQVwithSHA512CKDF", eCMQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA384CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA384CKDF mQVwithSHA384CKDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("ECMQVwithSHA384CKDF", eCMQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA256CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA256CKDF mQVwithSHA256CKDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("ECMQVwithSHA256CKDF", eCMQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA224CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA224CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA224CKDF mQVwithSHA224CKDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA224());
            super("ECMQVwithSHA224CKDF", eCMQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA1CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA1CKDF mQVwithSHA1CKDF = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("ECMQVwithSHA1CKDF", eCMQVBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            DHwithSHA512CKDF dHwithSHA512CKDF = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("ECDHwithSHA512CKDF", eCDHCBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHwithSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            DHwithSHA384CKDF dHwithSHA384CKDF = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("ECDHwithSHA384CKDF", eCDHCBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            DHwithSHA256CKDF dHwithSHA256CKDF = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("ECDHwithSHA256CKDF", eCDHCBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class DHwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHwithSHA1CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            DHwithSHA1CKDF dHwithSHA1CKDF = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA1());
            super("ECDHwithSHA1CKDF", eCDHCBasicAgreement2, (DerivationFunction)concatenationKDFGenerator2);
        }
    }

    public static class MQVwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA512KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA512KDFAndSharedInfo mQVwithSHA512KDFAndSharedInfo = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECMQVwithSHA512KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA384KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA384KDFAndSharedInfo mQVwithSHA384KDFAndSharedInfo = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECMQVwithSHA384KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA256KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA256KDFAndSharedInfo mQVwithSHA256KDFAndSharedInfo = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECMQVwithSHA256KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA224KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA224KDFAndSharedInfo mQVwithSHA224KDFAndSharedInfo = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECMQVwithSHA224KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class MQVwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA1KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQVwithSHA1KDFAndSharedInfo mQVwithSHA1KDFAndSharedInfo = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECMQVwithSHA1KDF", eCMQVBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class CDHwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA512KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            CDHwithSHA512KDFAndSharedInfo cDHwithSHA512KDFAndSharedInfo = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECCDHwithSHA512KDF", eCDHCBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA512KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA512KDFAndSharedInfo dHwithSHA512KDFAndSharedInfo = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("ECDHwithSHA512KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class CDHwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA384KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            CDHwithSHA384KDFAndSharedInfo cDHwithSHA384KDFAndSharedInfo = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECCDHwithSHA384KDF", eCDHCBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA384KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA384KDFAndSharedInfo dHwithSHA384KDFAndSharedInfo = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA384());
            super("ECDHwithSHA384KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class CDHwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA256KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            CDHwithSHA256KDFAndSharedInfo cDHwithSHA256KDFAndSharedInfo = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECCDHwithSHA256KDF", eCDHCBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA256KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA256KDFAndSharedInfo dHwithSHA256KDFAndSharedInfo = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("ECDHwithSHA256KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class CDHwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA224KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            CDHwithSHA224KDFAndSharedInfo cDHwithSHA224KDFAndSharedInfo = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECCDHwithSHA224KDF", eCDHCBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA224KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA224KDFAndSharedInfo dHwithSHA224KDFAndSharedInfo = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA224());
            super("ECDHwithSHA224KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class CDHwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA1KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHCBasicAgreement eCDHCBasicAgreement;
            CDHwithSHA1KDFAndSharedInfo cDHwithSHA1KDFAndSharedInfo = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECCDHwithSHA1KDF", eCDHCBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA1KDFAndSharedInfo() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA1KDFAndSharedInfo dHwithSHA1KDFAndSharedInfo = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECDHwithSHA1KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHwithSHA1KDF
    extends KeyAgreementSpi {
        public DHwithSHA1KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            ECDHBasicAgreement eCDHBasicAgreement;
            DHwithSHA1KDF dHwithSHA1KDF = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            super("ECDHwithSHA1KDF", eCDHBasicAgreement2, (DerivationFunction)kDF2BytesGenerator2);
        }
    }

    public static class DHUC
    extends KeyAgreementSpi {
        public DHUC() {
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement;
            DHUC dHUC = eCDHCUnifiedAgreement2;
            ECDHCUnifiedAgreement eCDHCUnifiedAgreement2 = eCDHCUnifiedAgreement;
            eCDHCUnifiedAgreement = new ECDHCUnifiedAgreement();
            super("ECCDHU", eCDHCUnifiedAgreement2, null);
        }
    }

    public static class MQV
    extends KeyAgreementSpi {
        public MQV() {
            ECMQVBasicAgreement eCMQVBasicAgreement;
            MQV mQV = eCMQVBasicAgreement2;
            ECMQVBasicAgreement eCMQVBasicAgreement2 = eCMQVBasicAgreement;
            eCMQVBasicAgreement = new ECMQVBasicAgreement();
            super("ECMQV", eCMQVBasicAgreement2, null);
        }
    }

    public static class DHC
    extends KeyAgreementSpi {
        public DHC() {
            ECDHCBasicAgreement eCDHCBasicAgreement;
            DHC dHC = eCDHCBasicAgreement2;
            ECDHCBasicAgreement eCDHCBasicAgreement2 = eCDHCBasicAgreement;
            eCDHCBasicAgreement = new ECDHCBasicAgreement();
            super("ECDHC", eCDHCBasicAgreement2, null);
        }
    }

    public static class DH
    extends KeyAgreementSpi {
        public DH() {
            ECDHBasicAgreement eCDHBasicAgreement;
            DH dH = eCDHBasicAgreement2;
            ECDHBasicAgreement eCDHBasicAgreement2 = eCDHBasicAgreement;
            eCDHBasicAgreement = new ECDHBasicAgreement();
            super("ECDH", eCDHBasicAgreement2, null);
        }
    }
}

