/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCEdDSAPrivateKey
implements EdDSAPrivateKey {
    public static final long serialVersionUID = 1L;
    public transient AsymmetricKeyParameter eddsaPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    public BCEdDSAPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.eddsaPrivateKey = asymmetricKeyParameter;
    }

    public BCEdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) {
        this.hasPublicKey = privateKeyInfo.hasPublicKey();
        byte[] byArray = privateKeyInfo.getAttributes() != null ? privateKeyInfo.getAttributes().getEncoded() : null;
        this.attributes = byArray;
        this.populateFromPrivateKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        this.eddsaPrivateKey = EdECObjectIdentifiers.id_Ed448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new Ed448PrivateKeyParameters(ASN1OctetString.getInstance(aSN1Encodable).getOctets(), 0) : new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(aSN1Encodable).getOctets(), 0);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters ? "Ed448" : "Ed25519";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getEncoded() {
        try {
            BCEdDSAPrivateKey bCEdDSAPrivateKey = aSN1Set;
            ASN1Set aSN1Set = ASN1Set.getInstance(bCEdDSAPrivateKey.attributes);
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(bCEdDSAPrivateKey.eddsaPrivateKey, aSN1Set);
            if (bCEdDSAPrivateKey.hasPublicKey && !Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.pkcs8.v1_info_only")) {
                return privateKeyInfo.getEncoded();
            }
            PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
            AlgorithmIdentifier algorithmIdentifier = privateKeyInfo2.getPrivateKeyAlgorithm();
            return new PrivateKeyInfo(algorithmIdentifier, privateKeyInfo2.parsePrivateKey(), aSN1Set).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        AsymmetricKeyParameter asymmetricKeyParameter = ((BCEdDSAPrivateKey)((Object)asymmetricKeyParameter)).eddsaPrivateKey;
        if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            return new BCEdDSAPublicKey(((Ed448PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey());
        }
        return new BCEdDSAPublicKey(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey());
    }

    public AsymmetricKeyParameter engineGetKeyParameters() {
        return this.eddsaPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter asymmetricKeyParameter = this.eddsaPrivateKey;
        asymmetricKeyParameter = asymmetricKeyParameter instanceof Ed448PrivateKeyParameters ? ((Ed448PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey() : ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), asymmetricKeyParameter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return Arrays.areEqual(((PrivateKey)object).getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }
}

