/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

public class BCEdDSAPublicKey
implements EdDSAPublicKey {
    public static final long serialVersionUID = 1L;
    public transient AsymmetricKeyParameter eddsaPublicKey;

    public BCEdDSAPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.eddsaPublicKey = asymmetricKeyParameter;
    }

    public BCEdDSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCEdDSAPublicKey bCEdDSAPublicKey = this;
        bCEdDSAPublicKey.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    public BCEdDSAPublicKey(byte[] byArray, byte[] byArray2) {
        block2: {
            block5: {
                block4: {
                    Ed25519PublicKeyParameters ed25519PublicKeyParameters;
                    Object object;
                    int n;
                    block3: {
                        Ed448PublicKeyParameters ed448PublicKeyParameters;
                        n = byArray.length;
                        if (!Utils.isValidPrefix(byArray, byArray2)) break block2;
                        if (byArray2.length - n != 57) break block3;
                        BCEdDSAPublicKey bCEdDSAPublicKey = object;
                        object = ed448PublicKeyParameters;
                        ed448PublicKeyParameters = new Ed448PublicKeyParameters(byArray2, n);
                        bCEdDSAPublicKey.eddsaPublicKey = object;
                        break block4;
                    }
                    if (byArray2.length - n != 32) break block5;
                    Object object2 = object;
                    object = ed25519PublicKeyParameters;
                    ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(byArray2, n);
                    ((BCEdDSAPublicKey)object2).eddsaPublicKey = object;
                }
                return;
            }
            throw new InvalidKeySpecException("raw key data not recognised");
        }
        throw new InvalidKeySpecException("raw key data not recognised");
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.eddsaPublicKey = EdECObjectIdentifiers.id_Ed448.equals(subjectPublicKeyInfo.getAlgorithm().getAlgorithm()) ? new Ed448PublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets(), 0) : new Ed25519PublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets(), 0);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.eddsaPublicKey instanceof Ed448PublicKeyParameters ? "Ed448" : "Ed25519";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.eddsaPublicKey instanceof Ed448PublicKeyParameters) {
            byte[] byArray = KeyFactorySpi.Ed448Prefix;
            byte[] byArray2 = new byte[KeyFactorySpi.Ed448Prefix.length + 57];
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            ((Ed448PublicKeyParameters)this.eddsaPublicKey).encode(byArray2, byArray.length);
            return byArray2;
        }
        byte[] byArray = KeyFactorySpi.Ed25519Prefix;
        byte[] byArray3 = new byte[KeyFactorySpi.Ed25519Prefix.length + 32];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        ((Ed25519PublicKeyParameters)this.eddsaPublicKey).encode(byArray3, byArray.length);
        return byArray3;
    }

    public AsymmetricKeyParameter engineGetKeyParameters() {
        return this.eddsaPublicKey;
    }

    public String toString() {
        BCEdDSAPublicKey bCEdDSAPublicKey = string;
        String string = bCEdDSAPublicKey.getAlgorithm();
        AsymmetricKeyParameter asymmetricKeyParameter = bCEdDSAPublicKey.eddsaPublicKey;
        return Utils.keyToString("Public Key", string, asymmetricKeyParameter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return Arrays.areEqual(((PublicKey)object).getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }
}

