/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost.GOSTUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.GOST3410Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public class BCGOST3410PublicKey
implements GOST3410PublicKey {
    public static final long serialVersionUID = -6251023343619275990L;
    private BigInteger y;
    private transient GOST3410Params gost3410Spec;

    public BCGOST3410PublicKey(GOST3410PublicKeySpec object) {
        BCGOST3410PublicKey bCGOST3410PublicKey = serializable;
        bCGOST3410PublicKey.y = ((GOST3410PublicKeySpec)object).getY();
        GOST3410PublicKeySpec gOST3410PublicKeySpec = object;
        Serializable serializable = gOST3410PublicKeySpec.getP();
        object = gOST3410PublicKeySpec.getQ();
        BigInteger bigInteger = gOST3410PublicKeySpec.getA();
        bCGOST3410PublicKey.gost3410Spec = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec((BigInteger)serializable, (BigInteger)object, bigInteger));
    }

    public BCGOST3410PublicKey(GOST3410PublicKey gOST3410PublicKey) {
        this.y = gOST3410PublicKey.getY();
        this.gost3410Spec = gOST3410PublicKey.getParameters();
    }

    public BCGOST3410PublicKey(GOST3410PublicKeyParameters gOST3410PublicKeyParameters, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.y = gOST3410PublicKeyParameters.getY();
        this.gost3410Spec = gOST3410ParameterSpec;
    }

    public BCGOST3410PublicKey(BigInteger bigInteger, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.y = bigInteger;
        this.gost3410Spec = gOST3410ParameterSpec;
    }

    public BCGOST3410PublicKey(SubjectPublicKeyInfo aSN1Object) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
        aSN1Object = GOST3410PublicKeyAlgParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        byte[] byArray = ((DEROctetString)subjectPublicKeyInfo.parsePublicKey()).getOctets();
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (true) {
            if (n == byArray.length) break;
            byte[] byArray3 = byArray2;
            int n2 = n;
            byte[] byArray4 = byArray;
            int n3 = byArray.length;
            byArray3[n2] = byArray4[n3 - 1 - n];
            ++n;
            continue;
            break;
        }
        try {
            this.y = new BigInteger(1, byArray2);
            this.gost3410Spec = GOST3410ParameterSpec.fromPublicKeyAlg((GOST3410PublicKeyAlgParameters)aSN1Object);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in GOST3410 public key");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        Object object;
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        String string = (String)objectInputStream2.readObject();
        if (string != null) {
            BCGOST3410PublicKey bCGOST3410PublicKey = object;
            ObjectInputStream objectInputStream3 = objectInputStream;
            object = (String)objectInputStream3.readObject();
            bCGOST3410PublicKey.gost3410Spec = new GOST3410ParameterSpec(string, (String)object, (String)objectInputStream3.readObject());
        } else {
            ObjectInputStream objectInputStream4 = objectInputStream;
            BCGOST3410PublicKey bCGOST3410PublicKey = object;
            ObjectInputStream objectInputStream5 = objectInputStream;
            object = (BigInteger)objectInputStream5.readObject();
            bCGOST3410PublicKey.gost3410Spec = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec((BigInteger)objectInputStream.readObject(), (BigInteger)object, (BigInteger)objectInputStream5.readObject()));
            objectInputStream4.readObject();
            objectInputStream4.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        if (this.gost3410Spec.getPublicKeyParamSetOID() != null) {
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getDigestParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getEncryptionParamSetOID());
        } else {
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getP());
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getQ());
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getA());
            objectOutputStream.writeObject(this.gost3410Spec.getDigestParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getEncryptionParamSetOID());
        }
    }

    @Override
    public String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getEncoded() {
        DEROctetString dEROctetString;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        void var1_6;
        byte[] byArray;
        block11: {
            SubjectPublicKeyInfo subjectPublicKeyInfo2;
            block12: {
                ASN1ObjectIdentifier aSN1ObjectIdentifier;
                GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters;
                AlgorithmIdentifier algorithmIdentifier;
                SubjectPublicKeyInfo subjectPublicKeyInfo3;
                GOST3410Params gOST3410Params;
                byte[] byArray2 = ((BCGOST3410PublicKey)((Object)dEROctetString2)).getY().toByteArray();
                byArray = byArray2[0] == 0 ? new byte[byArray2.length - 1] : new byte[byArray2.length];
                for (int k = 0; k != byArray.length; ++k) {
                    byArray[k] = byArray2[byArray2.length - 1 - k];
                }
                try {
                    gOST3410Params = ((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec;
                }
                catch (IOException iOException) {
                    return null;
                }
                if (!(gOST3410Params instanceof GOST3410ParameterSpec)) break block11;
                if (gOST3410Params.getEncryptionParamSetOID() == null) break block12;
                SubjectPublicKeyInfo subjectPublicKeyInfo4 = subjectPublicKeyInfo3;
                AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
                AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = CryptoProObjectIdentifiers.gostR3410_94;
                GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters2 = gOST3410PublicKeyAlgParameters;
                GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters3 = gOST3410PublicKeyAlgParameters;
                ASN1ObjectIdentifier aSN1ObjectIdentifier3 = new ASN1ObjectIdentifier(((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec.getPublicKeyParamSetOID());
                ASN1ObjectIdentifier aSN1ObjectIdentifier4 = new ASN1ObjectIdentifier(((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec.getDigestParamSetOID());
                ASN1ObjectIdentifier aSN1ObjectIdentifier5 = aSN1ObjectIdentifier;
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec.getEncryptionParamSetOID());
                gOST3410PublicKeyAlgParameters2(aSN1ObjectIdentifier3, aSN1ObjectIdentifier4, aSN1ObjectIdentifier5);
                algorithmIdentifier2(aSN1ObjectIdentifier2, gOST3410PublicKeyAlgParameters3);
                subjectPublicKeyInfo3 = new SubjectPublicKeyInfo(algorithmIdentifier3, new DEROctetString(byArray));
                return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)var1_6);
            }
            SubjectPublicKeyInfo subjectPublicKeyInfo5 = subjectPublicKeyInfo2;
            subjectPublicKeyInfo2 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new ASN1ObjectIdentifier(((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec.getPublicKeyParamSetOID()), new ASN1ObjectIdentifier(((BCGOST3410PublicKey)((Object)dEROctetString2)).gost3410Spec.getDigestParamSetOID()))), new DEROctetString(byArray));
            return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)var1_6);
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo6 = subjectPublicKeyInfo;
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94);
        DEROctetString dEROctetString2 = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, dEROctetString2);
        return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)var1_6);
    }

    @Override
    public GOST3410Params getParameters() {
        return this.gost3410Spec;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        try {
            return GOSTUtil.publicKeyToString("GOST3410", this.y, ((GOST3410PublicKeyParameters)GOST3410Util.generatePublicKeyParameter(this)).getParameters());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BCGOST3410PublicKey) {
            object = (BCGOST3410PublicKey)object;
            return this.y.equals(((BCGOST3410PublicKey)object).y) && this.gost3410Spec.equals(((BCGOST3410PublicKey)object).gost3410Spec);
        }
        return false;
    }

    public int hashCode() {
        return this.y.hashCode() ^ this.gost3410Spec.hashCode();
    }
}

