/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.RSAPublicKeySpec;

public class BCRSAPublicKey
implements java.security.interfaces.RSAPublicKey {
    public static final AlgorithmIdentifier DEFAULT_ALGORITHM_IDENTIFIER = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    public static final long serialVersionUID = 2675817738516720772L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private transient AlgorithmIdentifier algorithmIdentifier;
    private transient RSAKeyParameters rsaPublicKey;

    public BCRSAPublicKey(RSAKeyParameters rSAKeyParameters) {
        this(DEFAULT_ALGORITHM_IDENTIFIER, rSAKeyParameters);
    }

    public BCRSAPublicKey(AlgorithmIdentifier algorithmIdentifier, RSAKeyParameters rSAKeyParameters) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.modulus = rSAKeyParameters.getModulus();
        this.publicExponent = rSAKeyParameters.getExponent();
        this.rsaPublicKey = rSAKeyParameters;
    }

    public BCRSAPublicKey(RSAPublicKeySpec object) {
        BCRSAPublicKey bCRSAPublicKey = serializable;
        serializable.algorithmIdentifier = DEFAULT_ALGORITHM_IDENTIFIER;
        serializable.modulus = ((RSAPublicKeySpec)object).getModulus();
        bCRSAPublicKey.publicExponent = ((RSAPublicKeySpec)object).getPublicExponent();
        BCRSAPublicKey bCRSAPublicKey2 = serializable;
        Serializable serializable = bCRSAPublicKey2.modulus;
        object = bCRSAPublicKey2.publicExponent;
        bCRSAPublicKey.rsaPublicKey = new RSAKeyParameters(false, (BigInteger)serializable, (BigInteger)object);
    }

    public BCRSAPublicKey(java.security.interfaces.RSAPublicKey serializable) {
        BCRSAPublicKey bCRSAPublicKey = serializable2;
        serializable2.algorithmIdentifier = DEFAULT_ALGORITHM_IDENTIFIER;
        serializable2.modulus = serializable.getModulus();
        bCRSAPublicKey.publicExponent = serializable.getPublicExponent();
        BCRSAPublicKey bCRSAPublicKey2 = serializable2;
        Serializable serializable2 = bCRSAPublicKey2.modulus;
        serializable = bCRSAPublicKey2.publicExponent;
        bCRSAPublicKey.rsaPublicKey = new RSAKeyParameters(false, (BigInteger)serializable2, (BigInteger)serializable);
    }

    public BCRSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCRSAPublicKey bCRSAPublicKey = this;
        bCRSAPublicKey.populateFromPublicKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPublicKeyInfo(SubjectPublicKeyInfo object) {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        try {
            BCRSAPublicKey bCRSAPublicKey = this;
            BCRSAPublicKey bCRSAPublicKey2 = bCRSAPublicKey;
            BCRSAPublicKey bCRSAPublicKey3 = bCRSAPublicKey;
            BCRSAPublicKey bCRSAPublicKey4 = bCRSAPublicKey;
            BCRSAPublicKey bCRSAPublicKey5 = bCRSAPublicKey;
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = object;
            subjectPublicKeyInfo = subjectPublicKeyInfo2;
            object = RSAPublicKey.getInstance(subjectPublicKeyInfo2.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in RSA public key");
        }
        bCRSAPublicKey2.algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
        bCRSAPublicKey3.modulus = ((RSAPublicKey)object).getModulus();
        bCRSAPublicKey4.publicExponent = ((RSAPublicKey)object).getPublicExponent();
        BCRSAPublicKey bCRSAPublicKey = this;
        boolean bl = false;
        object = bCRSAPublicKey.modulus;
        BigInteger bigInteger = bCRSAPublicKey.publicExponent;
        bCRSAPublicKey5.rsaPublicKey = new RSAKeyParameters(bl, (BigInteger)object, bigInteger);
    }

    private void readObject(ObjectInputStream object) {
        RSAKeyParameters rSAKeyParameters;
        ObjectInputStream objectInputStream = object;
        objectInputStream.defaultReadObject();
        try {
            serializable.algorithmIdentifier = AlgorithmIdentifier.getInstance(objectInputStream.readObject());
        }
        catch (Exception exception) {
            serializable.algorithmIdentifier = DEFAULT_ALGORITHM_IDENTIFIER;
        }
        BCRSAPublicKey bCRSAPublicKey = serializable;
        object = rSAKeyParameters;
        BCRSAPublicKey bCRSAPublicKey2 = serializable;
        Serializable serializable = bCRSAPublicKey2.modulus;
        BigInteger bigInteger = bCRSAPublicKey2.publicExponent;
        rSAKeyParameters = new RSAKeyParameters(false, (BigInteger)serializable, bigInteger);
        bCRSAPublicKey.rsaPublicKey = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        if (!this.algorithmIdentifier.equals(DEFAULT_ALGORITHM_IDENTIFIER)) {
            objectOutputStream.writeObject(this.algorithmIdentifier.getEncoded());
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            return "RSASSA-PSS";
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        BCRSAPublicKey bCRSAPublicKey = serializable;
        Serializable serializable = bCRSAPublicKey.getModulus();
        return KeyUtil.getEncodedSubjectPublicKeyInfo(serializable.algorithmIdentifier, new RSAPublicKey((BigInteger)serializable, bCRSAPublicKey.getPublicExponent()));
    }

    public RSAKeyParameters engineGetKeyParameters() {
        return this.rsaPublicKey;
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPublicExponent().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof java.security.interfaces.RSAPublicKey)) {
            return false;
        }
        object = (java.security.interfaces.RSAPublicKey)object;
        return this.getModulus().equals(object.getModulus()) && this.getPublicExponent().equals(object.getPublicExponent());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("RSA Public Key [").append(RSAUtil.generateKeyFingerprint(this.getModulus())).append("]").append(",[").append(RSAUtil.generateExponentFingerprint(this.getPublicExponent())).append("]").append(string);
        stringBuffer.append("        modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuffer.append("public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        return stringBuffer.toString();
    }
}

