/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Fingerprint;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAUtil {
    public static final ASN1ObjectIdentifier[] rsaOids = new ASN1ObjectIdentifier[]{PKCSObjectIdentifiers.rsaEncryption, X509ObjectIdentifiers.id_ea_rsa, PKCSObjectIdentifiers.id_RSAES_OAEP, PKCSObjectIdentifiers.id_RSASSA_PSS};

    public static boolean isRsaOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n = 0;
        while (true) {
            ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = rsaOids;
            if (n == rsaOids.length) break;
            if (aSN1ObjectIdentifier.equals(aSN1ObjectIdentifierArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey serializable) {
        if (serializable instanceof BCRSAPublicKey) {
            return ((BCRSAPublicKey)serializable).engineGetKeyParameters();
        }
        RSAPublicKey rSAPublicKey = serializable;
        serializable = rSAPublicKey.getModulus();
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        return new RSAKeyParameters(false, (BigInteger)serializable, bigInteger);
    }

    public static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey serializable) {
        if (serializable instanceof BCRSAPrivateKey) {
            return ((BCRSAPrivateKey)serializable).engineGetKeyParameters();
        }
        if (serializable instanceof RSAPrivateCrtKey) {
            RSAPrivateKey rSAPrivateKey = serializable = (RSAPrivateCrtKey)serializable;
            serializable = rSAPrivateKey.getModulus();
            BigInteger bigInteger = rSAPrivateKey.getPublicExponent();
            BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
            BigInteger bigInteger3 = rSAPrivateKey.getPrimeP();
            BigInteger bigInteger4 = rSAPrivateKey.getPrimeQ();
            BigInteger bigInteger5 = rSAPrivateKey.getPrimeExponentP();
            BigInteger bigInteger6 = rSAPrivateKey.getPrimeExponentQ();
            BigInteger bigInteger7 = rSAPrivateKey.getCrtCoefficient();
            return new RSAPrivateCrtKeyParameters((BigInteger)serializable, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
        }
        RSAPrivateKey rSAPrivateKey = serializable;
        serializable = rSAPrivateKey.getModulus();
        BigInteger bigInteger = rSAPrivateKey.getPrivateExponent();
        return new RSAKeyParameters(true, (BigInteger)serializable, bigInteger);
    }

    public static String generateKeyFingerprint(BigInteger bigInteger) {
        return new Fingerprint(bigInteger.toByteArray()).toString();
    }

    public static String generateExponentFingerprint(BigInteger bigInteger) {
        return new Fingerprint(bigInteger.toByteArray(), 32).toString();
    }
}

