/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Fingerprint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;

public class ECUtil {
    public static int[] convertMidTerms(int[] nArray) {
        block15: {
            int[] nArray2;
            block14: {
                int n;
                block13: {
                    nArray2 = new int[3];
                    if (nArray.length != 1) break block13;
                    nArray2[0] = nArray[0];
                    break block14;
                }
                if (nArray.length != 3) break block15;
                int n2 = nArray[0];
                int n3 = nArray[1];
                if (n2 < n3 && n2 < (n = nArray[2])) {
                    nArray2[0] = n2;
                    if (n3 < n) {
                        nArray2[1] = n3;
                        nArray2[2] = n;
                    } else {
                        nArray2[1] = n;
                        nArray2[2] = nArray[1];
                    }
                } else {
                    n2 = nArray[2];
                    if (n3 < n2) {
                        nArray2[0] = n3;
                        int n4 = nArray[0];
                        if (n4 < n2) {
                            nArray2[1] = n4;
                            nArray2[2] = n2;
                        } else {
                            nArray2[1] = n2;
                            nArray2[2] = n4;
                        }
                    } else {
                        nArray2[0] = n2;
                        n2 = nArray[0];
                        if (n2 < n3) {
                            nArray2[1] = n2;
                            nArray2[2] = nArray[1];
                        } else {
                            nArray2[1] = n3;
                            nArray2[2] = n2;
                        }
                    }
                }
            }
            return nArray2;
        }
        throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration object, ECParameterSpec object2) {
        ECDomainParameters eCDomainParameters;
        if (object2 instanceof ECNamedCurveParameterSpec) {
            ECNamedDomainParameters eCNamedDomainParameters;
            object = (ECNamedCurveParameterSpec)object2;
            object2 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)object).getName());
            eCDomainParameters = eCNamedDomainParameters;
            Object object3 = object2;
            Object object4 = object;
            object = ((ECParameterSpec)object4).getCurve();
            object2 = ((ECParameterSpec)object4).getG();
            BigInteger bigInteger = ((ECParameterSpec)object4).getN();
            BigInteger bigInteger2 = ((ECParameterSpec)object4).getH();
            byte[] byArray = ((ECParameterSpec)object4).getSeed();
            eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object3, (ECCurve)object, (ECPoint)object2, bigInteger, bigInteger2, byArray);
        } else if (object2 == null) {
            ECDomainParameters eCDomainParameters2;
            object = object.getEcImplicitlyCa();
            eCDomainParameters = eCDomainParameters2;
            Object object5 = object;
            object = ((ECParameterSpec)object5).getCurve();
            object2 = ((ECParameterSpec)object5).getG();
            BigInteger bigInteger = ((ECParameterSpec)object5).getN();
            BigInteger bigInteger3 = ((ECParameterSpec)object5).getH();
            byte[] byArray = ((ECParameterSpec)object5).getSeed();
            eCDomainParameters2 = new ECDomainParameters((ECCurve)object, (ECPoint)object2, bigInteger, bigInteger3, byArray);
        } else {
            ECDomainParameters eCDomainParameters3;
            eCDomainParameters = eCDomainParameters3;
            ECParameterSpec eCParameterSpec = object2;
            object = eCParameterSpec.getCurve();
            object2 = eCParameterSpec.getG();
            BigInteger bigInteger = eCParameterSpec.getN();
            BigInteger bigInteger4 = eCParameterSpec.getH();
            byte[] byArray = eCParameterSpec.getSeed();
            eCDomainParameters3 = new ECDomainParameters((ECCurve)object, (ECPoint)object2, bigInteger, bigInteger4, byArray);
        }
        return eCDomainParameters;
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration object, X962Parameters object2) {
        if (((X962Parameters)object2).isNamedCurve()) {
            ECNamedDomainParameters eCNamedDomainParameters;
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)(object2 = ASN1ObjectIdentifier.getInstance(((X962Parameters)object2).getParameters())));
            if (x9ECParameters == null) {
                x9ECParameters = (X9ECParameters)object.getAdditionalECParameters().get(object2);
            }
            object = eCNamedDomainParameters;
            eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object2, x9ECParameters);
        } else if (((X962Parameters)object2).isImplicitlyCA()) {
            ECDomainParameters eCDomainParameters;
            object = object.getEcImplicitlyCa();
            object2 = eCDomainParameters;
            Object object3 = object;
            object = ((ECParameterSpec)object3).getCurve();
            ECPoint eCPoint = ((ECParameterSpec)object3).getG();
            BigInteger bigInteger = ((ECParameterSpec)object3).getN();
            BigInteger bigInteger2 = ((ECParameterSpec)object3).getH();
            byte[] byArray = ((ECParameterSpec)object3).getSeed();
            eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger2, byArray);
            object = object2;
        } else {
            ECDomainParameters eCDomainParameters;
            object = X9ECParameters.getInstance(((X962Parameters)object2).getParameters());
            object2 = eCDomainParameters;
            Object object4 = object;
            object = ((X9ECParameters)object4).getCurve();
            ECPoint eCPoint = ((X9ECParameters)object4).getG();
            BigInteger bigInteger = ((X9ECParameters)object4).getN();
            BigInteger bigInteger3 = ((X9ECParameters)object4).getH();
            byte[] byArray = ((X9ECParameters)object4).getSeed();
            eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger3, byArray);
            object = object2;
        }
        return object;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey object) {
        byte[] byArray;
        if (object instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey) {
            ECDomainParameters eCDomainParameters;
            object = (com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey)object;
            Object object2 = object.getParameters();
            object = object.getQ();
            ECDomainParameters eCDomainParameters2 = eCDomainParameters;
            ECParameterSpec eCParameterSpec = object2;
            object2 = eCParameterSpec.getCurve();
            ECPoint eCPoint = eCParameterSpec.getG();
            BigInteger bigInteger = eCParameterSpec.getN();
            BigInteger bigInteger2 = eCParameterSpec.getH();
            byte[] byArray2 = eCParameterSpec.getSeed();
            eCDomainParameters = new ECDomainParameters((ECCurve)object2, eCPoint, bigInteger, bigInteger2, byArray2);
            return new ECPublicKeyParameters((ECPoint)object, eCDomainParameters2);
        }
        if (object instanceof ECPublicKey) {
            object = (ECPublicKey)object;
            Object object3 = EC5Util.convertSpec(object.getParams());
            ECPoint eCPoint = EC5Util.convertPoint(object.getParams(), object.getW());
            ECParameterSpec eCParameterSpec = object3;
            object = eCParameterSpec.getCurve();
            object3 = eCParameterSpec.getG();
            BigInteger bigInteger = eCParameterSpec.getN();
            BigInteger bigInteger3 = eCParameterSpec.getH();
            byte[] byArray3 = eCParameterSpec.getSeed();
            return new ECPublicKeyParameters(eCPoint, new ECDomainParameters((ECCurve)object, (ECPoint)object3, bigInteger, bigInteger3, byArray3));
        }
        try {
            byArray = object.getEncoded();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(d.a(exception, b.a("cannot identify EC public key: ")));
        }
        object = byArray;
        if (byArray != null) {
            block9: {
                object = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(object));
                if (!(object instanceof ECPublicKey)) break block9;
                return ECUtil.generatePublicKeyParameter((PublicKey)object);
            }
            throw new InvalidKeyException("cannot identify EC public key.");
        }
        throw new InvalidKeyException("no encoding for EC public key");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey object) {
        byte[] byArray;
        if (object instanceof ECPrivateKey) {
            ECDomainParameters eCDomainParameters;
            Object object2 = (object = (ECPrivateKey)object).getParameters();
            if (object2 == null) {
                object2 = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            }
            if (object.getParameters() instanceof ECNamedCurveParameterSpec) {
                Object object3 = ((ECNamedCurveParameterSpec)object.getParameters()).getName();
                BigInteger bigInteger = object.getD();
                ECParameterSpec eCParameterSpec = object2;
                object = ECNamedCurveTable.getOID((String)object3);
                object2 = eCParameterSpec.getCurve();
                object3 = eCParameterSpec.getG();
                BigInteger bigInteger2 = eCParameterSpec.getN();
                BigInteger bigInteger3 = eCParameterSpec.getH();
                byte[] byArray2 = eCParameterSpec.getSeed();
                return new ECPrivateKeyParameters(bigInteger, (ECDomainParameters)new ECNamedDomainParameters((ASN1ObjectIdentifier)object, (ECCurve)object2, (ECPoint)object3, bigInteger2, bigInteger3, byArray2));
            }
            object = object.getD();
            ECDomainParameters eCDomainParameters2 = eCDomainParameters;
            ECParameterSpec eCParameterSpec = object2;
            object2 = eCParameterSpec.getCurve();
            ECPoint eCPoint = eCParameterSpec.getG();
            BigInteger bigInteger = eCParameterSpec.getN();
            BigInteger bigInteger4 = eCParameterSpec.getH();
            byte[] byArray3 = eCParameterSpec.getSeed();
            eCDomainParameters = new ECDomainParameters((ECCurve)object2, eCPoint, bigInteger, bigInteger4, byArray3);
            return new ECPrivateKeyParameters((BigInteger)object, eCDomainParameters2);
        }
        if (object instanceof java.security.interfaces.ECPrivateKey) {
            object = (java.security.interfaces.ECPrivateKey)object;
            Object object4 = EC5Util.convertSpec(object.getParams());
            BigInteger bigInteger = object.getS();
            ECParameterSpec eCParameterSpec = object4;
            object = eCParameterSpec.getCurve();
            object4 = eCParameterSpec.getG();
            BigInteger bigInteger5 = eCParameterSpec.getN();
            BigInteger bigInteger6 = eCParameterSpec.getH();
            byte[] byArray4 = eCParameterSpec.getSeed();
            return new ECPrivateKeyParameters(bigInteger, new ECDomainParameters((ECCurve)object, (ECPoint)object4, bigInteger5, bigInteger6, byArray4));
        }
        try {
            byArray = object.getEncoded();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(d.a(exception, b.a("cannot identify EC private key: ")));
        }
        object = byArray;
        if (byArray != null) {
            block11: {
                object = BouncyCastleProvider.getPrivateKey(PrivateKeyInfo.getInstance(object));
                if (!(object instanceof java.security.interfaces.ECPrivateKey)) break block11;
                return ECUtil.generatePrivateKeyParameter((PrivateKey)object);
            }
            throw new InvalidKeyException("can't identify EC private key.");
        }
        throw new InvalidKeyException("no encoding for EC private key");
    }

    public static int getOrderBitLength(ProviderConfiguration object, BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            if ((object = object.getEcImplicitlyCa()) == null) {
                return bigInteger2.bitLength();
            }
            return ((ECParameterSpec)object).getN().bitLength();
        }
        return bigInteger.bitLength();
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(String string) {
        block5: {
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            try {
                if (string.charAt(0) < '0') break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (string.charAt(0) > '2') break block5;
            return new ASN1ObjectIdentifier(string);
        }
        return ECNamedCurveTable.getOID(string);
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(ECParameterSpec eCParameterSpec) {
        Enumeration enumeration = ECNamedCurveTable.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
            if (!x9ECParameters.getN().equals(eCParameterSpec.getN()) || !x9ECParameters.getH().equals(eCParameterSpec.getH()) || !x9ECParameters.getCurve().equals(eCParameterSpec.getCurve()) || !x9ECParameters.getG().equals(eCParameterSpec.getG())) continue;
            return ECNamedCurveTable.getOID(string);
        }
        return null;
    }

    public static X9ECParameters getNamedCurveByOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static X9ECParameters getNamedCurveByName(String string) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByName(string);
        }
        return x9ECParameters;
    }

    public static String getCurveName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return ECNamedCurveTable.getName(aSN1ObjectIdentifier);
    }

    public static String privateKeyToString(String string, BigInteger object, ECParameterSpec eCParameterSpec) {
        StringBuffer stringBuffer = new StringBuffer();
        string = Strings.lineSeparator();
        object = new FixedPointCombMultiplier().multiply(eCParameterSpec.getG(), (BigInteger)object).normalize();
        stringBuffer.append(string);
        stringBuffer.append(" Private Key [").append(ECUtil.generateKeyFingerprint((ECPoint)object, eCParameterSpec)).append("]").append(string);
        stringBuffer.append("            X: ").append(((ECPoint)object).getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(((ECPoint)object).getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public static String publicKeyToString(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        StringBuffer stringBuffer = new StringBuffer();
        string = Strings.lineSeparator();
        stringBuffer.append(string);
        stringBuffer.append(" Public Key [").append(ECUtil.generateKeyFingerprint(eCPoint, eCParameterSpec)).append("]").append(string);
        stringBuffer.append("            X: ").append(eCPoint.getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(eCPoint.getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public static String generateKeyFingerprint(ECPoint object, ECParameterSpec object2) {
        Object object3 = ((ECParameterSpec)object2).getCurve();
        object2 = ((ECParameterSpec)object2).getG();
        if (object3 != null) {
            byte[] byArray = ((ECPoint)object).getEncoded(false);
            Object object4 = object2;
            ECCurve eCCurve = object3;
            object = eCCurve.getA().getEncoded();
            object2 = eCCurve.getB().getEncoded();
            object3 = ((ECPoint)object4).getEncoded(false);
            return new Fingerprint(Arrays.concatenate(byArray, (byte[])object, (byte[])object2, (byte[])object3)).toString();
        }
        return new Fingerprint(((ECPoint)object).getEncoded(false)).toString();
    }

    public static String getNameFrom(final AlgorithmParameterSpec algorithmParameterSpec) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return algorithmParameterSpec.getClass().getMethod("getName", new Class[0]).invoke((Object)algorithmParameterSpec, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }
}

