/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PasswordConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PBKDF2Key;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEPBKDF2 {
    private static final Map prfCodes = new HashMap<ASN1ObjectIdentifier, Integer>();

    private PBEPBKDF2() {
    }

    static {
        prfCodes.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(6));
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(1));
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(4));
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(7));
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(8));
        prfCodes.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(9));
        prfCodes.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, Integers.valueOf(11));
        prfCodes.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, Integers.valueOf(10));
        prfCodes.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, Integers.valueOf(12));
        prfCodes.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, Integers.valueOf(13));
        prfCodes.put(GMObjectIdentifiers.hmac_sm3, Integers.valueOf(14));
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = PBEPBKDF2.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ConfigurableProvider configurableProvider2 = configurableProvider;
            String string = PREFIX;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.id_PBKDF2;
            e.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.b.a(b.a(new StringBuilder(), string, "$AlgParams", configurableProvider, "AlgorithmParameters.PBKDF2").append("Alg.Alias.AlgorithmParameters."), aSN1ObjectIdentifier, configurableProvider, "PBKDF2", string), "$PBKDF2withUTF8", configurableProvider, "SecretKeyFactory.PBKDF2");
            configurableProvider2.addAlgorithm(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1", "PBKDF2", "Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1ANDUTF8", "PBKDF2").append("Alg.Alias.SecretKeyFactory.").append(aSN1ObjectIdentifier).toString(), "PBKDF2");
            d.a(new StringBuilder(), string, "$PBKDF2with8BIT", configurableProvider, "SecretKeyFactory.PBKDF2WITHASCII");
            d.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.SecretKeyFactory.PBKDF2WITH8BIT", "PBKDF2WITHASCII", "Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1AND8BIT", "PBKDF2WITHASCII"), string, "$PBKDF2withSHA224", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA224"), string, "$PBKDF2withSHA256", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA256"), string, "$PBKDF2withSHA384", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA384"), string, "$PBKDF2withSHA512", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA512"), string, "$PBKDF2withSHA3_224", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA3-224"), string, "$PBKDF2withSHA3_256", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA3-256"), string, "$PBKDF2withSHA3_384", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA3-384"), string, "$PBKDF2withSHA3_512", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSHA3-512"), string, "$PBKDF2withGOST3411", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACGOST3411"), string, "$PBKDF2withSM3", configurableProvider, "SecretKeyFactory.PBKDF2WITHHMACSM3");
        }
    }

    public static class PBKDF2withSM3
    extends BasePBKDF2 {
        public PBKDF2withSM3() {
            super("PBKDF2", 5, 14);
        }
    }

    public static class PBKDF2with8BIT
    extends BasePBKDF2 {
        public PBKDF2with8BIT() {
            super("PBKDF2", 1);
        }
    }

    public static class PBKDF2withSHA3_512
    extends BasePBKDF2 {
        public PBKDF2withSHA3_512() {
            super("PBKDF2", 5, 13);
        }
    }

    public static class PBKDF2withSHA3_384
    extends BasePBKDF2 {
        public PBKDF2withSHA3_384() {
            super("PBKDF2", 5, 12);
        }
    }

    public static class PBKDF2withSHA3_256
    extends BasePBKDF2 {
        public PBKDF2withSHA3_256() {
            super("PBKDF2", 5, 11);
        }
    }

    public static class PBKDF2withSHA3_224
    extends BasePBKDF2 {
        public PBKDF2withSHA3_224() {
            super("PBKDF2", 5, 10);
        }
    }

    public static class PBKDF2withGOST3411
    extends BasePBKDF2 {
        public PBKDF2withGOST3411() {
            super("PBKDF2", 5, 6);
        }
    }

    public static class PBKDF2withSHA512
    extends BasePBKDF2 {
        public PBKDF2withSHA512() {
            super("PBKDF2", 5, 9);
        }
    }

    public static class PBKDF2withSHA384
    extends BasePBKDF2 {
        public PBKDF2withSHA384() {
            super("PBKDF2", 5, 8);
        }
    }

    public static class PBKDF2withSHA256
    extends BasePBKDF2 {
        public PBKDF2withSHA256() {
            super("PBKDF2", 5, 4);
        }
    }

    public static class PBKDF2withSHA224
    extends BasePBKDF2 {
        public PBKDF2withSHA224() {
            super("PBKDF2", 5, 7);
        }
    }

    public static class PBKDF2withUTF8
    extends BasePBKDF2 {
        public PBKDF2withUTF8() {
            super("PBKDF2", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;
        private int defaultDigest;

        public BasePBKDF2(String string, int n) {
            this(string, n, 1);
        }

        public BasePBKDF2(String string, int n, int n2) {
            super(string, PKCSObjectIdentifiers.id_PBKDF2);
            this.scheme = n;
            this.defaultDigest = n2;
        }

        private int getDigestCode(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
            Integer n = (Integer)prfCodes.get(aSN1ObjectIdentifier);
            if (n != null) {
                return n;
            }
            throw new InvalidKeySpecException(a.a("Invalid KeySpec: unknown PRF algorithm ", aSN1ObjectIdentifier));
        }

        @Override
        public SecretKey engineGenerateSecret(KeySpec object) {
            if (object instanceof PBEKeySpec) {
                if (((PBEKeySpec)(object = (PBEKeySpec)object)).getSalt() == null) {
                    BasePBKDF2 basePBKDF2 = object3;
                    object = ((PBEKeySpec)object).getPassword();
                    PasswordConverter passwordConverter = basePBKDF2.scheme == 1 ? PasswordConverter.ASCII : PasswordConverter.UTF8;
                    Object object2 = object3;
                    ((PBKDF2Key)object2)((char[])object, passwordConverter);
                    return object2;
                }
                if (((PBEKeySpec)object).getIterationCount() > 0) {
                    if (((PBEKeySpec)object).getKeyLength() > 0) {
                        if (((PBEKeySpec)object).getPassword().length != 0) {
                            Object object3;
                            if (object instanceof PBKDF2KeySpec) {
                                int n = super.getDigestCode(((PBKDF2KeySpec)object).getPrf().getAlgorithm());
                                int n2 = ((PBEKeySpec)object).getKeyLength();
                                CipherParameters cipherParameters = PBE.Util.makePBEMacParameters((PBEKeySpec)object, ((BasePBKDF2)object3).scheme, n, n2);
                                Object object4 = object3;
                                object3 = ((BaseSecretKeyFactory)object4).algName;
                                ASN1ObjectIdentifier aSN1ObjectIdentifier = ((BaseSecretKeyFactory)object4).algOid;
                                int n3 = ((BasePBKDF2)object4).scheme;
                                return new BCPBEKey((String)object3, aSN1ObjectIdentifier, n3, n, n2, -1, (PBEKeySpec)object, cipherParameters);
                            }
                            int n = ((BasePBKDF2)object3).defaultDigest;
                            int n4 = ((PBEKeySpec)object).getKeyLength();
                            CipherParameters cipherParameters = PBE.Util.makePBEMacParameters((PBEKeySpec)object, ((BasePBKDF2)object3).scheme, n, n4);
                            Object object5 = object3;
                            object3 = ((BaseSecretKeyFactory)object5).algName;
                            ASN1ObjectIdentifier aSN1ObjectIdentifier = ((BaseSecretKeyFactory)object5).algOid;
                            int n5 = ((BasePBKDF2)object5).scheme;
                            return new BCPBEKey((String)object3, aSN1ObjectIdentifier, n5, n, n4, -1, (PBEKeySpec)object, cipherParameters);
                        }
                        throw new IllegalArgumentException("password empty");
                    }
                    throw new InvalidKeySpecException(b.b.a("positive key length required: ").append(((PBEKeySpec)object).getKeyLength()).toString());
                }
                throw new InvalidKeySpecException(b.b.a("positive iteration count required: ").append(((PBEKeySpec)object).getIterationCount()).toString());
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        public PBKDF2Params params;

        @Override
        public byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException iOException) {
                throw new RuntimeException(b.b.a("Oooops! ").append(((Object)iOException).toString()).toString());
            }
        }

        @Override
        public byte[] engineGetEncoded(String string) {
            if (this.isASN1FormatString(string)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz != PBEParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException("unknown parameter spec passed to PBKDF2 PBE parameters object.");
            }
            return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
        }

        @Override
        public void engineInit(AlgorithmParameterSpec object) {
            if (object instanceof PBEParameterSpec) {
                PBKDF2Params pBKDF2Params;
                AlgParams algParams = object2;
                Object object2 = (PBEParameterSpec)object;
                object = pBKDF2Params;
                Object object3 = object2;
                object2 = ((PBEParameterSpec)object3).getSalt();
                pBKDF2Params = new PBKDF2Params((byte[])object2, ((PBEParameterSpec)object3).getIterationCount());
                algParams.params = object;
                return;
            }
            throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
        }

        @Override
        public void engineInit(byte[] byArray) {
            this.params = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(byArray));
        }

        @Override
        public void engineInit(byte[] byArray, String string) {
            if (this.isASN1FormatString(string)) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in PBKDF2 parameters object");
        }

        @Override
        public String engineToString() {
            return "PBKDF2 Parameters";
        }
    }
}

