/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.MD2Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SM3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.TigerDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int MD2 = 5;
    public static final int GOST3411 = 6;
    public static final int SHA224 = 7;
    public static final int SHA384 = 8;
    public static final int SHA512 = 9;
    public static final int SHA3_224 = 10;
    public static final int SHA3_256 = 11;
    public static final int SHA3_384 = 12;
    public static final int SHA3_512 = 13;
    public static final int SM3 = 14;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S1_UTF8 = 4;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static PBEParametersGenerator makePBEGenerator(int n, int n2) {
            void var0_30;
            void var1_31;
            if (n != 0 && n != 4) {
                if (n != 1 && n != 5) {
                    if (n == 2) {
                        switch (var1_31) {
                            default: {
                                throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                            }
                            case 9: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator2 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA512());
                                return var0_30;
                            }
                            case 8: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator3 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA384());
                                return var0_30;
                            }
                            case 7: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator4 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA224());
                                return var0_30;
                            }
                            case 6: {
                                GOST3411Digest gOST3411Digest;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator5 = pKCS12ParametersGenerator;
                                GOST3411Digest gOST3411Digest2 = gOST3411Digest;
                                gOST3411Digest = new GOST3411Digest();
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(gOST3411Digest2);
                                return var0_30;
                            }
                            case 5: {
                                MD2Digest mD2Digest;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator6 = pKCS12ParametersGenerator;
                                MD2Digest mD2Digest2 = mD2Digest;
                                mD2Digest = new MD2Digest();
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(mD2Digest2);
                                return var0_30;
                            }
                            case 4: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator7 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA256());
                                return var0_30;
                            }
                            case 3: {
                                TigerDigest tigerDigest;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator8 = pKCS12ParametersGenerator;
                                TigerDigest tigerDigest2 = tigerDigest;
                                tigerDigest = new TigerDigest();
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(tigerDigest2);
                                return var0_30;
                            }
                            case 2: {
                                RIPEMD160Digest rIPEMD160Digest;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator9 = pKCS12ParametersGenerator;
                                RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
                                rIPEMD160Digest = new RIPEMD160Digest();
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(rIPEMD160Digest2);
                                return var0_30;
                            }
                            case 1: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator10 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createSHA1());
                                return var0_30;
                            }
                            case 0: {
                                PKCS12ParametersGenerator pKCS12ParametersGenerator;
                                PKCS12ParametersGenerator pKCS12ParametersGenerator11 = pKCS12ParametersGenerator;
                                pKCS12ParametersGenerator = new PKCS12ParametersGenerator(DigestFactory.createMD5());
                                return var0_30;
                            }
                        }
                    } else {
                        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator;
                        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator2 = openSSLPBEParametersGenerator;
                        openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
                    }
                    return var0_30;
                } else {
                    switch (var1_31) {
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE PKCS5S2 encryption.");
                        }
                        case 14: {
                            SM3Digest sM3Digest;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator2 = pKCS5S2ParametersGenerator;
                            SM3Digest sM3Digest2 = sM3Digest;
                            sM3Digest = new SM3Digest();
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(sM3Digest2);
                            return var0_30;
                        }
                        case 13: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator3 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_512());
                            return var0_30;
                        }
                        case 12: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator4 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_384());
                            return var0_30;
                        }
                        case 11: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator5 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_256());
                            return var0_30;
                        }
                        case 10: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator6 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA3_224());
                            return var0_30;
                        }
                        case 9: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator7 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA512());
                            return var0_30;
                        }
                        case 8: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator8 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA384());
                            return var0_30;
                        }
                        case 7: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator9 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA224());
                            return var0_30;
                        }
                        case 6: {
                            GOST3411Digest gOST3411Digest;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator10 = pKCS5S2ParametersGenerator;
                            GOST3411Digest gOST3411Digest3 = gOST3411Digest;
                            gOST3411Digest = new GOST3411Digest();
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(gOST3411Digest3);
                            return var0_30;
                        }
                        case 5: {
                            MD2Digest mD2Digest;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator11 = pKCS5S2ParametersGenerator;
                            MD2Digest mD2Digest3 = mD2Digest;
                            mD2Digest = new MD2Digest();
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(mD2Digest3);
                            return var0_30;
                        }
                        case 4: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator12 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA256());
                            return var0_30;
                        }
                        case 3: {
                            TigerDigest tigerDigest;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator13 = pKCS5S2ParametersGenerator;
                            TigerDigest tigerDigest3 = tigerDigest;
                            tigerDigest = new TigerDigest();
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(tigerDigest3);
                            return var0_30;
                        }
                        case 2: {
                            RIPEMD160Digest rIPEMD160Digest;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator14 = pKCS5S2ParametersGenerator;
                            RIPEMD160Digest rIPEMD160Digest3 = rIPEMD160Digest;
                            rIPEMD160Digest = new RIPEMD160Digest();
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(rIPEMD160Digest3);
                            return var0_30;
                        }
                        case 1: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator15 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createSHA1());
                            return var0_30;
                        }
                        case 0: {
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator16 = pKCS5S2ParametersGenerator;
                            pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(DigestFactory.createMD5());
                            return var0_30;
                        }
                    }
                }
            } else if (var1_31 != false) {
                if (var1_31 != true) {
                    MD2Digest mD2Digest;
                    PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator;
                    if (var1_31 != 5) throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                    PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator2 = pKCS5S1ParametersGenerator;
                    MD2Digest mD2Digest4 = mD2Digest;
                    mD2Digest = new MD2Digest();
                    pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator(mD2Digest4);
                    return var0_30;
                } else {
                    PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator;
                    PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator3 = pKCS5S1ParametersGenerator;
                    pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createSHA1());
                }
                return var0_30;
            } else {
                PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator;
                PKCS5S1ParametersGenerator pKCS5S1ParametersGenerator4 = pKCS5S1ParametersGenerator;
                pKCS5S1ParametersGenerator = new PKCS5S1ParametersGenerator(DigestFactory.createMD5());
            }
            return var0_30;
        }

        public static CipherParameters makePBEParameters(byte[] object, int n, int n2, int n3, int n4, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            if (algorithmParameterSpec != null && algorithmParameterSpec instanceof PBEParameterSpec) {
                Object object2 = (PBEParameterSpec)algorithmParameterSpec;
                PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
                PBEParameterSpec pBEParameterSpec = object2;
                object2 = pBEParameterSpec.getSalt();
                int n5 = pBEParameterSpec.getIterationCount();
                pBEParametersGenerator.init((byte[])object, (byte[])object2, n5);
                object = n4 != 0 ? (Object)pBEParametersGenerator.generateDerivedParameters(n3, n4) : (Object)pBEParametersGenerator.generateDerivedParameters(n3);
                if (string.startsWith("DES")) {
                    if (object instanceof ParametersWithIV) {
                        DESParameters.setOddParity(((KeyParameter)((ParametersWithIV)object).getParameters()).getKey());
                    } else {
                        DESParameters.setOddParity(((KeyParameter)object).getKey());
                    }
                }
                return object;
            }
            throw new InvalidAlgorithmParameterException("Need a PBEParameter spec with a PBE key.");
        }

        public static CipherParameters makePBEParameters(BCPBEKey object, AlgorithmParameterSpec object2, String string) {
            if (object2 != null && object2 instanceof PBEParameterSpec) {
                BCPBEKey bCPBEKey = object;
                object2 = (PBEParameterSpec)object2;
                PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), ((BCPBEKey)object).getDigest());
                byte[] byArray = bCPBEKey.getEncoded();
                if (bCPBEKey.shouldTryWrongPKCS12()) {
                    byArray = new byte[2];
                }
                AlgorithmParameterSpec algorithmParameterSpec = object2;
                object2 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
                pBEParametersGenerator.init(byArray, (byte[])object2, ((PBEParameterSpec)algorithmParameterSpec).getIterationCount());
                if (((BCPBEKey)object).getIvSize() != 0) {
                    BCPBEKey bCPBEKey2 = object;
                    int n = bCPBEKey2.getKeySize();
                    object = pBEParametersGenerator.generateDerivedParameters(n, bCPBEKey2.getIvSize());
                } else {
                    object = pBEParametersGenerator.generateDerivedParameters(((BCPBEKey)object).getKeySize());
                }
                if (string.startsWith("DES")) {
                    if (object instanceof ParametersWithIV) {
                        DESParameters.setOddParity(((KeyParameter)((ParametersWithIV)object).getParameters()).getKey());
                    } else {
                        DESParameters.setOddParity(((KeyParameter)object).getKey());
                    }
                }
                return object;
            }
            throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
        }

        public static CipherParameters makePBEMacParameters(BCPBEKey object, AlgorithmParameterSpec object2) {
            if (object2 != null && object2 instanceof PBEParameterSpec) {
                object2 = (PBEParameterSpec)object2;
                PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(((BCPBEKey)object).getType(), ((BCPBEKey)object).getDigest());
                AlgorithmParameterSpec algorithmParameterSpec = object2;
                object = ((BCPBEKey)object).getEncoded();
                object2 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
                int n = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
                pBEParametersGenerator.init((byte[])object, (byte[])object2, n);
                return pBEParametersGenerator.generateDerivedMacParameters(((BCPBEKey)object).getKeySize());
            }
            throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
        }

        public static CipherParameters makePBEMacParameters(PBEKeySpec object, int n, int n2, int n3) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            PBEKeySpec pBEKeySpec = object;
            object = Util.convertPassword(n, (PBEKeySpec)object);
            Object object2 = pBEKeySpec.getSalt();
            n2 = pBEKeySpec.getIterationCount();
            pBEParametersGenerator.init((byte[])object, (byte[])object2, n2);
            object2 = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (n2 = 0; n2 != ((Object)object).length; ++n2) {
                object[n2] = false;
            }
            return object2;
        }

        public static CipherParameters makePBEParameters(PBEKeySpec object, int n, int n2, int n3, int n4) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            PBEKeySpec pBEKeySpec = object;
            object = Util.convertPassword(n, (PBEKeySpec)object);
            Object object2 = pBEKeySpec.getSalt();
            int n5 = pBEKeySpec.getIterationCount();
            pBEParametersGenerator.init((byte[])object, (byte[])object2, n5);
            object2 = n4 != 0 ? (Object)pBEParametersGenerator.generateDerivedParameters(n3, n4) : (Object)pBEParametersGenerator.generateDerivedParameters(n3);
            for (int k = 0; k != ((Object)object).length; ++k) {
                object[k] = false;
            }
            return object2;
        }

        public static CipherParameters makePBEMacParameters(SecretKey object, int n, int n2, int n3, PBEParameterSpec pBEParameterSpec) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n, n2);
            PBEParameterSpec pBEParameterSpec2 = pBEParameterSpec;
            SecretKey secretKey = object;
            object = secretKey.getEncoded();
            Object object2 = secretKey.getEncoded();
            byte[] byArray = pBEParameterSpec2.getSalt();
            int n4 = pBEParameterSpec2.getIterationCount();
            pBEParametersGenerator.init((byte[])object2, byArray, n4);
            object2 = pBEParametersGenerator.generateDerivedMacParameters(n3);
            for (int k = 0; k != ((Object)object).length; ++k) {
                object[k] = false;
            }
            return object2;
        }

        private static byte[] convertPassword(int n, PBEKeySpec pBEKeySpec) {
            return n == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(pBEKeySpec.getPassword()) : (n != 5 && n != 4 ? PBEParametersGenerator.PKCS5PasswordToBytes(pBEKeySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pBEKeySpec.getPassword()));
        }
    }
}

