/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DigestFactory {
    private static Set md5 = new HashSet();
    private static Set sha1 = new HashSet();
    private static Set sha224 = new HashSet();
    private static Set sha256 = new HashSet();
    private static Set sha384 = new HashSet();
    private static Set sha512 = new HashSet();
    private static Set sha512_224 = new HashSet();
    private static Set sha512_256 = new HashSet();
    private static Set sha3_224 = new HashSet();
    private static Set sha3_256 = new HashSet();
    private static Set sha3_384 = new HashSet();
    private static Set sha3_512 = new HashSet();
    private static Map oids = new HashMap();

    public static Digest getDigest(String string) {
        if (sha1.contains(string = Strings.toUpperCase(string))) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA1();
        }
        if (md5.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createMD5();
        }
        if (sha224.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA224();
        }
        if (sha256.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA256();
        }
        if (sha384.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA384();
        }
        if (sha512.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA512();
        }
        if (sha512_224.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA512_224();
        }
        if (sha512_256.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA512_256();
        }
        if (sha3_224.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA3_224();
        }
        if (sha3_256.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA3_256();
        }
        if (sha3_384.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA3_384();
        }
        if (sha3_512.contains(string)) {
            return com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory.createSHA3_512();
        }
        return null;
    }

    public static boolean isSameDigest(String string, String string2) {
        return sha1.contains(string) && sha1.contains(string2) || sha224.contains(string) && sha224.contains(string2) || sha256.contains(string) && sha256.contains(string2) || sha384.contains(string) && sha384.contains(string2) || sha512.contains(string) && sha512.contains(string2) || sha512_224.contains(string) && sha512_224.contains(string2) || sha512_256.contains(string) && sha512_256.contains(string2) || sha3_224.contains(string) && sha3_224.contains(string2) || sha3_256.contains(string) && sha3_256.contains(string2) || sha3_384.contains(string) && sha3_384.contains(string2) || sha3_512.contains(string) && sha3_512.contains(string2) || md5.contains(string) && md5.contains(string2);
    }

    public static ASN1ObjectIdentifier getOID(String string) {
        return (ASN1ObjectIdentifier)oids.get(string);
    }

    static {
        md5.add("MD5");
        ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.md5;
        md5.add(aSN1ObjectIdentifier.getId());
        sha1.add("SHA1");
        sha1.add("SHA-1");
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = OIWObjectIdentifiers.idSHA1;
        sha1.add(aSN1ObjectIdentifier2.getId());
        sha224.add("SHA224");
        sha224.add("SHA-224");
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = NISTObjectIdentifiers.id_sha224;
        sha224.add(aSN1ObjectIdentifier3.getId());
        sha256.add("SHA256");
        sha256.add("SHA-256");
        ASN1ObjectIdentifier aSN1ObjectIdentifier4 = NISTObjectIdentifiers.id_sha256;
        sha256.add(aSN1ObjectIdentifier4.getId());
        sha384.add("SHA384");
        sha384.add("SHA-384");
        ASN1ObjectIdentifier aSN1ObjectIdentifier5 = NISTObjectIdentifiers.id_sha384;
        sha384.add(aSN1ObjectIdentifier5.getId());
        sha512.add("SHA512");
        sha512.add("SHA-512");
        ASN1ObjectIdentifier aSN1ObjectIdentifier6 = NISTObjectIdentifiers.id_sha512;
        sha512.add(aSN1ObjectIdentifier6.getId());
        sha512_224.add("SHA512(224)");
        sha512_224.add("SHA-512(224)");
        ASN1ObjectIdentifier aSN1ObjectIdentifier7 = NISTObjectIdentifiers.id_sha512_224;
        sha512_224.add(aSN1ObjectIdentifier7.getId());
        sha512_256.add("SHA512(256)");
        sha512_256.add("SHA-512(256)");
        ASN1ObjectIdentifier aSN1ObjectIdentifier8 = NISTObjectIdentifiers.id_sha512_256;
        sha512_256.add(aSN1ObjectIdentifier8.getId());
        sha3_224.add("SHA3-224");
        ASN1ObjectIdentifier aSN1ObjectIdentifier9 = NISTObjectIdentifiers.id_sha3_224;
        sha3_224.add(aSN1ObjectIdentifier9.getId());
        sha3_256.add("SHA3-256");
        ASN1ObjectIdentifier aSN1ObjectIdentifier10 = NISTObjectIdentifiers.id_sha3_256;
        sha3_256.add(aSN1ObjectIdentifier10.getId());
        sha3_384.add("SHA3-384");
        ASN1ObjectIdentifier aSN1ObjectIdentifier11 = NISTObjectIdentifiers.id_sha3_384;
        sha3_384.add(aSN1ObjectIdentifier11.getId());
        sha3_512.add("SHA3-512");
        ASN1ObjectIdentifier aSN1ObjectIdentifier12 = NISTObjectIdentifiers.id_sha3_512;
        sha3_512.add(aSN1ObjectIdentifier12.getId());
        oids.put("MD5", aSN1ObjectIdentifier);
        oids.put(aSN1ObjectIdentifier.getId(), aSN1ObjectIdentifier);
        oids.put("SHA1", aSN1ObjectIdentifier2);
        oids.put("SHA-1", aSN1ObjectIdentifier2);
        oids.put(aSN1ObjectIdentifier2.getId(), aSN1ObjectIdentifier2);
        oids.put("SHA224", aSN1ObjectIdentifier3);
        oids.put("SHA-224", aSN1ObjectIdentifier3);
        oids.put(aSN1ObjectIdentifier3.getId(), aSN1ObjectIdentifier3);
        oids.put("SHA256", aSN1ObjectIdentifier4);
        oids.put("SHA-256", aSN1ObjectIdentifier4);
        oids.put(aSN1ObjectIdentifier4.getId(), aSN1ObjectIdentifier4);
        oids.put("SHA384", aSN1ObjectIdentifier5);
        oids.put("SHA-384", aSN1ObjectIdentifier5);
        oids.put(aSN1ObjectIdentifier5.getId(), aSN1ObjectIdentifier5);
        oids.put("SHA512", aSN1ObjectIdentifier6);
        oids.put("SHA-512", aSN1ObjectIdentifier6);
        oids.put(aSN1ObjectIdentifier6.getId(), aSN1ObjectIdentifier6);
        oids.put("SHA512(224)", aSN1ObjectIdentifier7);
        oids.put("SHA-512(224)", aSN1ObjectIdentifier7);
        oids.put(aSN1ObjectIdentifier7.getId(), aSN1ObjectIdentifier7);
        oids.put("SHA512(256)", aSN1ObjectIdentifier8);
        oids.put("SHA-512(256)", aSN1ObjectIdentifier8);
        oids.put(aSN1ObjectIdentifier8.getId(), aSN1ObjectIdentifier8);
        oids.put("SHA3-224", aSN1ObjectIdentifier9);
        oids.put(aSN1ObjectIdentifier9.getId(), aSN1ObjectIdentifier9);
        oids.put("SHA3-256", aSN1ObjectIdentifier10);
        oids.put(aSN1ObjectIdentifier10.getId(), aSN1ObjectIdentifier10);
        oids.put("SHA3-384", aSN1ObjectIdentifier11);
        oids.put(aSN1ObjectIdentifier11.getId(), aSN1ObjectIdentifier11);
        oids.put("SHA3-512", aSN1ObjectIdentifier12);
        oids.put(aSN1ObjectIdentifier12.getId(), aSN1ObjectIdentifier12);
    }
}

