/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.CertificationRequest;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import d.a;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable algorithms;
    private static Hashtable params;
    private static Hashtable keyAlgorithms;
    private static Hashtable oids;
    private static Set noParams;

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier aSN1Object, int n) {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2 = aSN1Object;
        AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, aSN1Object);
        aSN1Object = aSN1Integer2;
        aSN1Integer2 = new ASN1Integer(n);
        ASN1Integer aSN1Integer3 = aSN1Integer;
        aSN1Integer = new ASN1Integer(1L);
        return new RSASSAPSSparams(algorithmIdentifier2, algorithmIdentifier3, (ASN1Integer)aSN1Object, aSN1Integer3);
    }

    private static ASN1Sequence toDERSequence(byte[] byArray) {
        try {
            return (ASN1Sequence)new ASN1InputStream(byArray).readObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public PKCS10CertificationRequest(byte[] byArray) {
        super(PKCS10CertificationRequest.toDERSequence(byArray));
    }

    public PKCS10CertificationRequest(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence);
    }

    public PKCS10CertificationRequest(String string, X509Name x509Name, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey) {
        this(string, x509Name, publicKey, aSN1Set, privateKey, "BC");
    }

    private static X509Name convertName(X500Principal x500Principal) {
        try {
            return new X509Principal(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't convert name");
        }
    }

    public PKCS10CertificationRequest(String string, X500Principal x500Principal, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey) {
        this(string, PKCS10CertificationRequest.convertName(x500Principal), publicKey, aSN1Set, privateKey, "BC");
    }

    public PKCS10CertificationRequest(String string, X500Principal x500Principal, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey, String string2) {
        this(string, PKCS10CertificationRequest.convertName(x500Principal), publicKey, aSN1Set, privateKey, string2);
    }

    public PKCS10CertificationRequest(String object, X509Name x509Name, PublicKey object2, ASN1Set aSN1Set, PrivateKey privateKey, String string) {
        Object object3 = Strings.toUpperCase((String)object);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)algorithms.get(object3);
        if (aSN1ObjectIdentifier == null) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2;
            aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
            try {
                aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier((String)object3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unknown signature type requested");
            }
        }
        if (x509Name != null) {
            if (object2 != null) {
                String string2;
                if (noParams.contains(aSN1ObjectIdentifier)) {
                    AlgorithmIdentifier algorithmIdentifier;
                    object3 = algorithmIdentifier;
                    algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier);
                    this.sigAlgId = object3;
                } else if (params.containsKey(object3)) {
                    this.sigAlgId = new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)params.get(object3));
                } else {
                    AlgorithmIdentifier algorithmIdentifier;
                    object3 = algorithmIdentifier;
                    algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
                    this.sigAlgId = object3;
                }
                try {
                    string2 = string;
                    PKCS10CertificationRequest pKCS10CertificationRequest = this;
                    object2 = (ASN1Sequence)ASN1Primitive.fromByteArray(object2.getEncoded());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("can't encode public key");
                }
                pKCS10CertificationRequest.reqInfo = new CertificationRequestInfo(x509Name, SubjectPublicKeyInfo.getInstance(object2), aSN1Set);
                object = string2 == null ? Signature.getInstance((String)object) : Signature.getInstance((String)object, string);
                ((Signature)object).initSign(privateKey);
                try {
                    ((Signature)object).update(this.reqInfo.getEncoded("DER"));
                    this.sigBits = new DERBitString(((Signature)object).sign());
                    return;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(f.a.a("exception encoding TBS cert request - ", exception));
                }
            }
            throw new IllegalArgumentException("public key must not be null");
        }
        throw new IllegalArgumentException("subject must not be null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSignatureParameters(Signature signature, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null || DERNull.INSTANCE.equals(aSN1Encodable)) return;
        Signature signature2 = signature;
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(signature2.getAlgorithm(), signature.getProvider());
        try {
            algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            if (!signature2.getAlgorithm().endsWith("MGF1")) return;
        }
        catch (IOException iOException) {
            throw new SignatureException(b.a(iOException, b.b.a("IOException decoding parameters: ")));
        }
        try {
            signature.setParameter(algorithmParameters.getParameterSpec(PSSParameterSpec.class));
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(b.b.a("Exception extracting parameters: ").append(generalSecurityException.getMessage()).toString());
        }
    }

    public static String getSignatureName(AlgorithmIdentifier aSN1Object) {
        ASN1Encodable aSN1Encodable = ((AlgorithmIdentifier)aSN1Object).getParameters();
        if (aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable) && ((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            aSN1Object = RSASSAPSSparams.getInstance(aSN1Encodable);
            return a.a(new StringBuilder(), PKCS10CertificationRequest.getDigestAlgName(((RSASSAPSSparams)aSN1Object).getHashAlgorithm().getAlgorithm()), "withRSAandMGF1");
        }
        return ((AlgorithmIdentifier)aSN1Object).getAlgorithm().getId();
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(aSN1ObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(aSN1ObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(aSN1ObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(aSN1ObjectIdentifier)) {
            return "GOST3411";
        }
        return aSN1ObjectIdentifier.getId();
    }

    static {
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2;
        AlgorithmIdentifier algorithmIdentifier3;
        AlgorithmIdentifier algorithmIdentifier4;
        AlgorithmIdentifier algorithmIdentifier5;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier3;
        ASN1ObjectIdentifier aSN1ObjectIdentifier4;
        ASN1ObjectIdentifier aSN1ObjectIdentifier5;
        ASN1ObjectIdentifier aSN1ObjectIdentifier6;
        ASN1ObjectIdentifier aSN1ObjectIdentifier7;
        ASN1ObjectIdentifier aSN1ObjectIdentifier8;
        ASN1ObjectIdentifier aSN1ObjectIdentifier9;
        ASN1ObjectIdentifier aSN1ObjectIdentifier10;
        algorithms = new Hashtable();
        params = new Hashtable();
        keyAlgorithms = new Hashtable();
        oids = new Hashtable();
        noParams = new HashSet();
        ASN1Object aSN1Object = aSN1ObjectIdentifier10;
        aSN1ObjectIdentifier10 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.2");
        algorithms.put("MD2WITHRSAENCRYPTION", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier9;
        aSN1ObjectIdentifier9 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.2");
        algorithms.put("MD2WITHRSA", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier8;
        aSN1ObjectIdentifier8 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.4");
        algorithms.put("MD5WITHRSAENCRYPTION", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier7;
        aSN1ObjectIdentifier7 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.4");
        algorithms.put("MD5WITHRSA", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier6;
        aSN1ObjectIdentifier6 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.4");
        algorithms.put("RSAWITHMD5", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier5;
        aSN1ObjectIdentifier5 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5");
        algorithms.put("SHA1WITHRSAENCRYPTION", aSN1Object);
        aSN1Object = aSN1ObjectIdentifier4;
        aSN1ObjectIdentifier4 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5");
        algorithms.put("SHA1WITHRSA", aSN1Object);
        aSN1Object = PKCSObjectIdentifiers.sha224WithRSAEncryption;
        algorithms.put("SHA224WITHRSAENCRYPTION", aSN1Object);
        algorithms.put("SHA224WITHRSA", aSN1Object);
        ASN1Primitive aSN1Primitive = PKCSObjectIdentifiers.sha256WithRSAEncryption;
        algorithms.put("SHA256WITHRSAENCRYPTION", aSN1Primitive);
        algorithms.put("SHA256WITHRSA", aSN1Primitive);
        ASN1ObjectIdentifier aSN1ObjectIdentifier11 = PKCSObjectIdentifiers.sha384WithRSAEncryption;
        algorithms.put("SHA384WITHRSAENCRYPTION", aSN1ObjectIdentifier11);
        algorithms.put("SHA384WITHRSA", aSN1ObjectIdentifier11);
        ASN1ObjectIdentifier aSN1ObjectIdentifier12 = PKCSObjectIdentifiers.sha512WithRSAEncryption;
        algorithms.put("SHA512WITHRSAENCRYPTION", aSN1ObjectIdentifier12);
        algorithms.put("SHA512WITHRSA", aSN1ObjectIdentifier12);
        ASN1ObjectIdentifier aSN1ObjectIdentifier13 = PKCSObjectIdentifiers.id_RSASSA_PSS;
        algorithms.put("SHA1WITHRSAANDMGF1", aSN1ObjectIdentifier13);
        algorithms.put("SHA224WITHRSAANDMGF1", aSN1ObjectIdentifier13);
        algorithms.put("SHA256WITHRSAANDMGF1", aSN1ObjectIdentifier13);
        algorithms.put("SHA384WITHRSAANDMGF1", aSN1ObjectIdentifier13);
        algorithms.put("SHA512WITHRSAANDMGF1", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = aSN1ObjectIdentifier3;
        aSN1ObjectIdentifier3 = new ASN1ObjectIdentifier("1.2.840.113549.1.1.5");
        algorithms.put("RSAWITHSHA1", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128;
        algorithms.put("RIPEMD128WITHRSAENCRYPTION", aSN1ObjectIdentifier13);
        algorithms.put("RIPEMD128WITHRSA", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160;
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", aSN1ObjectIdentifier13);
        algorithms.put("RIPEMD160WITHRSA", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256;
        algorithms.put("RIPEMD256WITHRSAENCRYPTION", aSN1ObjectIdentifier13);
        algorithms.put("RIPEMD256WITHRSA", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = aSN1ObjectIdentifier2;
        aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier("1.2.840.10040.4.3");
        algorithms.put("SHA1WITHDSA", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.840.10040.4.3");
        algorithms.put("DSAWITHSHA1", aSN1ObjectIdentifier13);
        aSN1ObjectIdentifier13 = NISTObjectIdentifiers.dsa_with_sha224;
        algorithms.put("SHA224WITHDSA", aSN1ObjectIdentifier13);
        ASN1ObjectIdentifier aSN1ObjectIdentifier14 = NISTObjectIdentifiers.dsa_with_sha256;
        algorithms.put("SHA256WITHDSA", aSN1ObjectIdentifier14);
        algorithms.put("SHA384WITHDSA", NISTObjectIdentifiers.dsa_with_sha384);
        algorithms.put("SHA512WITHDSA", NISTObjectIdentifiers.dsa_with_sha512);
        ASN1ObjectIdentifier aSN1ObjectIdentifier15 = X9ObjectIdentifiers.ecdsa_with_SHA1;
        algorithms.put("SHA1WITHECDSA", aSN1ObjectIdentifier15);
        ASN1ObjectIdentifier aSN1ObjectIdentifier16 = X9ObjectIdentifiers.ecdsa_with_SHA224;
        algorithms.put("SHA224WITHECDSA", aSN1ObjectIdentifier16);
        ASN1ObjectIdentifier aSN1ObjectIdentifier17 = X9ObjectIdentifiers.ecdsa_with_SHA256;
        algorithms.put("SHA256WITHECDSA", aSN1ObjectIdentifier17);
        ASN1ObjectIdentifier aSN1ObjectIdentifier18 = X9ObjectIdentifiers.ecdsa_with_SHA384;
        algorithms.put("SHA384WITHECDSA", aSN1ObjectIdentifier18);
        ASN1ObjectIdentifier aSN1ObjectIdentifier19 = X9ObjectIdentifiers.ecdsa_with_SHA512;
        algorithms.put("SHA512WITHECDSA", aSN1ObjectIdentifier19);
        algorithms.put("ECDSAWITHSHA1", aSN1ObjectIdentifier15);
        ASN1ObjectIdentifier aSN1ObjectIdentifier20 = CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94;
        algorithms.put("GOST3411WITHGOST3410", aSN1ObjectIdentifier20);
        algorithms.put("GOST3410WITHGOST3411", aSN1ObjectIdentifier20);
        ASN1ObjectIdentifier aSN1ObjectIdentifier21 = CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001;
        algorithms.put("GOST3411WITHECGOST3410", aSN1ObjectIdentifier21);
        algorithms.put("GOST3411WITHECGOST3410-2001", aSN1ObjectIdentifier21);
        algorithms.put("GOST3411WITHGOST3410-2001", aSN1ObjectIdentifier21);
        oids.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(aSN1Object, "SHA224WITHRSA");
        oids.put(aSN1Primitive, "SHA256WITHRSA");
        oids.put(aSN1ObjectIdentifier11, "SHA384WITHRSA");
        oids.put(aSN1ObjectIdentifier12, "SHA512WITHRSA");
        oids.put(aSN1ObjectIdentifier20, "GOST3411WITHGOST3410");
        oids.put(aSN1ObjectIdentifier21, "GOST3411WITHECGOST3410");
        oids.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        oids.put(new ASN1ObjectIdentifier("1.2.840.10040.4.3"), "SHA1WITHDSA");
        oids.put(aSN1ObjectIdentifier15, "SHA1WITHECDSA");
        oids.put(aSN1ObjectIdentifier16, "SHA224WITHECDSA");
        oids.put(aSN1ObjectIdentifier17, "SHA256WITHECDSA");
        oids.put(aSN1ObjectIdentifier18, "SHA384WITHECDSA");
        oids.put(aSN1ObjectIdentifier19, "SHA512WITHECDSA");
        oids.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        aSN1Object = OIWObjectIdentifiers.dsaWithSHA1;
        oids.put(aSN1Object, "SHA1WITHDSA");
        oids.put(aSN1ObjectIdentifier13, "SHA224WITHDSA");
        oids.put(aSN1ObjectIdentifier14, "SHA256WITHDSA");
        keyAlgorithms.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        keyAlgorithms.put(X9ObjectIdentifiers.id_dsa, "DSA");
        noParams.add(aSN1ObjectIdentifier15);
        noParams.add(aSN1ObjectIdentifier16);
        noParams.add(aSN1ObjectIdentifier17);
        noParams.add(aSN1ObjectIdentifier18);
        noParams.add(aSN1ObjectIdentifier19);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(aSN1Object);
        noParams.add(aSN1ObjectIdentifier13);
        noParams.add(aSN1ObjectIdentifier14);
        noParams.add(aSN1ObjectIdentifier20);
        noParams.add(aSN1ObjectIdentifier21);
        aSN1Object = algorithmIdentifier5;
        aSN1Primitive = DERNull.INSTANCE;
        algorithmIdentifier5 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, aSN1Primitive);
        params.put("SHA1WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams((AlgorithmIdentifier)aSN1Object, 20));
        aSN1Object = algorithmIdentifier4;
        algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, aSN1Primitive);
        params.put("SHA224WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams((AlgorithmIdentifier)aSN1Object, 28));
        aSN1Object = algorithmIdentifier3;
        algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, aSN1Primitive);
        params.put("SHA256WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams((AlgorithmIdentifier)aSN1Object, 32));
        aSN1Object = algorithmIdentifier2;
        algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, aSN1Primitive);
        params.put("SHA384WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams((AlgorithmIdentifier)aSN1Object, 48));
        aSN1Object = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, aSN1Primitive);
        params.put("SHA512WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams((AlgorithmIdentifier)aSN1Object, 64));
    }

    public PublicKey getPublicKey() {
        return this.getPublicKey("BC");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PublicKey getPublicKey(String string) {
        X509EncodedKeySpec x509EncodedKeySpec;
        Object object = ((CertificationRequest)object).reqInfo.getSubjectPublicKeyInfo();
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)object).getOctets());
        object = ((SubjectPublicKeyInfo)object).getAlgorithm();
        if (string != null) return KeyFactory.getInstance(((AlgorithmIdentifier)object).getAlgorithm().getId(), string).generatePublic(x509EncodedKeySpec2);
        try {
            return KeyFactory.getInstance(((AlgorithmIdentifier)object).getAlgorithm().getId()).generatePublic(x509EncodedKeySpec2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (keyAlgorithms.get(((AlgorithmIdentifier)object).getAlgorithm()) == null) throw noSuchAlgorithmException;
            object = (String)keyAlgorithms.get(((AlgorithmIdentifier)object).getAlgorithm());
            if (string != null) return KeyFactory.getInstance((String)object, string).generatePublic(x509EncodedKeySpec2);
            try {
                return KeyFactory.getInstance((String)object).generatePublic(x509EncodedKeySpec2);
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("error decoding public key");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("error decoding public key");
            }
        }
    }

    public boolean verify() {
        return this.verify("BC");
    }

    public boolean verify(String string) {
        PKCS10CertificationRequest pKCS10CertificationRequest = this;
        return pKCS10CertificationRequest.verify(pKCS10CertificationRequest.getPublicKey(string), string);
    }

    /*
     * Unable to fully structure code
     */
    public boolean verify(PublicKey var1_2, String var2_3) {
        block8: {
            block7: {
                if (var2_3 == null) {
                    v0 = Signature.getInstance(PKCS10CertificationRequest.getSignatureName(this.sigAlgId));
lbl4:
                    // 2 sources

                    while (true) {
                        var2_3 = v0;
                        break block7;
                        break;
                    }
                }
                try {
                    v0 = Signature.getInstance(PKCS10CertificationRequest.getSignatureName(this.sigAlgId), (String)var2_3);
                    ** continue;
                }
                catch (NoSuchAlgorithmException var3_4) {
                    if (PKCS10CertificationRequest.oids.get(this.sigAlgId.getAlgorithm()) == null) break block8;
                    var3_5 = (String)PKCS10CertificationRequest.oids.get(this.sigAlgId.getAlgorithm());
                    var2_3 = var2_3 == null ? Signature.getInstance(var3_5) : Signature.getInstance(var3_5, (String)var2_3);
                }
            }
            this.setSignatureParameters((Signature)var2_3, this.sigAlgId.getParameters());
            var2_3.initVerify(var1_2);
            try {
                var2_3.update(this.reqInfo.getEncoded("DER"));
            }
            catch (Exception var0_1) {
                throw new SignatureException(f.a.a("exception encoding TBS cert request - ", var0_1));
            }
            return var2_3.verify(this.sigBits.getOctets());
        }
        throw var3_4;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException(((Object)iOException).toString());
        }
    }
}

