/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertificateStructure;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PrincipalUtil {
    public static X509Principal getIssuerX509Principal(X509Certificate object) {
        try {
            object = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)object).getTBSCertificate()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(((Object)iOException).toString());
        }
        return new X509Principal(X509Name.getInstance(((TBSCertificateStructure)object).getIssuer()));
    }

    public static X509Principal getSubjectX509Principal(X509Certificate object) {
        try {
            object = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)object).getTBSCertificate()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(((Object)iOException).toString());
        }
        return new X509Principal(X509Name.getInstance(((TBSCertificateStructure)object).getSubject()));
    }

    public static X509Principal getIssuerX509Principal(X509CRL object) {
        try {
            object = TBSCertList.getInstance(ASN1Primitive.fromByteArray(((X509CRL)object).getTBSCertList()));
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
        return new X509Principal(X509Name.getInstance(((TBSCertList)object).getIssuer()));
    }
}

